/*
 * Decompiled with CFR 0.152.
 */
package com.helger.http;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mime.MimeTypeParserException;
import com.helger.http.AbstractQValueList;
import com.helger.http.AcceptMimeTypeHandler;
import com.helger.http.QValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class AcceptMimeTypeList
extends AbstractQValueList<IMimeType> {
    @Nonnull
    public AcceptMimeTypeList addMimeType(@Nonnull @Nonempty String string, @Nonnegative double d) throws MimeTypeParserException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MimeType");
        this.addMimeType((IMimeType)MimeTypeParser.parseMimeType((String)string), d);
        return this;
    }

    public void addMimeType(@Nonnull IMimeType iMimeType, @Nonnegative double d) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        ValueEnforcer.isFalse((boolean)iMimeType.hasAnyParameters(), (String)"MimeTypes used here may not contain any parameter!");
        this.qvalueMap().put((Object)iMimeType, (Object)new QValue(d));
    }

    @Nonnull
    public QValue getQValueOfMimeType(@Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        IMimeType iMimeType2 = iMimeType.getCopyWithoutParameters();
        QValue qValue = (QValue)this.qvalueMap().get((Object)iMimeType2);
        if (qValue == null && (qValue = (QValue)this.qvalueMap().get((Object)iMimeType2.getContentType().buildMimeType("*"))) == null && (qValue = (QValue)this.qvalueMap().get((Object)AcceptMimeTypeHandler.ANY_MIMETYPE)) == null) {
            return QValue.MIN_QVALUE;
        }
        return qValue;
    }

    public double getQualityOfMimeType(@Nonnull String string) {
        return this.getQualityOfMimeType((IMimeType)MimeTypeParser.safeParseMimeType((String)string));
    }

    public double getQualityOfMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return 0.0;
        }
        return this.getQValueOfMimeType(iMimeType).getQuality();
    }

    public boolean supportsMimeType(@Nonnull String string) {
        return this.supportsMimeType((IMimeType)MimeTypeParser.safeParseMimeType((String)string));
    }

    public boolean supportsMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return false;
        }
        return this.getQValueOfMimeType(iMimeType).isAboveMinimumQuality();
    }

    public boolean explicitlySupportsMimeType(@Nonnull String string) {
        return this.explicitlySupportsMimeType((IMimeType)MimeTypeParser.safeParseMimeType((String)string));
    }

    public boolean explicitlySupportsMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return false;
        }
        QValue qValue = (QValue)this.qvalueMap().get((Object)iMimeType);
        return qValue != null && qValue.isAboveMinimumQuality();
    }

    @Nullable
    public IMimeType getPreferredMimeType(IMimeType ... iMimeTypeArray) {
        IMimeType iMimeType = null;
        QValue qValue = null;
        if (iMimeTypeArray != null) {
            for (IMimeType iMimeType2 : iMimeTypeArray) {
                QValue qValue2 = this.getQValueOfMimeType(iMimeType2);
                if (!qValue2.isAboveMinimumQuality() || qValue != null && qValue2.compareTo(qValue) <= 0) continue;
                iMimeType = iMimeType2;
                qValue = qValue2;
            }
        }
        return iMimeType;
    }

    @Override
    @Nonnull
    public String getAsHttpHeaderValue() {
        return this.getAsHttpHeaderValue(IMimeType::getAsString);
    }
}

