/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.functional.Predicates;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.network.proxy.settings.IProxySettings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProxySettings
implements IProxySettings {
    private final Proxy.Type m_eProxyType;
    private final String m_sProxyHost;
    private final int m_nProxyPort;
    private final String m_sProxyUserName;
    private final String m_sProxyPassword;

    public ProxySettings(@Nonnull Proxy.Type type, @Nullable String string, @Nonnegative int n) {
        this(type, string, n, null, null);
    }

    public ProxySettings(@Nonnull Proxy.Type type, @Nullable String string, @Nonnegative int n, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notNull((Object)((Object)type), (String)"ProxyType");
        this.m_eProxyType = type;
        this.m_sProxyHost = string;
        this.m_nProxyPort = n;
        this.m_sProxyUserName = string2;
        this.m_sProxyPassword = string3;
    }

    @Override
    @Nonnull
    public final Proxy.Type getProxyType() {
        return this.m_eProxyType;
    }

    @Override
    @Nullable
    public final String getProxyHost() {
        return this.m_sProxyHost;
    }

    @Override
    @Nonnegative
    public final int getProxyPort() {
        return this.m_nProxyPort;
    }

    @Override
    @Nullable
    public final String getProxyUserName() {
        return this.m_sProxyUserName;
    }

    @Override
    @Nullable
    public final String getProxyPassword() {
        return this.m_sProxyPassword;
    }

    @Override
    public boolean hasSocketAddress(@Nullable SocketAddress socketAddress) {
        switch (this.m_eProxyType) {
            case DIRECT: {
                return socketAddress == null;
            }
            case HTTP: 
            case SOCKS: {
                return socketAddress instanceof InetSocketAddress && this.hasInetSocketAddress((InetSocketAddress)socketAddress);
            }
        }
        throw new IllegalStateException("Unsupported proxy type: " + this.m_eProxyType);
    }

    @Override
    @Nonnull
    public Proxy getAsProxy(boolean bl) {
        switch (this.m_eProxyType) {
            case DIRECT: {
                return Proxy.NO_PROXY;
            }
            case HTTP: 
            case SOCKS: {
                return new Proxy(this.m_eProxyType, bl ? new InetSocketAddress(this.m_sProxyHost, this.m_nProxyPort) : InetSocketAddress.createUnresolved(this.m_sProxyHost, this.m_nProxyPort));
            }
        }
        throw new IllegalStateException("Unsupported proxy type: " + this.m_eProxyType);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ProxySettings proxySettings = (ProxySettings)object;
        return this.m_eProxyType.equals((Object)proxySettings.m_eProxyType) && EqualsHelper.equals((Object)this.m_sProxyHost, (Object)proxySettings.m_sProxyHost) && this.m_nProxyPort == proxySettings.m_nProxyPort && EqualsHelper.equals((Object)this.m_sProxyUserName, (Object)proxySettings.m_sProxyUserName) && EqualsHelper.equals((Object)this.m_sProxyPassword, (Object)proxySettings.m_sProxyPassword);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eProxyType).append((Object)this.m_sProxyHost).append(this.m_nProxyPort).append((Object)this.m_sProxyUserName).append((Object)this.m_sProxyPassword).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ProxyType", (Enum)this.m_eProxyType).appendIfNotNull("ProxyHost", (Object)this.m_sProxyHost).appendIf("ProxyPort", this.m_nProxyPort, Predicates.intIsGE0()).appendIfNotNull("ProxyUserName", (Object)this.m_sProxyUserName).appendPasswordIf("ProxyPassword", this::hasProxyPassword).getToString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ProxySettings createNoProxySettings() {
        return new ProxySettings(Proxy.Type.DIRECT, null, -1, null, null);
    }
}

