/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.ArrayHelper;
import com.helger.network.proxy.config.EHttpProxyType;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HttpProxyAuthenticator
extends Authenticator {
    private final EHttpProxyType m_eProxyType;

    public HttpProxyAuthenticator(@Nonnull EHttpProxyType eHttpProxyType) {
        this.m_eProxyType = (EHttpProxyType)ValueEnforcer.notNull((Object)eHttpProxyType, (String)"ProxyType");
    }

    @Nonnull
    public final EHttpProxyType getProxyType() {
        return this.m_eProxyType;
    }

    @Override
    @Nullable
    public PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
            int n;
            String string = this.m_eProxyType.getProxyHost();
            if (this.getRequestingHost().equalsIgnoreCase(string) && (n = this.m_eProxyType.getProxyPort()) == this.getRequestingPort()) {
                String string2 = this.m_eProxyType.getProxyUserName();
                String string3 = this.m_eProxyType.getProxyPassword();
                return new PasswordAuthentication(string2, string3 == null ? ArrayHelper.EMPTY_CHAR_ARRAY : string3.toCharArray());
            }
        }
        return null;
    }
}

