/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.config;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.network.port.NetworkPortHelper;
import com.helger.network.proxy.config.HttpProxyConfig;
import com.helger.network.proxy.config.IProxyConfig;
import com.helger.network.proxy.config.UseSystemProxyConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SocksProxyConfig
implements IProxyConfig {
    public static final String SYSPROP_SOCKS_PROXY_HOST = "socksProxyHost";
    public static final String SYSPROP_SOCKS_PROXY_PORT = "socksProxyPort";
    public static final int DEFAULT_SOCKS_PROXY_PORT = 1080;
    private final String m_sHost;
    private final int m_nPort;

    public SocksProxyConfig(@Nonnull String string) {
        this(string, 1080);
    }

    public SocksProxyConfig(@Nonnull String string, @Nonnegative int n) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Host");
        ValueEnforcer.isTrue((boolean)NetworkPortHelper.isValidPort(n), () -> "The passed port " + n + " is invalid");
        this.m_sHost = string;
        this.m_nPort = n;
    }

    @Nonnull
    public final String getHost() {
        return this.m_sHost;
    }

    @Nonnegative
    public final int getPort() {
        return this.m_nPort;
    }

    @Nullable
    public String getProxyHost() {
        return SystemProperties.getPropertyValueOrNull((String)SYSPROP_SOCKS_PROXY_HOST);
    }

    @Nullable
    public String getProxyPort() {
        return SystemProperties.getPropertyValueOrNull((String)SYSPROP_SOCKS_PROXY_PORT);
    }

    @Override
    public void activateGlobally() {
        HttpProxyConfig.deactivateGlobally();
        UseSystemProxyConfig.deactivateGlobally();
        SystemProperties.setPropertyValue((String)SYSPROP_SOCKS_PROXY_HOST, (String)this.m_sHost);
        SystemProperties.setPropertyValue((String)SYSPROP_SOCKS_PROXY_PORT, (String)Integer.toString(this.m_nPort));
    }

    public static void deactivateGlobally() {
        SystemProperties.removePropertyValue((String)SYSPROP_SOCKS_PROXY_HOST);
        SystemProperties.removePropertyValue((String)SYSPROP_SOCKS_PROXY_PORT);
    }

    @Override
    @Nonnull
    public Proxy getAsProxy() {
        return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.m_sHost, this.m_nPort));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SocksProxyConfig socksProxyConfig = (SocksProxyConfig)object;
        return this.m_sHost.equals(socksProxyConfig.m_sHost) && this.m_nPort == socksProxyConfig.m_nPort;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHost).append(this.m_nPort).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("host", (Object)this.m_sHost).append("port", this.m_nPort).getToString();
    }
}

