/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.port;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.network.port.ENetworkPortStatus;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class NetworkPortHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkPortHelper.class);
    private static final NetworkPortHelper INSTANCE = new NetworkPortHelper();

    private NetworkPortHelper() {
    }

    public static boolean isValidPort(int n) {
        return n >= 0 && n <= 65535;
    }

    @Nonnull
    public static ENetworkPortStatus checkPortOpen(@Nonnull @Nonempty String string, @Nonnegative int n, @Nonnegative int n2) {
        return NetworkPortHelper.checkPortOpen(string, n, n2, false);
    }

    @Nonnull
    public static ENetworkPortStatus checkPortOpen(@Nonnull @Nonempty String string, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ENetworkPortStatus eNetworkPortStatus;
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Hostname");
        ValueEnforcer.isGE0((int)n, (String)"Port");
        ValueEnforcer.isGE0((int)n2, (String)"TimeoutMillisecs");
        if (!bl) {
            LOGGER.info("Checking TCP port status for " + string + ":" + n + " with timeouf of " + n2 + " ms");
        }
        try (Socket socket = new Socket();){
            socket.setReuseAddress(true);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            socket.connect(inetSocketAddress, n2);
            eNetworkPortStatus = ENetworkPortStatus.PORT_IS_OPEN;
        }
        catch (UnknownHostException unknownHostException) {
            eNetworkPortStatus = ENetworkPortStatus.HOST_NOT_EXISTING;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            eNetworkPortStatus = ENetworkPortStatus.CONNECTION_TIMEOUT;
        }
        catch (ConnectException connectException) {
            eNetworkPortStatus = ENetworkPortStatus.GENERIC_IO_ERROR;
        }
        catch (IOException iOException) {
            if (iOException.getMessage().startsWith("Connection refused")) {
                eNetworkPortStatus = ENetworkPortStatus.PORT_IS_CLOSED;
            }
            if (!bl) {
                LOGGER.error("Other error checking TCP port status", (Throwable)iOException);
            }
            eNetworkPortStatus = ENetworkPortStatus.GENERIC_IO_ERROR;
        }
        if (!bl) {
            LOGGER.info("  Result of the port check is " + String.valueOf((Object)eNetworkPortStatus));
        }
        return eNetworkPortStatus;
    }
}

