/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.filter.AbstractHttpServletFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterEncodingFilter
extends AbstractHttpServletFilter {
    public static final String INITPARAM_ENCODING = "encoding";
    public static final String INITPARAM_FORCE_REQUEST_ENCODING = "forceRequestEncoding";
    public static final String INITPARAM_FORCE_RESPONSE_ENCODING = "forceResponseEncoding";
    public static final String INITPARAM_FORCE_ENCODING = "forceEncoding";
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    public static final boolean DEFAULT_FORCE_ENCODING = false;
    private static final String REQUEST_ATTR = "$ph-" + CharacterEncodingFilter.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(CharacterEncodingFilter.class);
    private String m_sEncoding = DEFAULT_ENCODING;
    private boolean m_bForceRequestEncoding = false;
    private boolean m_bForceResponseEncoding = false;

    @Nonnull
    @Nonempty
    public final String getEncoding() {
        return this.m_sEncoding;
    }

    public final void setEncoding(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Encoding");
        CharsetHelper.getCharsetFromName((String)string);
        this.m_sEncoding = string;
    }

    public final boolean isForceRequestEncoding() {
        return this.m_bForceRequestEncoding;
    }

    public final void setForceRequestEncoding(boolean bl) {
        this.m_bForceRequestEncoding = bl;
    }

    public final boolean isForceResponseEncoding() {
        return this.m_bForceResponseEncoding;
    }

    public final void setForceResponseEncoding(boolean bl) {
        this.m_bForceResponseEncoding = bl;
    }

    public final void setForceEncoding(boolean bl) {
        this.setForceRequestEncoding(bl);
        this.setForceResponseEncoding(bl);
    }

    @Override
    public void init() throws ServletException {
        String string;
        super.init();
        String string2 = this.getFilterConfig().getInitParameter(INITPARAM_ENCODING);
        if (StringHelper.hasText((String)string2)) {
            this.setEncoding(string2);
        }
        if ((string = this.getFilterConfig().getInitParameter(INITPARAM_FORCE_REQUEST_ENCODING)) != null) {
            this.setForceRequestEncoding(StringParser.parseBool((String)string));
        }
        if ((string = this.getFilterConfig().getInitParameter(INITPARAM_FORCE_RESPONSE_ENCODING)) != null) {
            this.setForceResponseEncoding(StringParser.parseBool((String)string));
        }
        if ((string = this.getFilterConfig().getInitParameter(INITPARAM_FORCE_ENCODING)) != null) {
            this.setForceEncoding(StringParser.parseBool((String)string));
        }
    }

    @Override
    public void doHttpFilter(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull FilterChain filterChain) throws IOException, ServletException {
        String string;
        boolean bl;
        if (httpServletRequest.getAttribute(REQUEST_ATTR) == null) {
            bl = true;
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, REQUEST_ATTR, Boolean.TRUE);
        } else {
            bl = false;
        }
        if (bl && ((string = httpServletRequest.getCharacterEncoding()) == null || this.m_bForceRequestEncoding)) {
            ServletHelper.setRequestCharacterEncoding(httpServletRequest, this.m_sEncoding);
            if (httpServletRequest.getCharacterEncoding() == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Failed to set the request character encoding to '" + this.m_sEncoding + "'");
                }
            } else if (string != null && !this.m_sEncoding.equalsIgnoreCase(string) && LOGGER.isInfoEnabled()) {
                LOGGER.info("Changed request encoding from '" + string + "' to '" + this.m_sEncoding + "'");
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        if (bl) {
            String string2;
            boolean bl2;
            string = httpServletResponse.getContentType();
            boolean bl3 = bl2 = string != null && EMimeContentType.TEXT.isTypeOf(string);
            if (bl2 && ((string2 = httpServletResponse.getCharacterEncoding()) == null || this.m_bForceResponseEncoding)) {
                httpServletResponse.setCharacterEncoding(this.m_sEncoding);
                if (httpServletResponse.getCharacterEncoding() == null) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("Failed to set the response character encoding to '" + this.m_sEncoding + "'");
                    }
                } else if (string2 != null && !this.m_sEncoding.equalsIgnoreCase(string2) && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Changed response encoding from '" + string2 + "' to '" + this.m_sEncoding + "' for MIME type '" + string + "'");
                }
            }
        }
    }
}

