/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response.gzip;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.response.ResponseHelper;
import com.helger.servlet.response.StatusAwareHttpResponseWrapper;
import com.helger.servlet.response.gzip.AbstractCompressedServletOutputStream;
import com.helger.servlet.response.gzip.CompressFilterSettings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractCompressedResponseWrapper
extends StatusAwareHttpResponseWrapper {
    public static final long DEFAULT_MIN_COMPRESSED_SIZE = 256L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompressedResponseWrapper.class);
    private final HttpServletRequest m_aHttpRequest;
    private final String m_sContentEncoding;
    private long m_nContentLength = -1L;
    private long m_nMinCompressSize = 256L;
    private AbstractCompressedServletOutputStream m_aCompressedOS;
    private PrintWriter m_aWriter;
    private boolean m_bNoCompression = false;

    public AbstractCompressedResponseWrapper(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull @Nonempty String string) {
        super(httpServletResponse);
        this.m_aHttpRequest = (HttpServletRequest)ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        this.m_sContentEncoding = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ContentEncoding");
    }

    @Nonnegative
    public final long getMinCompressSize() {
        return this.m_nMinCompressSize;
    }

    public final void setMinCompressSize(@Nonnegative long l) {
        ValueEnforcer.isGE0((long)l, (String)"MinCompressSize");
        this.m_nMinCompressSize = l;
    }

    public void setNoCompression() {
        this.m_bNoCompression = true;
        if (this.m_aCompressedOS != null) {
            try {
                this.m_aCompressedOS.doNotCompress("requested from response wrapper");
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    private void _setContentLength(long l) {
        if (CompressFilterSettings.isDebugModeEnabled() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Explicitly setting content length " + l + "; m_bNoCompression=" + this.m_bNoCompression);
        }
        this.m_nContentLength = l;
        if (this.m_aCompressedOS != null) {
            this.m_aCompressedOS.setContentLength(l);
        } else if (this.m_bNoCompression && this.m_nContentLength >= 0L) {
            ResponseHelper.setContentLength((HttpServletResponse)this.getResponse(), this.m_nContentLength);
        }
    }

    @Override
    public void setContentType(@Nonnull String string) {
        super.setContentType(string);
        if (this.m_aCompressedOS == null || this.m_aCompressedOS.getOutputStream() == null) {
            String string2 = StringHelper.getUntilFirstExcl((String)string, (char)';');
            if (string2 == null) {
                string2 = string;
            }
            if (string2 != null && (string2.contains("deflate") || string2.contains("gzip"))) {
                if (CompressFilterSettings.isDebugModeEnabled() && LOGGER.isInfoEnabled()) {
                    LOGGER.info("Explicitly disabling compression because of external content type " + string);
                }
                this.setNoCompression();
            }
        }
    }

    private void _updateStatus(int n) {
        if (n < 200 || n == 204 || n == 205 || n >= 300) {
            this.setNoCompression();
        }
    }

    @Override
    public void setStatus(int n) {
        super.setStatus(n);
        this._updateStatus(n);
    }

    @Override
    @Deprecated(forRemoval=false)
    public void setStatus(int n, String string) {
        super.setStatus(n, string);
        this._updateStatus(n);
    }

    @Override
    public void addHeader(String string, String string2) {
        if ("Content-Length".equalsIgnoreCase(string)) {
            this._setContentLength(Long.parseLong(string2));
        } else if ("Content-Type".equalsIgnoreCase(string)) {
            this.setContentType(string2);
        } else if ("Content-Encoding".equalsIgnoreCase(string)) {
            if (CompressFilterSettings.isDebugModeEnabled() && LOGGER.isInfoEnabled()) {
                LOGGER.info("Explicitly content encoding in addHeader: " + string2);
            }
            super.addHeader(string, string2);
            if (!this.isCommitted()) {
                this.setNoCompression();
            }
        } else {
            super.addHeader(string, string2);
        }
    }

    @Override
    public void setHeader(String string, String string2) {
        if ("Content-Length".equalsIgnoreCase(string)) {
            this._setContentLength(Long.parseLong(string2));
        } else if ("Content-Type".equalsIgnoreCase(string)) {
            this.setContentType(string2);
        } else if ("Content-Encoding".equalsIgnoreCase(string)) {
            if (CompressFilterSettings.isDebugModeEnabled() && LOGGER.isInfoEnabled()) {
                LOGGER.info("Explicitly content encoding in setHeader: " + string2);
            }
            super.setHeader(string, string2);
            if (!this.isCommitted()) {
                this.setNoCompression();
            }
        } else {
            super.setHeader(string, string2);
        }
    }

    @Override
    public void setIntHeader(String string, int n) {
        if ("Content-Length".equalsIgnoreCase(string)) {
            this.setContentLength(n);
        } else {
            super.setIntHeader(string, n);
        }
    }

    public final void flushBuffer() throws IOException {
        if (this.m_aWriter != null) {
            if (CompressFilterSettings.isDebugModeEnabled()) {
                LOGGER.info("flushBuffer on writer");
            }
            this.m_aWriter.flush();
        } else if (this.m_aCompressedOS != null) {
            if (CompressFilterSettings.isDebugModeEnabled()) {
                LOGGER.warn("flushBuffer on compressedOS - FINISH and CLOSE!");
            }
            this.m_aCompressedOS.finishAndClose();
        } else {
            this.getResponse().flushBuffer();
        }
    }

    @Override
    public void reset() {
        if (CompressFilterSettings.isDebugModeEnabled()) {
            LOGGER.info("reset (e.g. because of conditional requests)");
        }
        super.reset();
        if (this.m_aCompressedOS != null) {
            this.m_aCompressedOS.resetBuffer();
            this.m_aCompressedOS = null;
        }
        this.m_aWriter = null;
        this.m_bNoCompression = false;
        this.m_nContentLength = -1L;
    }

    public void resetBuffer() {
        if (CompressFilterSettings.isDebugModeEnabled()) {
            LOGGER.info("resetBuffer");
        }
        super.resetBuffer();
        if (this.m_aCompressedOS != null) {
            this.m_aCompressedOS.resetBuffer();
            this.m_aCompressedOS = null;
        }
        this.m_aWriter = null;
    }

    @Override
    public void sendError(int n, String string) throws IOException {
        this.resetBuffer();
        super.sendError(n, string);
    }

    @Override
    public void sendError(int n) throws IOException {
        this.resetBuffer();
        super.sendError(n);
    }

    @Override
    public void sendRedirect(String string) throws IOException {
        this.resetBuffer();
        super.sendRedirect(string);
    }

    public final void finish() throws IOException {
        if (this.m_aWriter != null && !this.m_aCompressedOS.isClosed()) {
            this.m_aWriter.flush();
        }
        if (this.m_aCompressedOS != null) {
            this.m_aCompressedOS.finishAndClose();
        }
    }

    @Nonnull
    protected abstract AbstractCompressedServletOutputStream createCompressedOutputStream(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nonnull @Nonempty String var3, long var4, @Nonnegative long var6) throws IOException;

    @Nonnull
    private AbstractCompressedServletOutputStream _createCompressedOutputStream() throws IOException {
        if (CompressFilterSettings.isDebugModeEnabled() && LOGGER.isInfoEnabled()) {
            LOGGER.info("createCompressedOutputStream(" + this.m_sContentEncoding + ", " + this.m_nContentLength + ", " + this.m_nMinCompressSize + ") on " + ServletHelper.getRequestRequestURI(this.m_aHttpRequest));
        }
        return this.createCompressedOutputStream(this.m_aHttpRequest, (HttpServletResponse)this.getResponse(), this.m_sContentEncoding, this.m_nContentLength, this.m_nMinCompressSize);
    }

    @Nonnull
    public final ServletOutputStream getOutputStream() throws IOException {
        if (this.m_aCompressedOS == null) {
            if (this.getResponse().isCommitted() || this.m_bNoCompression) {
                return this.getResponse().getOutputStream();
            }
            this.m_aCompressedOS = this._createCompressedOutputStream();
        } else if (this.m_aWriter != null) {
            throw new IllegalStateException("getWriter() has already been called!");
        }
        return this.m_aCompressedOS;
    }

    @Nonnull
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public final PrintWriter getWriter() throws IOException {
        if (this.m_aWriter == null) {
            if (this.m_aCompressedOS != null) {
                throw new IllegalStateException("getOutputStream() has already been called!");
            }
            if (this.getResponse().isCommitted() || this.m_bNoCompression) {
                return this.getResponse().getWriter();
            }
            this.m_aCompressedOS = this._createCompressedOutputStream();
            String string = this.getCharacterEncoding();
            if (string == null) {
                string = Charset.defaultCharset().name();
            }
            this.m_aWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.m_aCompressedOS), string));
        }
        return this.m_aWriter;
    }
}

