/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.request;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.commons.url.URLData;
import com.helger.http.AcceptCharsetHandler;
import com.helger.http.AcceptCharsetList;
import com.helger.http.AcceptEncodingHandler;
import com.helger.http.AcceptEncodingList;
import com.helger.http.AcceptLanguageHandler;
import com.helger.http.AcceptLanguageList;
import com.helger.http.AcceptMimeTypeHandler;
import com.helger.http.AcceptMimeTypeList;
import com.helger.http.EHttpVersion;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.http.basicauth.HttpBasicAuth;
import com.helger.http.digestauth.DigestAuthClientCredentials;
import com.helger.http.digestauth.HttpDigestAuth;
import com.helger.network.port.NetworkPortHelper;
import com.helger.network.port.SchemeDefaultPortMapper;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.request.IRequestParamMap;
import com.helger.servlet.request.RequestParamMap;
import com.helger.useragent.IUserAgent;
import com.helger.useragent.UserAgent;
import com.helger.useragent.UserAgentDatabase;
import com.helger.useragent.UserAgentElementList;
import com.helger.useragent.uaprofile.IUAProfileHeaderProvider;
import com.helger.useragent.uaprofile.UAProfile;
import com.helger.useragent.uaprofile.UAProfileDatabase;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Locale;
import java.util.function.BiConsumer;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class RequestHelper {
    public static final String SERVLET_ATTR_SSL_CIPHER_SUITE = "jakarta.servlet.request.cipher_suite";
    public static final String SERVLET_ATTR_SSL_KEY_SIZE = "jakarta.servlet.request.key_size";
    public static final String SERVLET_ATTR_CLIENT_CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String DEFAULT_CHECKBOX_HIDDEN_FIELD_PREFIX = "__";
    private static final String SCOPE_ATTR_REQUESTHELP_REQUESTPARAMMAP = "$requesthelp.requestparammap";
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHelper.class);
    private static final RequestHelper INSTANCE = new RequestHelper();

    private RequestHelper() {
    }

    @Nonnull
    public static String getWithoutSessionID(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        int n = string.indexOf(59);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nonnull
    public static SimpleURL getWithoutSessionID(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        return new SimpleURL((ISimpleURL)new URLData(RequestHelper.getWithoutSessionID(iSimpleURL.getPath()), iSimpleURL.params(), iSimpleURL.getAnchor()));
    }

    @Nullable
    public static String getSessionID(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        int n = string.indexOf(59);
        return n == -1 ? null : string.substring(n + 1);
    }

    @Nullable
    public static String getSessionID(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"URL");
        return RequestHelper.getSessionID(iSimpleURL.getPath());
    }

    @Nonnull
    public static String getRequestURIDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = StringHelper.getNotNull((String)ServletContextPathHolder.getContextPath(), (String)"");
        String string2 = ServletHelper.getRequestServletPath(httpServletRequest);
        String string3 = ServletHelper.getRequestPathInfo(httpServletRequest);
        String string4 = string + string2 + string3;
        if (string4.length() == 0) {
            return string4;
        }
        return RequestHelper.getWithoutSessionID(string4);
    }

    @Nonnull
    public static String getRequestURIEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        String string;
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string2 = StringHelper.getNotNull((String)ServletContextPathHolder.getContextPathOrNull(), (String)"");
        String string3 = ServletHelper.getRequestContextPath(httpServletRequest, "");
        String string4 = ServletHelper.getRequestRequestURI(httpServletRequest);
        if (string3.length() > 0 && string4.startsWith(string3)) {
            string4 = string4.substring(string3.length());
        }
        if ((string = string2 + string4).length() == 0) {
            return string;
        }
        return RequestHelper.getWithoutSessionID(string);
    }

    @Nullable
    public static String getPathInfo(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = ServletHelper.getRequestPathInfo(httpServletRequest);
        if (StringHelper.hasNoText((String)string)) {
            return string;
        }
        return RequestHelper.getWithoutSessionID(string);
    }

    @Nonnull
    public static String getPathWithinServletContext(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper.getPathWithinServletContext(httpServletRequest, false);
    }

    @Nonnull
    public static String getPathWithinServletContext(@Nonnull HttpServletRequest httpServletRequest, boolean bl) {
        String string;
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string2 = string = bl ? RequestHelper.getRequestURIEncoded(httpServletRequest) : RequestHelper.getRequestURIDecoded(httpServletRequest);
        if (StringHelper.hasNoText((String)string)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Having empty request URI '" + string + "' from request " + httpServletRequest);
            }
            return "/";
        }
        String string3 = ServletContextPathHolder.getContextPath();
        if (StringHelper.hasNoText((String)string3) || !string.startsWith(string3)) {
            return string;
        }
        String string4 = string.substring(string3.length());
        return string4.length() > 0 ? string4 : "/";
    }

    @Nonnull
    public static String getPathWithinServlet(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper.getPathWithinServlet(httpServletRequest, false);
    }

    @Nonnull
    public static String getPathWithinServlet(@Nonnull HttpServletRequest httpServletRequest, boolean bl) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = RequestHelper.getPathWithinServletContext(httpServletRequest, bl);
        String string2 = ServletHelper.getRequestServletPath(httpServletRequest);
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string2;
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getRequestURLDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return RequestHelper.getFullServerName(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort()).append(RequestHelper.getRequestURIDecoded(httpServletRequest));
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getRequestURLEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return RequestHelper.getFullServerName(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort()).append(RequestHelper.getRequestURIEncoded(httpServletRequest));
    }

    @Nonnull
    @Nonempty
    public static String getURLDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        StringBuilder stringBuilder = RequestHelper.getRequestURLDecoded(httpServletRequest);
        String string = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.hasText((String)string)) {
            stringBuilder.append('?').append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getURLEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        StringBuilder stringBuilder = RequestHelper.getRequestURLEncoded(httpServletRequest);
        String string = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.hasText((String)string)) {
            stringBuilder.append('?').append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @Nonempty
    public static String getURIDecoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = RequestHelper.getRequestURIDecoded(httpServletRequest);
        String string2 = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.hasText((String)string2)) {
            return string + "?" + string2;
        }
        return string;
    }

    @Nonnull
    @Nonempty
    public static String getURIEncoded(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = RequestHelper.getRequestURIEncoded(httpServletRequest);
        String string2 = ServletHelper.getRequestQueryString(httpServletRequest);
        if (StringHelper.hasText((String)string2)) {
            return string + "?" + string2;
        }
        return string;
    }

    @CheckForSigned
    public static int getDefaultServerPort(@Nullable String string) {
        return SchemeDefaultPortMapper.getDefaultPort((String)string, (int)-1);
    }

    @CheckForSigned
    public static int getServerPortToUse(@Nonnull String string, @CheckForSigned int n) {
        if (!NetworkPortHelper.isValidPort((int)n)) {
            return RequestHelper.getDefaultServerPort(string);
        }
        return n;
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getFullServerName(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return RequestHelper.getFullServerName(httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort());
    }

    @Nonnull
    @Nonempty
    public static StringBuilder getFullServerName(@Nullable String string, @Nullable String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText((String)string)) {
            stringBuilder.append(string).append("://");
        }
        if (StringHelper.hasText((String)string2)) {
            stringBuilder.append(string2);
        }
        if (NetworkPortHelper.isValidPort((int)n) && n != RequestHelper.getDefaultServerPort(string)) {
            stringBuilder.append(':').append(n);
        }
        return stringBuilder;
    }

    @Nonnull
    @Nonempty
    public static String getFullServerNameAndPath(@Nullable String string, @Nullable String string2, int n, @Nullable String string3, @Nullable String string4) {
        StringBuilder stringBuilder = RequestHelper.getFullServerName(string, string2, n);
        if (StringHelper.hasText((String)string3)) {
            if (!StringHelper.startsWith((CharSequence)string3, (char)'/')) {
                stringBuilder.append('/');
            }
            stringBuilder.append(string3);
        }
        if (StringHelper.hasText((String)string4)) {
            stringBuilder.append('?').append(string4);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getHttpReferer(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        return httpServletRequest.getHeader("Referer");
    }

    @Nullable
    public static EHttpVersion getHttpVersion(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = httpServletRequest.getProtocol();
        return EHttpVersion.getFromNameOrNull((String)string);
    }

    @Nullable
    public static EHttpMethod getHttpMethod(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper.getHttpMethodOrDefault(httpServletRequest, null);
    }

    @Nullable
    public static EHttpMethod getHttpMethodOrDefault(@Nonnull HttpServletRequest httpServletRequest, @Nullable EHttpMethod eHttpMethod) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = httpServletRequest.getMethod();
        EHttpMethod eHttpMethod2 = EHttpMethod.getFromNameOrNull((String)string);
        if (eHttpMethod2 != null) {
            return eHttpMethod2;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unknown HTTP request method '" + string + "' used in request " + httpServletRequest);
        }
        return eHttpMethod;
    }

    public static void forEachRequestHeader(@Nonnull HttpServletRequest httpServletRequest, @Nonnull BiConsumer<String, String> biConsumer) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        ValueEnforcer.notNull(biConsumer, (String)"Consumer");
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = httpServletRequest.getHeaders(string);
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                biConsumer.accept(string, string2);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HttpHeaderMap getRequestHeaderMap(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        RequestHelper.forEachRequestHeader(httpServletRequest, (arg_0, arg_1) -> ((HttpHeaderMap)httpHeaderMap).addHeader(arg_0, arg_1));
        return httpHeaderMap;
    }

    @Nonnull
    public static IRequestParamMap getRequestParamMap(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        IRequestParamMap iRequestParamMap = (IRequestParamMap)httpServletRequest.getAttribute(SCOPE_ATTR_REQUESTHELP_REQUESTPARAMMAP);
        if (iRequestParamMap == null) {
            iRequestParamMap = RequestParamMap.createFromRequest(httpServletRequest);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, SCOPE_ATTR_REQUESTHELP_REQUESTPARAMMAP, iRequestParamMap);
        }
        return iRequestParamMap;
    }

    @CheckForSigned
    public static long getContentLength(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = httpServletRequest.getHeader("Content-Length");
        return StringParser.parseLong((String)string, (long)-1L);
    }

    @Nullable
    private static <T> T _getRequestAttr(@Nonnull HttpServletRequest httpServletRequest, @Nonnull @Nonempty String string, @Nonnull Class<T> clazz) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        Object object = httpServletRequest.getAttribute(string);
        if (object == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            LOGGER.error("Request attribute " + string + " is not of type " + clazz.getName() + " but of type " + object.getClass().getName());
            return null;
        }
        return clazz.cast(object);
    }

    @Nullable
    public static String getRequestSSLCipherSuite(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper._getRequestAttr(httpServletRequest, SERVLET_ATTR_SSL_CIPHER_SUITE, String.class);
    }

    @Nullable
    public static Integer getRequestSSLKeySize(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper._getRequestAttr(httpServletRequest, SERVLET_ATTR_SSL_KEY_SIZE, Integer.class);
    }

    @Nullable
    public static X509Certificate[] getRequestClientCertificates(@Nonnull HttpServletRequest httpServletRequest) {
        return RequestHelper._getRequestAttr(httpServletRequest, SERVLET_ATTR_CLIENT_CERTIFICATE, X509Certificate[].class);
    }

    public static boolean isMultipartContent(@Nullable String string) {
        return string != null && string.toLowerCase(Locale.US).startsWith(MULTIPART);
    }

    public static boolean isMultipartContent(@Nonnull HttpServletRequest httpServletRequest) {
        if (RequestHelper.getHttpMethod(httpServletRequest) != EHttpMethod.POST) {
            return false;
        }
        return RequestHelper.isMultipartContent(httpServletRequest.getContentType());
    }

    public static boolean isMultipartFormDataContent(@Nullable String string) {
        return string != null && string.toLowerCase(Locale.US).startsWith(MULTIPART_FORM_DATA);
    }

    public static boolean isMultipartFormDataContent(@Nonnull HttpServletRequest httpServletRequest) {
        if (RequestHelper.getHttpMethod(httpServletRequest) != EHttpMethod.POST) {
            return false;
        }
        return RequestHelper.isMultipartFormDataContent(httpServletRequest.getContentType());
    }

    @Nonnull
    public static AcceptCharsetList getAcceptCharsets(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptCharsetList acceptCharsetList = (AcceptCharsetList)httpServletRequest.getAttribute(AcceptCharsetList.class.getName());
        if (acceptCharsetList == null) {
            String string = httpServletRequest.getHeader("Accept-Charset");
            acceptCharsetList = AcceptCharsetHandler.getAcceptCharsets((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptCharsetList.class.getName(), acceptCharsetList);
        }
        return acceptCharsetList;
    }

    @Nonnull
    public static AcceptEncodingList getAcceptEncodings(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptEncodingList acceptEncodingList = (AcceptEncodingList)httpServletRequest.getAttribute(AcceptEncodingList.class.getName());
        if (acceptEncodingList == null) {
            String string = httpServletRequest.getHeader("Accept-Encoding");
            acceptEncodingList = AcceptEncodingHandler.getAcceptEncodings((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptEncodingList.class.getName(), acceptEncodingList);
        }
        return acceptEncodingList;
    }

    @Nonnull
    public static AcceptLanguageList getAcceptLanguages(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptLanguageList acceptLanguageList = (AcceptLanguageList)httpServletRequest.getAttribute(AcceptLanguageList.class.getName());
        if (acceptLanguageList == null) {
            String string = httpServletRequest.getHeader("Accept-Language");
            acceptLanguageList = AcceptLanguageHandler.getAcceptLanguages((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptLanguageList.class.getName(), acceptLanguageList);
        }
        return acceptLanguageList;
    }

    @Nonnull
    public static AcceptMimeTypeList getAcceptMimeTypes(@Nonnull HttpServletRequest httpServletRequest) {
        AcceptMimeTypeList acceptMimeTypeList = (AcceptMimeTypeList)httpServletRequest.getAttribute(AcceptMimeTypeList.class.getName());
        if (acceptMimeTypeList == null) {
            String string = httpServletRequest.getHeader("Accept");
            acceptMimeTypeList = AcceptMimeTypeHandler.getAcceptMimeTypes((String)string);
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, AcceptMimeTypeList.class.getName(), acceptMimeTypeList);
        }
        return acceptMimeTypeList;
    }

    @Nullable
    public static BasicAuthClientCredentials getBasicAuthClientCredentials(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = httpServletRequest.getHeader("Authorization");
        return HttpBasicAuth.getBasicAuthClientCredentials((String)string);
    }

    @Nullable
    public static DigestAuthClientCredentials getDigestAuthClientCredentials(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        String string = httpServletRequest.getHeader("Authorization");
        return HttpDigestAuth.getDigestAuthClientCredentials((String)string);
    }

    @Nullable
    public static String getHttpUserAgentStringFromRequest(@Nonnull HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("UA");
        if (string == null && (string = httpServletRequest.getHeader("x-device-user-agent")) == null) {
            string = httpServletRequest.getHeader("User-Agent");
        }
        return string;
    }

    @Nullable
    public static IUserAgent getUserAgent(@Nonnull HttpServletRequest httpServletRequest) {
        Object object = httpServletRequest.getAttribute(IUserAgent.class.getName());
        try {
            IUserAgent iUserAgent = (IUserAgent)object;
            if (iUserAgent == null) {
                String string = RequestHelper.getHttpUserAgentStringFromRequest(httpServletRequest);
                iUserAgent = UserAgentDatabase.getParsedUserAgent((String)string);
                if (iUserAgent == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("No user agent was passed in the request!");
                    }
                    iUserAgent = new UserAgent("", new UserAgentElementList());
                }
                ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, IUserAgent.class.getName(), iUserAgent);
            }
            return iUserAgent;
        }
        catch (ClassCastException classCastException) {
            LOGGER.error("ClassCastException whysoever.");
            if (object != null) {
                LOGGER.error("  IUserAgent classloader=" + object.getClass().getClassLoader().toString());
            }
            if (object != null) {
                LOGGER.error("  UserAgent classloader=" + UserAgent.class.getClassLoader().toString());
            }
            return null;
        }
    }

    @Nonnull
    public static UAProfile getUAProfile(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        UAProfile uAProfile = (UAProfile)httpServletRequest.getAttribute(UAProfile.class.getName());
        if (uAProfile == null) {
            uAProfile = UAProfileDatabase.getParsedUAProfile((IUAProfileHeaderProvider)new UAProfileHeaderProviderHttpServletRequest(httpServletRequest));
            ServletHelper.setRequestAttribute((ServletRequest)httpServletRequest, UAProfile.class.getName(), uAProfile);
        }
        return uAProfile;
    }

    @Nonnull
    @Nonempty
    public static String getCheckBoxHiddenFieldName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FieldName");
        return DEFAULT_CHECKBOX_HIDDEN_FIELD_PREFIX + string;
    }

    private static final class UAProfileHeaderProviderHttpServletRequest
    implements IUAProfileHeaderProvider {
        private final HttpServletRequest m_aHttpRequest;

        public UAProfileHeaderProviderHttpServletRequest(@Nonnull HttpServletRequest httpServletRequest) {
            this.m_aHttpRequest = httpServletRequest;
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsList<String> getAllHeaderNames() {
            return new CommonsArrayList(this.m_aHttpRequest.getHeaderNames());
        }

        @Nonnull
        @ReturnsMutableCopy
        public ICommonsList<String> getHeaders(@Nullable String string) {
            return new CommonsArrayList(this.m_aHttpRequest.getHeaders(string));
        }

        @Nullable
        public String getHeaderValue(@Nullable String string) {
            return this.m_aHttpRequest.getHeader(string);
        }
    }
}

