/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response.gzip;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.servlet.io.AbstractServletOutputStream;
import com.helger.servlet.response.ResponseHelper;
import com.helger.servlet.response.gzip.CompressFilterSettings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompressedServletOutputStream
extends AbstractServletOutputStream {
    private static final int DEFAULT_BUFSIZE = 8192;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompressedServletOutputStream.class);
    private final HttpServletRequest m_aHttpRequest;
    private final HttpServletResponse m_aHttpResponse;
    private final String m_sContentEncoding;
    private OutputStream m_aOS;
    private NonBlockingByteArrayOutputStream m_aBAOS;
    private DeflaterOutputStream m_aCompressedOS;
    private boolean m_bClosed = false;
    private boolean m_bDoNotCompress = false;
    private long m_nContentLength;
    private final long m_nMinCompressSize;

    public AbstractCompressedServletOutputStream(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull String string, long l, @Nonnegative long l2) throws IOException {
        this.m_aHttpRequest = (HttpServletRequest)ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        this.m_aHttpResponse = (HttpServletResponse)ValueEnforcer.notNull((Object)httpServletResponse, (String)"HttpResponse");
        this.m_sContentEncoding = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ContentEncoding");
        this.m_nContentLength = l;
        this.m_nMinCompressSize = l2;
        if (l2 == 0L) {
            this.doCompress("ctor: no min compress size");
        }
    }

    private static void _debugLog(boolean bl, String string) {
        if (CompressFilterSettings.isDebugModeEnabled()) {
            LOGGER.info((bl ? "Compressing: " : "Not compressing: ") + string);
        }
    }

    public final void resetBuffer() {
        if (this.m_aHttpResponse.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this.m_aOS = null;
        this.m_aBAOS = null;
        if (this.m_aCompressedOS != null) {
            this.m_aHttpResponse.setHeader("Content-Encoding", null);
            this.m_aCompressedOS = null;
        }
        this.m_bClosed = false;
        this.m_bDoNotCompress = false;
    }

    public final void setContentLength(long l) {
        if (CompressFilterSettings.isDebugModeEnabled()) {
            LOGGER.info("Setting content length to " + l + "; doNotCompress=" + this.m_bDoNotCompress);
        }
        this.m_nContentLength = l;
        if (this.m_bDoNotCompress && l >= 0L) {
            ResponseHelper.setContentLength(this.m_aHttpResponse, this.m_nContentLength);
        }
    }

    @Nonnull
    protected abstract DeflaterOutputStream createDeflaterOutputStream(@Nonnull OutputStream var1) throws IOException;

    public final void doCompress(@Nullable String string) throws IOException {
        if (this.m_aCompressedOS == null) {
            if (this.m_aHttpResponse.isCommitted()) {
                throw new IllegalStateException("Response already committed");
            }
            this.m_aHttpResponse.setHeader("Content-Encoding", this.m_sContentEncoding);
            if (this.m_aHttpResponse.containsHeader("Content-Encoding")) {
                AbstractCompressedServletOutputStream._debugLog(true, string);
                this.m_aCompressedOS = this.createDeflaterOutputStream((OutputStream)this.m_aHttpResponse.getOutputStream());
                this.m_aOS = this.m_aCompressedOS;
                if (this.m_aBAOS != null) {
                    this.m_aBAOS.writeTo(this.m_aOS);
                    this.m_aBAOS = null;
                }
            } else {
                this.doNotCompress("from compress: included request");
            }
        } else if (CompressFilterSettings.isDebugModeEnabled()) {
            LOGGER.info("doCompress on already compressed stream");
        }
    }

    public final void doNotCompress(String string) throws IOException {
        if (this.m_aCompressedOS != null) {
            throw new IllegalStateException("Compressed output stream is already assigned.");
        }
        if (this.m_aOS == null || this.m_aBAOS != null) {
            this.m_bDoNotCompress = true;
            AbstractCompressedServletOutputStream._debugLog(false, string);
            this.m_aOS = this.m_aHttpResponse.getOutputStream();
            this.setContentLength(this.m_nContentLength);
            if (this.m_aBAOS != null) {
                this.m_aBAOS.writeTo(this.m_aOS);
                this.m_aBAOS = null;
            }
        }
    }

    public final void flush() throws IOException {
        if (this.m_aOS == null || this.m_aBAOS != null) {
            if (this.m_nContentLength > 0L && this.m_nContentLength < this.m_nMinCompressSize) {
                this.doNotCompress("flush");
            } else {
                this.doCompress("flush");
            }
        }
        this.m_aOS.flush();
    }

    public final void close() throws IOException {
        if (!this.m_bClosed) {
            Object object = this.m_aHttpRequest.getAttribute("jakarta.servlet.include.request_uri");
            if (object != null) {
                if (CompressFilterSettings.isDebugModeEnabled()) {
                    LOGGER.info("No close because we're including " + object);
                }
                this.flush();
            } else {
                if (this.m_aBAOS != null) {
                    if (this.m_nContentLength < 0L) {
                        this.m_nContentLength = this.m_aBAOS.size();
                    }
                    if (this.m_nContentLength < this.m_nMinCompressSize) {
                        this.doNotCompress("close with buffer");
                    } else {
                        this.doCompress("close with buffer");
                    }
                } else if (this.m_aOS == null) {
                    this.doNotCompress("close without buffer");
                }
                if (CompressFilterSettings.isDebugModeEnabled()) {
                    LOGGER.info("Closing stream. compressed=" + (this.m_aCompressedOS != null));
                }
                if (this.m_aCompressedOS != null) {
                    this.m_aCompressedOS.close();
                } else {
                    this.m_aOS.close();
                }
                this.m_bClosed = true;
            }
        }
    }

    public final boolean isClosed() {
        return this.m_bClosed;
    }

    public final void finishAndClose() throws IOException {
        if (!this.m_bClosed) {
            if (this.m_aOS == null || this.m_aBAOS != null) {
                if (this.m_nContentLength > 0L && this.m_nContentLength < this.m_nMinCompressSize) {
                    this.doNotCompress("finish");
                } else {
                    this.doCompress("finish");
                }
            }
            if (this.m_aCompressedOS != null && !this.m_bClosed) {
                if (CompressFilterSettings.isDebugModeEnabled()) {
                    LOGGER.info("Closing compressed stream in finish!");
                }
                this.m_bClosed = true;
                this.m_aCompressedOS.close();
            } else if (CompressFilterSettings.isDebugModeEnabled()) {
                LOGGER.info("Not closing anything in finish!");
            }
        }
    }

    private void _prepareToWrite(@Nonnegative int n) throws IOException {
        if (this.m_bClosed) {
            throw new IOException("Already closed");
        }
        if (this.m_aOS == null) {
            if (this.m_aHttpResponse.isCommitted()) {
                this.doNotCompress("_prepareToWrite new - response already committed");
            } else if (this.m_nContentLength >= 0L && this.m_nContentLength < this.m_nMinCompressSize) {
                this.doNotCompress("_prepareToWrite new " + this.m_nContentLength);
            } else if ((long)n > this.m_nMinCompressSize) {
                this.doCompress("_prepareToWrite new " + n);
            } else {
                if (CompressFilterSettings.isDebugModeEnabled()) {
                    LOGGER.info("Starting new output buffering!");
                }
                this.m_aBAOS = new NonBlockingByteArrayOutputStream(8192);
                this.m_aOS = this.m_aBAOS;
            }
        } else if (this.m_aBAOS != null) {
            if (this.m_aHttpResponse.isCommitted()) {
                this.doNotCompress("_prepareToWrite buffered - response already committed");
            } else if (this.m_nContentLength >= 0L && this.m_nContentLength < this.m_nMinCompressSize) {
                this.doNotCompress("_prepareToWrite buffered " + this.m_nContentLength);
            } else if (n >= this.m_aBAOS.getBufferSize() - this.m_aBAOS.size()) {
                this.doCompress("_prepareToWrite buffered " + n);
            } else if (CompressFilterSettings.isDebugModeEnabled()) {
                LOGGER.info("Continue buffering!");
            }
        }
    }

    public final void write(int n) throws IOException {
        this._prepareToWrite(1);
        this.m_aOS.write((byte)n);
    }

    public final void write(@Nonnull byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public final void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        this._prepareToWrite(n2);
        this.m_aOS.write(byArray, n, n2);
    }

    @Nullable
    public final OutputStream getOutputStream() {
        return this.m_aOS;
    }
}

