/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.ServletContextPathHolder;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ServletHelper {
    public static final boolean DEFAULT_LOG_EXCEPTIONS = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletHelper.class);
    private static final AtomicBoolean LOG_EXCEPTIONS = new AtomicBoolean(false);
    private static final ServletHelper INSTANCE = new ServletHelper();

    private ServletHelper() {
    }

    public static void setLogExceptions(boolean bl) {
        LOG_EXCEPTIONS.set(bl);
    }

    public static boolean isLogExceptions() {
        return LOG_EXCEPTIONS.get();
    }

    public static void setRequestAttribute(@Nonnull ServletRequest servletRequest, @Nonnull String string, @Nullable Object object) {
        block2: {
            try {
                servletRequest.setAttribute(string, object);
            }
            catch (Exception exception) {
                if (!ServletHelper.isLogExceptions()) break block2;
                LOGGER.warn("[ServletHelper] Failed to set attribute '" + string + "' in HTTP request", (Throwable)exception);
            }
        }
    }

    @Nullable
    public static Object getRequestAttribute(@Nonnull ServletRequest servletRequest, @Nonnull String string) {
        try {
            return servletRequest.getAttribute(string);
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to get attribute '" + string + "' from HTTP request", (Throwable)exception);
            }
            return null;
        }
    }

    @Nullable
    public static <T> T getRequestAttributeAs(@Nonnull ServletRequest servletRequest, @Nonnull String string) {
        return (T)GenericReflection.uncheckedCast((Object)ServletHelper.getRequestAttribute(servletRequest, string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getRequestHeaderNames(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return new CommonsArrayList(httpServletRequest.getHeaderNames());
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to get header names from HTTP request", (Throwable)exception);
            }
            return new CommonsArrayList();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getRequestHeaders(@Nonnull HttpServletRequest httpServletRequest, @Nonnull String string) {
        try {
            return new CommonsArrayList(httpServletRequest.getHeaders(string));
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to get headers for '" + string + "' from HTTP request", (Throwable)exception);
            }
            return new CommonsArrayList();
        }
    }

    @Nullable
    public static String getRequestHeader(@Nonnull HttpServletRequest httpServletRequest, @Nonnull String string) {
        try {
            return httpServletRequest.getHeader(string);
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to get header '" + string + "' from HTTP request", (Throwable)exception);
            }
            return null;
        }
    }

    @CheckForSigned
    public static long getRequestDateHeader(@Nonnull HttpServletRequest httpServletRequest, @Nonnull String string) {
        try {
            return httpServletRequest.getDateHeader(string);
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to get Date header '" + string + "' from HTTP request", (Throwable)exception);
            }
            return -1L;
        }
    }

    @Nonnull
    public static String getRequestContextPath(@Nullable HttpServletRequest httpServletRequest) {
        return ServletHelper.getRequestContextPath(httpServletRequest, ServletContextPathHolder.getContextPath());
    }

    @Nonnull
    public static String getRequestContextPath(@Nullable HttpServletRequest httpServletRequest, @Nullable String string) {
        String string2;
        block4: {
            string2 = null;
            if (httpServletRequest != null) {
                try {
                    string2 = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, "jakarta.servlet.async.context_path") : httpServletRequest.getContextPath();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions()) break block4;
                    LOGGER.warn("[ServletHelper] Failed to determine context path of HTTP request", (Throwable)exception);
                }
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return StringHelper.getNotNull((String)string2, (String)"");
    }

    @Nonnull
    public static String getRequestPathInfo(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block4: {
            string = null;
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, "jakarta.servlet.async.path_info") : httpServletRequest.getPathInfo();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions()) break block4;
                    LOGGER.warn("[ServletHelper] Failed to determine path info of HTTP request", (Throwable)exception);
                }
            }
        }
        return string == null ? "" : string;
    }

    @Nullable
    public static String getRequestQueryString(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block3: {
            string = null;
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, "jakarta.servlet.async.query_string") : httpServletRequest.getQueryString();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine query string of HTTP request", (Throwable)exception);
                }
            }
        }
        return string;
    }

    @Nonnull
    public static String getRequestRequestURI(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block3: {
            string = "";
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, "jakarta.servlet.async.request_uri") : httpServletRequest.getRequestURI();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine request URI of HTTP request", (Throwable)exception);
                }
            }
        }
        return string;
    }

    @Nonnull
    public static StringBuffer getRequestRequestURL(@Nullable HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer;
        block3: {
            stringBuffer = null;
            if (httpServletRequest != null) {
                try {
                    stringBuffer = httpServletRequest.getRequestURL();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine request URL of HTTP request", (Throwable)exception);
                }
            }
        }
        return stringBuffer != null ? stringBuffer : new StringBuffer();
    }

    @Nonnull
    public static String getRequestServletPath(@Nullable HttpServletRequest httpServletRequest) {
        String string;
        block4: {
            string = "";
            if (httpServletRequest != null) {
                try {
                    string = httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted() ? (String)ServletHelper.getRequestAttributeAs((ServletRequest)httpServletRequest, "jakarta.servlet.async.servlet_path") : httpServletRequest.getServletPath();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions()) break block4;
                    LOGGER.warn("[ServletHelper] Failed to determine servlet path of HTTP request", (Throwable)exception);
                }
            }
        }
        return string;
    }

    @Nullable
    public static Cookie[] getRequestCookies(@Nullable HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray;
        block3: {
            cookieArray = null;
            if (httpServletRequest != null) {
                try {
                    cookieArray = httpServletRequest.getCookies();
                }
                catch (Exception exception) {
                    if (!ServletHelper.isLogExceptions()) break block3;
                    LOGGER.warn("[ServletHelper] Failed to determine cookies of HTTP request", (Throwable)exception);
                }
            }
        }
        return cookieArray;
    }

    public static void setRequestCharacterEncoding(@Nonnull HttpServletRequest httpServletRequest, @Nullable Charset charset) {
        ServletHelper.setRequestCharacterEncoding(httpServletRequest, charset != null ? charset.name() : null);
    }

    public static void setRequestCharacterEncoding(@Nonnull HttpServletRequest httpServletRequest, @Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            try {
                httpServletRequest.setCharacterEncoding(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error("Failed to set request character encoding to '" + string + "'", (Throwable)unsupportedEncodingException);
            }
        }
    }

    @Nonnull
    public static String getServletContextBasePath(@Nonnull ServletContext servletContext) {
        String string = servletContext.getRealPath(".");
        if (string == null) {
            string = servletContext.getRealPath("");
        }
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalStateException("Failed to determine real path of ServletContext " + String.valueOf(servletContext));
        }
        return string;
    }

    @CheckForSigned
    public static long getRequestContentLength(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getContentLengthLong();
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to determine Content-Length of HTTP request", (Throwable)exception);
            }
            return -1L;
        }
    }

    @Nullable
    public static String getRequestContentType(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getContentType();
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to determine Content-Type of HTTP request", (Throwable)exception);
            }
            return null;
        }
    }

    @Nullable
    public static String getRequestMethod(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getMethod();
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to determine Method of HTTP request", (Throwable)exception);
            }
            return null;
        }
    }

    @Nullable
    public static String getRequestProtocol(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getProtocol();
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to determine Protocol of HTTP request", (Throwable)exception);
            }
            return null;
        }
    }

    @Nullable
    public static String getRequestScheme(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getScheme();
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to determine Scheme of HTTP request", (Throwable)exception);
            }
            return null;
        }
    }

    @Nullable
    public static String getRequestServerName(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getServerName();
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to determine ServerName of HTTP request", (Throwable)exception);
            }
            return null;
        }
    }

    @CheckForSigned
    public static int getRequestServerPort(@Nonnull HttpServletRequest httpServletRequest) {
        try {
            return httpServletRequest.getServerPort();
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to determine ServerPort of HTTP request", (Throwable)exception);
            }
            return -1;
        }
    }

    @Nullable
    public static HttpSession getRequestSession(@Nonnull HttpServletRequest httpServletRequest, boolean bl) {
        try {
            return httpServletRequest.getSession(bl);
        }
        catch (Exception exception) {
            if (ServletHelper.isLogExceptions()) {
                LOGGER.warn("[ServletHelper] Failed to get session (" + bl + ") of HTTP request", (Throwable)exception);
            }
            return null;
        }
    }
}

