/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.request.RequestHelper;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class StaticServerInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticServerInfo.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static StaticServerInfo s_aDefault;
    private final String m_sScheme;
    private final String m_sServerName;
    private final int m_nServerPort;
    private final String m_sContextPath;
    private final String m_sFullServerPath;
    private final String m_sFullServerAndContextPath;

    protected StaticServerInfo(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnegative int n, @Nonnull String string3) {
        this.m_sScheme = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        this.m_sServerName = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"ServerName");
        this.m_nServerPort = RequestHelper.getServerPortToUse(string, n);
        this.m_sContextPath = (String)ValueEnforcer.notNull((Object)string3, (String)"ContextPath");
        this.m_sFullServerPath = RequestHelper.getFullServerName(string, string2, n).toString();
        this.m_sFullServerAndContextPath = this.m_sFullServerPath + string3;
    }

    @Nonnull
    public String getScheme() {
        return this.m_sScheme;
    }

    @Nonnull
    public String getServerName() {
        return this.m_sServerName;
    }

    @CheckForSigned
    public int getServerPort() {
        return this.m_nServerPort;
    }

    @Nonnull
    public String getContextPath() {
        return this.m_sContextPath;
    }

    @Nonnull
    public String getFullServerPath() {
        return this.m_sFullServerPath;
    }

    @Nonnull
    public String getFullContextPath() {
        return this.m_sFullServerAndContextPath;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("scheme", (Object)this.m_sScheme).append("serverName", (Object)this.m_sServerName).append("serverPort", this.m_nServerPort).append("contextPath", (Object)this.m_sContextPath).append("fullServerPath", (Object)this.m_sFullServerPath).append("fullServerAndContextPath", (Object)this.m_sFullServerAndContextPath).getToString();
    }

    public static boolean isSet() {
        return RW_LOCK.readLockedBoolean(() -> s_aDefault != null);
    }

    @Nonnull
    public static StaticServerInfo init(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnegative int n, @Nonnull String string3) {
        if (StaticServerInfo.isSet()) {
            throw new IllegalStateException("Static server info already present!");
        }
        StaticServerInfo staticServerInfo = new StaticServerInfo(string, string2, n, string3);
        LOGGER.info("Static server information set: " + staticServerInfo.toString());
        RW_LOCK.writeLocked(() -> {
            s_aDefault = staticServerInfo;
        });
        return staticServerInfo;
    }

    @Nonnull
    public static StaticServerInfo getInstance() {
        StaticServerInfo staticServerInfo = (StaticServerInfo)RW_LOCK.readLockedGet(() -> s_aDefault);
        if (staticServerInfo == null) {
            throw new IllegalStateException("No default web server info present!");
        }
        return staticServerInfo;
    }
}

