/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.http;

import com.helger.commons.ValueEnforcer;
import com.helger.servlet.io.AbstractServletOutputStream;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CountingOnlyServletOutputStream
extends AbstractServletOutputStream {
    private long m_nContentLength = 0L;

    @Nonnegative
    public long getContentLength() {
        return this.m_nContentLength;
    }

    public void write(int n) {
        ++this.m_nContentLength;
    }

    public void write(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        ValueEnforcer.isArrayOfsLen((byte[])byArray, (int)n, (int)n2);
        this.m_nContentLength += (long)n2;
    }
}

