/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.logging;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.logging.LoggingServletInputStream;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoggingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final String FORM_CONTENT_TYPE = CMimeType.APPLICATION_X_WWW_FORM_URLENCODED.getAsString();
    private static final String METHOD_POST = EHttpMethod.POST.getName();
    private byte[] m_aContent;
    @CodingStyleguideUnaware
    private final Map<String, String[]> m_aParameterMap;
    private final HttpServletRequest m_aDelegate;

    public LoggingHttpServletRequestWrapper(@Nonnull HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this.m_aDelegate = httpServletRequest;
        this.m_aParameterMap = this.isFormPost() ? httpServletRequest.getParameterMap() : Collections.emptyMap();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (ArrayHelper.isEmpty((byte[])this.m_aContent)) {
            return this.m_aDelegate.getInputStream();
        }
        return new LoggingServletInputStream(this.m_aContent);
    }

    public BufferedReader getReader() throws IOException {
        if (ArrayHelper.isEmpty((byte[])this.m_aContent)) {
            return this.m_aDelegate.getReader();
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this._getCharset()));
    }

    @Nullable
    public String getParameter(@Nullable String string) {
        if (ArrayHelper.isEmpty((byte[])this.m_aContent) || this.m_aParameterMap.isEmpty()) {
            return super.getParameter(string);
        }
        Object[] objectArray = this.m_aParameterMap.get(string);
        if (objectArray != null && objectArray.length > 0) {
            return objectArray[0];
        }
        return Arrays.toString(objectArray);
    }

    @Nonnull
    public Map<String, String[]> getParameterMap() {
        if (ArrayHelper.isEmpty((byte[])this.m_aContent) || this.m_aParameterMap.isEmpty()) {
            return super.getParameterMap();
        }
        return this.m_aParameterMap;
    }

    @Nonnull
    public Enumeration<String> getParameterNames() {
        if (ArrayHelper.isEmpty((byte[])this.m_aContent) || this.m_aParameterMap.isEmpty()) {
            return super.getParameterNames();
        }
        return new ParamNameEnumeration(this.m_aParameterMap.keySet());
    }

    @Nullable
    public String[] getParameterValues(@Nullable String string) {
        if (ArrayHelper.isEmpty((byte[])this.m_aContent) || this.m_aParameterMap.isEmpty()) {
            return super.getParameterValues(string);
        }
        return this.m_aParameterMap.get(string);
    }

    @Nonnull
    private Charset _getCharset() {
        String string = this.m_aDelegate.getCharacterEncoding();
        return CharsetHelper.getCharsetFromNameOrDefault((String)string, (Charset)StandardCharsets.UTF_8);
    }

    @Nonnull
    public String getContent() {
        try {
            String string;
            if (this.m_aParameterMap.isEmpty()) {
                this.m_aContent = StreamHelper.getAllBytes((InputStream)this.m_aDelegate.getInputStream());
                string = new String(this.m_aContent, this._getCharset());
            } else {
                string = LoggingHttpServletRequestWrapper._getContentFromParameterMap(this.m_aParameterMap);
                this.m_aContent = string.getBytes(this._getCharset());
            }
            return StringHelper.hasNoText((String)string) ? "[EMPTY]" : string;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Nonnull
    private static String _getContentFromParameterMap(@Nonnull Map<String, String[]> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            for (String string : entry.getValue()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(entry.getKey()).append('=').append(string);
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getParameters() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Map.Entry<String, String[]> entry : this.getParameterMap().entrySet()) {
            String string = entry.getKey();
            Object[] objectArray = entry.getValue();
            if (objectArray.length == 0) {
                commonsHashMap.put((Object)string, (Object)"[EMPTY]");
                continue;
            }
            if (objectArray.length == 1) {
                commonsHashMap.put((Object)string, objectArray[0]);
                continue;
            }
            commonsHashMap.put((Object)string, (Object)Arrays.toString(objectArray));
        }
        return commonsHashMap;
    }

    public boolean isFormPost() {
        String string = this.getContentType();
        return string != null && string.contains(FORM_CONTENT_TYPE) && METHOD_POST.equalsIgnoreCase(ServletHelper.getRequestMethod((HttpServletRequest)this));
    }

    private static class ParamNameEnumeration
    implements Enumeration<String> {
        private final Iterator<String> m_aIt;

        private ParamNameEnumeration(@Nullable Set<String> set) {
            this.m_aIt = set != null ? set.iterator() : Collections.emptyIterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_aIt.hasNext();
        }

        @Override
        public String nextElement() {
            return this.m_aIt.next();
        }
    }
}

