/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionListener;
import java.util.EventListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MockEventListenerList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockEventListenerList.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<EventListener> m_aListener = new CommonsArrayList();

    @Nonnull
    public EChange setFrom(@Nonnull MockEventListenerList mockEventListenerList) {
        ValueEnforcer.notNull((Object)mockEventListenerList, (String)"List");
        if (this == mockEventListenerList) {
            return EChange.UNCHANGED;
        }
        ICommonsList<EventListener> iCommonsList = mockEventListenerList.getAllListeners();
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aListener.isEmpty() && iCommonsList.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aListener.setAll((Iterable)iCommonsList);
            return EChange.CHANGED;
        });
    }

    @Nonnull
    public EChange addListener(@Nonnull EventListener eventListener) {
        ValueEnforcer.notNull((Object)eventListener, (String)"Listener");
        if (!(eventListener instanceof ServletContextListener || eventListener instanceof HttpSessionListener || eventListener instanceof ServletRequestListener)) {
            LOGGER.warn("Passed mock listener is none of ServletContextListener, HttpSessionListener or ServletRequestListener and therefore has no effect. The listener class is: " + String.valueOf(eventListener.getClass()));
        }
        return EChange.valueOf((boolean)this.m_aRWLock.writeLockedBoolean(() -> this.m_aListener.add((Object)eventListener)));
    }

    @Nonnull
    public EChange removeListeners(@Nullable Class<? extends EventListener> clazz) {
        if (clazz == null) {
            return EChange.UNCHANGED;
        }
        return (EChange)this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.UNCHANGED;
            for (EventListener eventListener : (ICommonsList)this.m_aListener.getClone()) {
                if (!eventListener.getClass().equals(clazz)) continue;
                eChange = eChange.or((IChangeIndicator)EChange.valueOf((boolean)this.m_aListener.remove((Object)eventListener)));
            }
            return eChange;
        });
    }

    @Nonnull
    public EChange removeAllListeners() {
        return (EChange)this.m_aRWLock.writeLockedGet(() -> this.m_aListener.removeAll());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<EventListener> getAllListeners() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aListener.getClone());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ServletContextListener> getAllServletContextListeners() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aListener.getAllInstanceOf(ServletContextListener.class));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<HttpSessionListener> getAllHttpSessionListeners() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aListener.getAllInstanceOf(HttpSessionListener.class));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ServletRequestListener> getAllServletRequestListeners() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aListener.getAllInstanceOf(ServletRequestListener.class));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Listeners", this.m_aListener).getToString();
    }
}

