/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.URLHelper;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.http.AcceptCharsetList;
import com.helger.http.AcceptMimeTypeList;
import com.helger.http.CacheControlBuilder;
import com.helger.http.EHttpVersion;
import com.helger.http.QValue;
import com.helger.http.RFC5987Encoder;
import com.helger.servlet.ServletSettings;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.EContentDispositionType;
import com.helger.servlet.response.ERedirectMode;
import com.helger.servlet.response.EResponseStreamType;
import com.helger.servlet.response.EXFrameOptionType;
import com.helger.servlet.response.ResponseHelper;
import com.helger.servlet.response.ResponseHelperSettings;
import com.helger.servlet.response.UnifiedResponseDefaultSettings;
import com.helger.useragent.browser.BrowserInfo;
import com.helger.useragent.browser.EBrowserType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class UnifiedResponse {
    public static final boolean DEFAULT_ALLOW_CONTENT_ON_REDIRECT = false;
    public static final boolean DEFAULT_ALLOW_CONTENT_ON_STATUS_CODE = true;
    public static final EContentDispositionType DEFAULT_CONTENT_DISPOSITION_TYPE = EContentDispositionType.ATTACHMENT;
    public static final boolean DEFAULT_WARN_ON_DUPLICATE_COOKIES = true;
    public static final int MAX_CSS_KB_FOR_IE = 288;
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedResponse.class);
    private static final AtomicInteger RESPONSE_NUM = new AtomicInteger(0);
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);
    private final EHttpVersion m_eHttpVersion;
    private final EHttpMethod m_eHttpMethod;
    private final HttpServletRequest m_aHttpRequest;
    private final AcceptCharsetList m_aAcceptCharsetList;
    private final AcceptMimeTypeList m_aAcceptMimeTypeList;
    private BrowserInfo m_aRequestBrowserInfo;
    private boolean m_bAllowContentOnRedirect = false;
    private boolean m_bAllowContentOnStatusCode = true;
    private Charset m_aCharset;
    private IMimeType m_aMimeType;
    private byte[] m_aContentArray;
    private int m_nContentArrayOfs;
    private int m_nContentArrayLength;
    private IHasInputStream m_aContentISP;
    private EContentDispositionType m_eContentDispositionType = DEFAULT_CONTENT_DISPOSITION_TYPE;
    private String m_sContentDispositionFilename;
    private CacheControlBuilder m_aCacheControl;
    private final HttpHeaderMap m_aResponseHeaderMap = new HttpHeaderMap();
    private int m_nStatusCode = -1;
    private String m_sRedirectTargetUrl;
    private ERedirectMode m_eRedirectMode;
    private boolean m_bWarnOnDuplicateCookies = true;
    private ICommonsOrderedMap<String, Cookie> m_aCookies;
    private boolean m_bHttpHeaderValuesUnified;
    private boolean m_bHttpHeaderValuesQuoteIfNecessary;
    private final int m_nResponseID = RESPONSE_NUM.incrementAndGet();
    private String m_sRequestURL;
    private boolean m_bAlreadyEmittedRequestHeaders = false;
    private final HttpHeaderMap m_aRequestHeaderMap;
    private CharsetEncoder m_aContentDispositionEncoder;

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsOrderedMap<String, Cookie> _createCookieMap() {
        return new CommonsLinkedHashMap();
    }

    public UnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest) {
        this.m_eHttpVersion = (EHttpVersion)ValueEnforcer.notNull((Object)eHttpVersion, (String)"HTTPVersion");
        this.m_eHttpMethod = (EHttpMethod)ValueEnforcer.notNull((Object)eHttpMethod, (String)"HTTPMethod");
        this.m_aHttpRequest = (HttpServletRequest)ValueEnforcer.notNull((Object)httpServletRequest, (String)"HTTPRequest");
        this.m_aAcceptCharsetList = RequestHelper.getAcceptCharsets(httpServletRequest);
        this.m_aAcceptMimeTypeList = RequestHelper.getAcceptMimeTypes(httpServletRequest);
        this.m_aRequestHeaderMap = RequestHelper.getRequestHeaderMap(httpServletRequest);
        this.m_aResponseHeaderMap.setAllHeaders(UnifiedResponseDefaultSettings.getResponseHeaderMap());
        if (UnifiedResponseDefaultSettings.hasCookies()) {
            this.m_aCookies = UnifiedResponse._createCookieMap();
            this.m_aCookies.putAll(UnifiedResponseDefaultSettings.getAllCookies());
        }
        this.m_bHttpHeaderValuesUnified = UnifiedResponseDefaultSettings.isHttpHeaderValuesUnified();
        this.m_bHttpHeaderValuesQuoteIfNecessary = UnifiedResponseDefaultSettings.isHttpHeaderValuesQuoteIfNecessary();
    }

    @Nonnull
    @Nonempty
    protected final String getRequestURL() {
        if (this.m_sRequestURL == null) {
            this.m_sRequestURL = RequestHelper.getURLDecoded(this.m_aHttpRequest);
        }
        return this.m_sRequestURL;
    }

    @Nonnull
    @Nonempty
    protected String getLogPrefix() {
        return "UnifiedResponse[" + this.m_nResponseID + "] to [" + this.m_eHttpMethod.getName() + " " + this.getRequestURL() + "]: ";
    }

    protected void logInfo(@Nonnull String string) {
        LOGGER.info(this.getLogPrefix() + string);
    }

    protected final void showRequestInfo() {
        if (!UnifiedResponse.isSilentMode() && !this.m_bAlreadyEmittedRequestHeaders) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  Request Headers: " + String.valueOf(this.m_aRequestHeaderMap.getAllHeaders().getSortedByKey(Comparator.naturalOrder())));
            if (this.m_aCookies != null && this.m_aCookies.isNotEmpty()) {
                stringBuilder.append("  Request Cookies: " + String.valueOf(this.m_aCookies.getSortedByKey(Comparator.naturalOrder())));
            }
            if (this.m_aResponseHeaderMap.isNotEmpty()) {
                stringBuilder.append("\n  Response Headers: " + String.valueOf(this.m_aResponseHeaderMap.getAllHeaders().getSortedByKey(Comparator.naturalOrder())));
            }
            LOGGER.warn(stringBuilder.toString());
            this.m_bAlreadyEmittedRequestHeaders = true;
        }
    }

    protected void logWarn(@Nonnull String string) {
        LOGGER.warn(this.getLogPrefix() + string);
        this.showRequestInfo();
    }

    protected void logError(@Nonnull String string) {
        LOGGER.error(this.getLogPrefix() + string);
        this.showRequestInfo();
    }

    @Nonnull
    public final EHttpVersion getHttpVersion() {
        return this.m_eHttpVersion;
    }

    @Nonnull
    public final EHttpMethod getHttpMethod() {
        return this.m_eHttpMethod;
    }

    @Nullable
    @Deprecated(forRemoval=true, since="10.1.6")
    public final BrowserInfo getRequestBrowserInfo() {
        return this.m_aRequestBrowserInfo;
    }

    @Nonnull
    @Deprecated(forRemoval=true, since="10.1.6")
    public final UnifiedResponse setRequestBrowserInfo(@Nullable BrowserInfo browserInfo) {
        this.m_aRequestBrowserInfo = browserInfo;
        return this;
    }

    public final boolean isAllowContentOnRedirect() {
        return this.m_bAllowContentOnRedirect;
    }

    @Nonnull
    public final UnifiedResponse setAllowContentOnRedirect(boolean bl) {
        this.m_bAllowContentOnRedirect = bl;
        return this;
    }

    public final boolean isAllowContentOnStatusCode() {
        return this.m_bAllowContentOnStatusCode;
    }

    @Nonnull
    public final UnifiedResponse setAllowContentOnStatusCode(boolean bl) {
        this.m_bAllowContentOnStatusCode = bl;
        return this;
    }

    @Nullable
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final UnifiedResponse setCharset(@Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        if (this.m_aCharset != null) {
            this.logInfo("Overwriting charset from " + String.valueOf(this.m_aCharset) + " to " + String.valueOf(charset));
        }
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeCharset() {
        this.m_aCharset = null;
        return this;
    }

    @Nullable
    public final IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nonnull
    public final UnifiedResponse setMimeType(@Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        if (this.m_aMimeType != null) {
            this.logInfo("Overwriting MimeType from " + String.valueOf(this.m_aMimeType) + " to " + String.valueOf(iMimeType));
        }
        this.m_aMimeType = iMimeType;
        return this;
    }

    @Nonnull
    public final UnifiedResponse setMimeTypeString(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"MimeType");
        MimeType mimeType = MimeTypeParser.safeParseMimeType((String)string);
        if (mimeType != null) {
            this.setMimeType((IMimeType)mimeType);
        } else {
            this.logError("Failed to resolve mime type from '" + string + "'");
        }
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeMimeType() {
        this.m_aMimeType = null;
        return this;
    }

    public final boolean hasContent() {
        return this.m_aContentArray != null || this.m_aContentISP != null;
    }

    @Nonnull
    public final UnifiedResponse setEmptyContent() {
        return this.setContent(ArrayHelper.EMPTY_BYTE_ARRAY, 0, 0);
    }

    @Nonnull
    public final UnifiedResponse setContentAndCharset(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)string, (String)"Content");
        this.setCharset(charset);
        this.setContent(string.getBytes(charset));
        return this;
    }

    @Nonnull
    public final UnifiedResponse setContent(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"Content");
        return this.setContent(byArray, 0, byArray.length);
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public final UnifiedResponse setContent(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen((byte[])byArray, (int)n, (int)n2);
        if (this.hasContent()) {
            this.logInfo("Overwriting content with byte array!");
        }
        this.m_aContentArray = byArray;
        this.m_nContentArrayOfs = n;
        this.m_nContentArrayLength = n2;
        this.m_aContentISP = null;
        return this;
    }

    @Nonnull
    public final UnifiedResponse setContent(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        if (this.hasContent()) {
            this.logInfo("Overwriting content with content provider!");
        }
        this.m_aContentArray = null;
        this.m_nContentArrayOfs = -1;
        this.m_nContentArrayLength = -1;
        this.m_aContentISP = iHasInputStream;
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeContent() {
        this.m_aContentArray = null;
        this.m_nContentArrayOfs = -1;
        this.m_nContentArrayLength = -1;
        this.m_aContentISP = null;
        return this;
    }

    @Nonnull
    public final UnifiedResponse setExpires(@Nonnull LocalDateTime localDateTime) {
        this.m_aResponseHeaderMap.setDateHeader("Expires", localDateTime);
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeExpires() {
        this.m_aResponseHeaderMap.removeHeaders("Expires");
        return this;
    }

    @Nonnull
    public final UnifiedResponse setLastModified(@Nonnull LocalDateTime localDateTime) {
        if (this.m_eHttpMethod != EHttpMethod.GET && this.m_eHttpMethod != EHttpMethod.HEAD) {
            this.logWarn("Setting Last-Modified on a non GET or HEAD request may have no impact!");
        }
        this.m_aResponseHeaderMap.setDateHeader("Last-Modified", localDateTime);
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeLastModified() {
        this.m_aResponseHeaderMap.removeHeaders("Last-Modified");
        return this;
    }

    @Nonnull
    public final UnifiedResponse setETag(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ETag");
        ValueEnforcer.isTrue((string.startsWith("\"") || string.startsWith("W/\"") ? 1 : 0) != 0, () -> "Etag must start with a '\"' character or with 'W/\"': " + string);
        ValueEnforcer.isTrue((boolean)string.endsWith("\""), () -> "Etag must end with a '\"' character: " + string);
        if (this.m_eHttpMethod != EHttpMethod.GET && this.m_eHttpMethod != EHttpMethod.HEAD) {
            this.logWarn("Setting an ETag on a non-GET/HEAD request may have no impact!");
        }
        this.m_aResponseHeaderMap.setHeader("ETag", string);
        return this;
    }

    @Nonnull
    public final UnifiedResponse setETagIfApplicable(@Nonnull @Nonempty String string) {
        if (this.m_eHttpVersion.isAtLeast11()) {
            this.setETag(string);
        }
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeETag() {
        this.m_aResponseHeaderMap.removeHeaders("ETag");
        return this;
    }

    @Nonnull
    public final UnifiedResponse setContentDispositionType(@Nonnull EContentDispositionType eContentDispositionType) {
        ValueEnforcer.notNull((Object)((Object)eContentDispositionType), (String)"ContentDispositionType");
        this.m_eContentDispositionType = eContentDispositionType;
        return this;
    }

    @Nonnull
    public final EContentDispositionType getContentDispositionType() {
        return this.m_eContentDispositionType;
    }

    @Nonnull
    public final UnifiedResponse setContentDispositionFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        String string2 = FilenameHelper.getWithoutPath((String)FilenameHelper.getAsSecureValidFilename((String)string));
        if (!string.equals(string2)) {
            this.logWarn("Content-Dispostion filename was internally modified from '" + string + "' to '" + string2 + "'");
        }
        if (this.m_sContentDispositionFilename != null) {
            this.logInfo("Overwriting Content-Dispostion filename from '" + this.m_sContentDispositionFilename + "' to '" + string2 + "'");
        }
        this.m_sContentDispositionFilename = string2;
        return this;
    }

    @Nullable
    public final String getContentDispositionFilename() {
        return this.m_sContentDispositionFilename;
    }

    @Nonnull
    public final UnifiedResponse removeContentDispositionFilename() {
        this.m_sContentDispositionFilename = null;
        return this;
    }

    @Nonnull
    public final UnifiedResponse setDownloadFilename(@Nonnull @Nonempty String string) {
        this.setMimeType(CMimeType.APPLICATION_FORCE_DOWNLOAD);
        this.setContentDispositionFilename(string);
        return this;
    }

    @Nonnull
    public final UnifiedResponse setCacheControl(@Nonnull CacheControlBuilder cacheControlBuilder) {
        ValueEnforcer.notNull((Object)cacheControlBuilder, (String)"CacheControl");
        if (this.m_aCacheControl != null) {
            this.logInfo("Overwriting Cache-Control data from '" + this.m_aCacheControl.getAsHTTPHeaderValue() + "' to '" + cacheControlBuilder.getAsHTTPHeaderValue() + "'");
        }
        this.m_aCacheControl = cacheControlBuilder;
        return this;
    }

    @Nullable
    @ReturnsMutableObject
    public final CacheControlBuilder cacheControl() {
        return this.m_aCacheControl;
    }

    @Nonnull
    public final UnifiedResponse removeCacheControl() {
        this.m_aCacheControl = null;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    protected final HttpHeaderMap responseHeaderMap() {
        return this.m_aResponseHeaderMap;
    }

    @Nonnull
    public final UnifiedResponse removeCaching() {
        this.removeExpires();
        this.removeCacheControl();
        this.removeETag();
        this.removeLastModified();
        this.m_aResponseHeaderMap.removeHeaders("Pragma");
        return this;
    }

    @Nonnull
    public final UnifiedResponse disableCaching() {
        this.removeCaching();
        if (this.m_eHttpVersion.is10()) {
            this.m_aResponseHeaderMap.setHeader("Expires", ResponseHelperSettings.EXPIRES_NEVER_STRING);
            this.m_aResponseHeaderMap.setHeader("Pragma", "no-cache");
        } else {
            CacheControlBuilder cacheControlBuilder = new CacheControlBuilder().setNoStore(true).setNoCache(true).setMustRevalidate(true).setProxyRevalidate(true);
            this.setCacheControl(cacheControlBuilder);
        }
        return this;
    }

    @Nonnull
    public final UnifiedResponse enableCaching(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"Seconds");
        this.removeExpires();
        this.removeCacheControl();
        this.m_aResponseHeaderMap.removeHeaders("Pragma");
        if (this.m_eHttpVersion.is10()) {
            this.m_aResponseHeaderMap.setDateHeader("Expires", PDTFactory.getCurrentLocalDateTime().plusSeconds(n));
        } else {
            CacheControlBuilder cacheControlBuilder = new CacheControlBuilder().setPublic(true).setMaxAgeSeconds((long)n);
            this.setCacheControl(cacheControlBuilder);
        }
        return this;
    }

    public final boolean isStatusCodeDefined() {
        return this.m_nStatusCode != -1;
    }

    public final int getStatusCode() {
        return this.m_nStatusCode;
    }

    private void _setStatus(@Nonnegative int n) {
        if (this.isStatusCodeDefined()) {
            this.logInfo("Overwriting status code " + this.m_nStatusCode + " with " + n);
        }
        this.m_nStatusCode = n;
    }

    @Nonnull
    public final UnifiedResponse setStatus(@Nonnegative int n) {
        this._setStatus(n);
        return this;
    }

    @Nonnull
    public final UnifiedResponse setStatusUnauthorized(@Nullable String string) {
        this._setStatus(401);
        if (StringHelper.hasText((String)string)) {
            this.m_aResponseHeaderMap.setHeader("WWW-Authenticate", string);
        }
        return this;
    }

    public final boolean isRedirectDefined() {
        return this.m_sRedirectTargetUrl != null;
    }

    @Nonnull
    public final UnifiedResponse setRedirect(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"RedirectTargetUrl");
        return this.setRedirect(iSimpleURL, ERedirectMode.DEFAULT);
    }

    @Nonnull
    public final UnifiedResponse setRedirect(@Nonnull ISimpleURL iSimpleURL, @Nonnull ERedirectMode eRedirectMode) {
        ValueEnforcer.notNull((Object)iSimpleURL, (String)"RedirectTargetUrl");
        return this.setRedirect(iSimpleURL.getAsStringWithEncodedParameters(), eRedirectMode);
    }

    @Nonnull
    public final UnifiedResponse setRedirect(@Nonnull @Nonempty String string) {
        return this.setRedirect(string, ERedirectMode.DEFAULT);
    }

    private static boolean _isRelative(@Nonnull String string) {
        if (URLProtocolRegistry.getInstance().hasKnownProtocol(string)) {
            return false;
        }
        return !string.startsWith("//");
    }

    @Nonnull
    public final UnifiedResponse setRedirect(@Nonnull @Nonempty String string, @Nonnull ERedirectMode eRedirectMode) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"RedirectTargetUrl");
        ValueEnforcer.notNull((Object)((Object)eRedirectMode), (String)"RedirectMode");
        if (UnifiedResponse._isRelative(string) && LOGGER.isDebugEnabled()) {
            LOGGER.debug("The redirect target URL '" + string + "' seems to be relative.");
        }
        if (this.isRedirectDefined()) {
            this.logInfo("Overwriting redirect target URL '" + this.m_sRedirectTargetUrl + "' with '" + string + "'" + (String)(this.m_eRedirectMode == eRedirectMode ? "" : " and mode " + String.valueOf((Object)this.m_eRedirectMode) + " with " + String.valueOf((Object)eRedirectMode)));
        }
        this.m_sRedirectTargetUrl = string;
        this.m_eRedirectMode = eRedirectMode;
        return this;
    }

    public final boolean isWarnOnDuplicateCookies() {
        return this.m_bWarnOnDuplicateCookies;
    }

    @Nonnull
    public final UnifiedResponse setWarnOnDuplicateCookies(boolean bl) {
        this.m_bWarnOnDuplicateCookies = bl;
        return this;
    }

    @Nonnull
    public final UnifiedResponse addCookie(@Nonnull Cookie cookie) {
        ValueEnforcer.notNull((Object)cookie, (String)"Cookie");
        String string = cookie.getName();
        if (this.m_aCookies == null) {
            this.m_aCookies = UnifiedResponse._createCookieMap();
        } else if (this.m_bWarnOnDuplicateCookies && this.m_aCookies.containsKey((Object)string)) {
            this.logWarn("Overwriting cookie '" + string + "' with the new value '" + cookie.getValue() + "'");
        }
        this.m_aCookies.put((Object)string, (Object)cookie);
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeCookie(@Nullable String string) {
        if (this.m_aCookies != null) {
            this.m_aCookies.remove((Object)string);
        }
        return this;
    }

    @Nonnull
    public final EChange removeAllCookies() {
        return this.m_aCookies == null ? EChange.UNCHANGED : this.m_aCookies.removeAll();
    }

    public final boolean hasCookies() {
        return this.m_aCookies != null && this.m_aCookies.isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<String, Cookie> getAllCookies() {
        return new CommonsLinkedHashMap(this.m_aCookies);
    }

    public final boolean isHttpHeaderValuesUnified() {
        return this.m_bHttpHeaderValuesUnified;
    }

    @Nonnull
    public final UnifiedResponse setHttpHeaderValuesUnified(boolean bl) {
        this.m_bHttpHeaderValuesUnified = bl;
        return this;
    }

    public final boolean isHttpHeaderValuesQuoteIfNecessary() {
        return this.m_bHttpHeaderValuesQuoteIfNecessary;
    }

    @Nonnull
    public final UnifiedResponse setHttpHeaderValuesQuoteIfNecessary(boolean bl) {
        this.m_bHttpHeaderValuesQuoteIfNecessary = bl;
        return this;
    }

    @Nonnull
    public final UnifiedResponse setAllowMimeSniffing(boolean bl) {
        if (bl) {
            this.removeCustomResponseHeaders("X-Content-Type-Options");
        } else {
            this.setCustomResponseHeader("X-Content-Type-Options", "nosniff");
        }
        return this;
    }

    @Nonnull
    public final UnifiedResponse setEnableXSSFilter(boolean bl) {
        if (bl) {
            this.setCustomResponseHeader("X-XSS-Protection", "1; mode=block");
        } else {
            this.removeCustomResponseHeaders("X-XSS-Protection");
        }
        return this;
    }

    @Nonnull
    public final UnifiedResponse setStrictTransportSecurity(int n, boolean bl) {
        this.setCustomResponseHeader("Strict-Transport-Security", new CacheControlBuilder().setMaxAgeSeconds((long)n).getAsHTTPHeaderValue() + (bl ? ";includeSubDomains" : ""));
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeStrictTransportSecurity() {
        this.removeCustomResponseHeaders("Strict-Transport-Security");
        return this;
    }

    @Nonnull
    public final UnifiedResponse setXFrameOptions(@Nonnull EXFrameOptionType eXFrameOptionType, @Nullable ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull((Object)((Object)eXFrameOptionType), (String)"Type");
        if (eXFrameOptionType.isURLRequired()) {
            ValueEnforcer.notNull((Object)iSimpleURL, (String)"Domain");
        }
        if (eXFrameOptionType.isURLRequired()) {
            this.setCustomResponseHeader("X-Frame-Options", eXFrameOptionType.getID() + " " + iSimpleURL.getAsStringWithEncodedParameters());
        } else {
            this.setCustomResponseHeader("X-Frame-Options", eXFrameOptionType.getID());
        }
        return this;
    }

    @Nonnull
    public final UnifiedResponse removeXFrameOptions() {
        this.removeCustomResponseHeaders("X-Frame-Options");
        return this;
    }

    public final void addCustomResponseHeader(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_aResponseHeaderMap.addHeader(string, string2);
    }

    public final void addCustomResponseHeaders(@Nullable HttpHeaderMap httpHeaderMap) {
        if (httpHeaderMap != null) {
            this.m_aResponseHeaderMap.setAllHeaders(httpHeaderMap);
        }
    }

    public final void setCustomResponseHeader(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_aResponseHeaderMap.setHeader(string, string2);
    }

    public final void setCustomResponseHeaders(@Nullable HttpHeaderMap httpHeaderMap) {
        this.m_aResponseHeaderMap.removeAll();
        if (httpHeaderMap != null) {
            this.m_aResponseHeaderMap.setAllHeaders(httpHeaderMap);
        }
    }

    @Nonnull
    public final EChange removeCustomResponseHeaders(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        return this.m_aResponseHeaderMap.removeHeaders(string);
    }

    private void _verifyCachingIntegrity() {
        boolean bl = this.m_eHttpVersion.isAtLeast11();
        boolean bl2 = this.m_aResponseHeaderMap.containsHeaders("Expires");
        boolean bl3 = this.m_aCacheControl != null;
        boolean bl4 = this.m_aResponseHeaderMap.containsHeaders("Last-Modified");
        boolean bl5 = this.m_aResponseHeaderMap.containsHeaders("ETag");
        if (bl2 && bl) {
            this.logInfo("Expires found in HTTP 1.1 response: " + String.valueOf(this.m_aResponseHeaderMap.getAllHeaderValues("Expires")));
        }
        if (bl2 && bl3) {
            this.logWarn("Expires and Cache-Control are both present. Cache-Control takes precedence!");
        }
        if (bl5 && !bl) {
            this.logWarn("Sending an ETag for HTTP version " + String.valueOf(this.m_eHttpVersion) + " has no effect!");
        }
        if (!bl2 && !bl3) {
            if (bl4 || bl5) {
                this.logWarn("Validators (Last-Modified and ETag) have no effect if no Expires or Cache-Control is present");
            } else {
                this.logWarn("Response has no caching information at all");
            }
        }
        if (this.m_aCacheControl != null) {
            if (!bl) {
                this.logWarn("Sending a Cache-Control header for HTTP version " + String.valueOf(this.m_eHttpVersion) + " may have no or limited effect!");
            }
            if (this.m_aCacheControl.isPrivate()) {
                if (this.m_aCacheControl.isPublic()) {
                    this.logWarn("Cache-Control cannot be private and public at the same time");
                }
                if (this.m_aCacheControl.hasMaxAgeSeconds()) {
                    this.logWarn("Cache-Control cannot be private and have a max-age definition");
                }
                if (this.m_aCacheControl.hasSharedMaxAgeSeconds()) {
                    this.logWarn("Cache-Control cannot be private and have a s-maxage definition");
                }
            }
        }
    }

    @Nonnull
    @Nonempty
    private static String _getAsStringMimeTypes(@Nonnull ICommonsMap<IMimeType, QValue> iCommonsMap) {
        StringBuilder stringBuilder = new StringBuilder().append('{');
        for (Map.Entry entry : iCommonsMap.getSortedByValue(Comparator.naturalOrder()).entrySet()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((IMimeType)entry.getKey()).getAsString()).append('=').append(((QValue)entry.getValue()).getQuality());
        }
        return stringBuilder.append('}').toString();
    }

    @Nonnull
    @Nonempty
    private static String _getAsStringText(@Nonnull ICommonsMap<String, QValue> iCommonsMap) {
        StringBuilder stringBuilder = new StringBuilder().append('{');
        for (Map.Entry entry : iCommonsMap.getSortedByValue(Comparator.naturalOrder()).entrySet()) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)entry.getKey()).append('=').append(((QValue)entry.getValue()).getQuality());
        }
        return stringBuilder.append('}').toString();
    }

    private void _applyLengthChecks(long l) {
        if (this.m_aMimeType != null && this.m_aMimeType.equals((Object)CMimeType.TEXT_CSS) && l > 294912L) {
            this.logWarn("Internet Explorer has problems handling CSS files > 288KB and this one has " + l + " bytes!");
        }
    }

    private void _applyContent(@Nonnull HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        if (this.m_aContentArray != null) {
            int n = this.m_nContentArrayLength;
            EResponseStreamType eResponseStreamType = ResponseHelper.getBestSuitableOutputStreamType(this.m_aHttpRequest);
            if (eResponseStreamType.isUncompressed()) {
                ResponseHelper.setContentLength(httpServletResponse, n);
            }
            if (n > 0 && this.m_eHttpMethod.isContentAllowed()) {
                try (OutputStream outputStream = ResponseHelper.getBestSuitableOutputStream(this.m_aHttpRequest, httpServletResponse);){
                    outputStream.write(this.m_aContentArray, this.m_nContentArrayOfs, n);
                    outputStream.flush();
                }
                this._applyLengthChecks(n);
            }
        } else if (this.m_aContentISP != null) {
            InputStream inputStream = this.m_aContentISP.getInputStream();
            if (inputStream == null) {
                this.logError("Failed to open input stream from " + String.valueOf(this.m_aContentISP));
                httpServletResponse.setStatus(404);
            } else if (this.m_eHttpMethod.isContentAllowed()) {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                MutableLong mutableLong = new MutableLong(0L);
                if (StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to((OutputStream)servletOutputStream).closeTo(true).copyByteCount(mutableLong).build().isSuccess()) {
                    long l = mutableLong.longValue();
                    this._applyLengthChecks(l);
                } else {
                    boolean bl2 = httpServletResponse.isCommitted();
                    this.logError("Copying from " + String.valueOf(this.m_aContentISP) + " failed after " + mutableLong.longValue() + " bytes! Response is committed: " + bl2);
                    if (!bl2) {
                        httpServletResponse.sendError(500);
                    }
                }
            }
        } else if (!bl) {
            httpServletResponse.setStatus(204);
            this.logWarn("No content present for the response");
        }
    }

    public final void applyToResponse(@Nonnull HttpServletResponse httpServletResponse) throws IOException {
        Iterator iterator;
        Object object;
        ValueEnforcer.notNull((Object)httpServletResponse, (String)"HttpResponse");
        for (Map.Entry entry : this.m_aResponseHeaderMap) {
            object = (String)entry.getKey();
            int n = 0;
            iterator = ((ICommonsList)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                String string3 = string = this.m_bHttpHeaderValuesUnified ? HttpHeaderMap.getUnifiedValue((String)string2, (boolean)this.m_bHttpHeaderValuesQuoteIfNecessary) : string2;
                if (n == 0) {
                    httpServletResponse.setHeader((String)object, string);
                } else {
                    httpServletResponse.addHeader((String)object, string);
                }
                ++n;
            }
        }
        boolean bl = this.isRedirectDefined();
        boolean bl2 = this.isStatusCodeDefined();
        if (bl) {
            if (bl2) {
                this.logWarn("Ignoring provided status code because a redirect is specified!");
            }
            if (!this.m_bAllowContentOnRedirect) {
                if (this.m_aCacheControl != null) {
                    this.logInfo("Ignoring provided Cache-Control because a redirect is specified!");
                }
                if (this.m_sContentDispositionFilename != null) {
                    this.logWarn("Ignoring provided Content-Dispostion filename because a redirect is specified!");
                }
                if (this.m_aMimeType != null) {
                    this.logWarn("Ignoring provided MimeType because a redirect is specified!");
                }
                if (this.m_aCharset != null) {
                    this.logWarn("Ignoring provided charset because a redirect is specified!");
                }
                if (this.hasContent()) {
                    this.logWarn("Ignoring provided content because a redirect is specified!");
                }
            }
            if (ServletSettings.isEncodeURLs()) {
                try {
                    object = httpServletResponse.encodeRedirectURL(this.m_sRedirectTargetUrl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logWarn("Failed to encode redirect target URL '" + this.m_sRedirectTargetUrl + "': " + illegalArgumentException.getMessage());
                    object = this.m_sRedirectTargetUrl;
                }
            } else {
                object = this.m_sRedirectTargetUrl;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response is a redirect to '" + (String)object + "' using mode " + String.valueOf((Object)this.m_eRedirectMode));
            }
            switch (this.m_eRedirectMode) {
                case DEFAULT: {
                    httpServletResponse.sendRedirect((String)object);
                    break;
                }
                case POST_REDIRECT_GET: {
                    if (this.m_eHttpVersion.is10()) {
                        httpServletResponse.setStatus(302);
                    } else {
                        httpServletResponse.setStatus(303);
                    }
                    httpServletResponse.addHeader("Location", (String)object);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unimplemented redirect mode " + String.valueOf((Object)this.m_eRedirectMode) + "!");
                }
            }
            if (!this.m_bAllowContentOnRedirect) {
                return;
            }
        }
        if (bl2) {
            if (bl) {
                this.logWarn("Overriding provided redirect because a status code is specified!");
            }
            if (!this.m_bAllowContentOnStatusCode) {
                if (this.m_aCacheControl != null) {
                    this.logInfo("Ignoring provided Cache-Control because a status code is specified!");
                }
                if (this.m_sContentDispositionFilename != null) {
                    this.logWarn("Ignoring provided Content-Dispostion filename because a status code is specified!");
                }
                if (this.m_aMimeType != null) {
                    this.logWarn("Ignoring provided MimeType because a status code is specified!");
                }
                if (this.m_aCharset != null) {
                    this.logWarn("Ignoring provided charset because a status code is specified!");
                }
                if (this.hasContent()) {
                    this.logWarn("Ignoring provided content because a status code is specified!");
                }
            }
            if (this.m_nStatusCode == 401 && !this.m_aResponseHeaderMap.containsHeaders("WWW-Authenticate")) {
                this.logWarn("Status code UNAUTHORIZED (401) is returned, but no WWW-Authenticate HTTP response header is set!");
            }
            if (this.m_nStatusCode >= 400 && this.m_aContentArray == null) {
                httpServletResponse.sendError(this.m_nStatusCode);
            } else {
                httpServletResponse.setStatus(this.m_nStatusCode);
            }
            if (!this.m_bAllowContentOnStatusCode) {
                return;
            }
            if (!this.hasContent()) {
                return;
            }
        }
        this._verifyCachingIntegrity();
        if (this.m_aCacheControl != null) {
            object = this.m_aCacheControl.getAsHTTPHeaderValue();
            if (StringHelper.hasText((String)object)) {
                httpServletResponse.setHeader("Cache-Control", (String)object);
            } else {
                this.logWarn("An empty Cache-Control was provided!");
            }
        }
        if (this.m_sContentDispositionFilename != null) {
            Object object2;
            object = new StringBuilder();
            if (this.m_aRequestBrowserInfo != null && this.m_aRequestBrowserInfo.getBrowserType() == EBrowserType.IE && this.m_aRequestBrowserInfo.getVersion().getMajor() <= 8) {
                object2 = this.m_aCharset != null ? this.m_aCharset : StandardCharsets.UTF_8;
                ((StringBuilder)object).append(this.m_eContentDispositionType.getID()).append("; filename=").append(URLHelper.urlEncode((String)this.m_sContentDispositionFilename, (Charset)object2));
            } else {
                ((StringBuilder)object).append(this.m_eContentDispositionType.getID()).append("; filename=\"").append(this.m_sContentDispositionFilename).append('\"');
                object2 = RFC5987Encoder.getRFC5987EncodedUTF8((String)this.m_sContentDispositionFilename);
                if (!((String)object2).equals(this.m_sContentDispositionFilename)) {
                    ((StringBuilder)object).append("; filename*=UTF-8''").append((String)object2);
                }
            }
            httpServletResponse.setHeader("Content-Disposition", ((StringBuilder)object).toString());
            if (this.m_aMimeType == null) {
                this.logWarn("Content-Disposition is specified but no MimeType is set. Using the default download MimeType.");
                httpServletResponse.setContentType(CMimeType.APPLICATION_FORCE_DOWNLOAD.getAsString());
            }
        }
        if (this.m_aMimeType != null) {
            object = this.m_aMimeType.getAsString();
            QValue qValue = this.m_aAcceptMimeTypeList.getQValueOfMimeType(this.m_aMimeType);
            if (qValue.isMinimumQuality()) {
                iterator = this.m_aAcceptMimeTypeList.getAllQValuesGreaterThan(qValue.getQuality());
                this.logError("MimeType '" + (String)object + "' is not at all supported by the request. Allowed values are: " + UnifiedResponse._getAsStringMimeTypes((ICommonsMap<IMimeType, QValue>)iterator));
            } else if (qValue.isLowValue() && GlobalDebug.isDebugMode() && !(iterator = this.m_aAcceptMimeTypeList.getAllQValuesGreaterThan(qValue.getQuality())).isEmpty()) {
                this.logWarn("MimeType '" + (String)object + "' is not best supported by the request (" + String.valueOf(qValue) + "). Better MimeTypes are: " + UnifiedResponse._getAsStringMimeTypes((ICommonsMap<IMimeType, QValue>)iterator));
            }
            httpServletResponse.setContentType((String)object);
        } else {
            this.logWarn("No MimeType present");
        }
        if (this.m_aCharset != null) {
            QValue qValue;
            object = this.m_aCharset.name();
            if (this.m_aMimeType == null) {
                this.logWarn("If no MimeType present, the client cannot get notified about the character encoding '" + (String)object + "'");
            }
            if ((qValue = this.m_aAcceptCharsetList.getQValueOfCharset((String)object)).isMinimumQuality()) {
                iterator = this.m_aAcceptCharsetList.getAllQValuesGreaterThan(qValue.getQuality());
                this.logError("Character encoding '" + (String)object + "' is not at all supported by the request. Allowed values are: " + UnifiedResponse._getAsStringText((ICommonsMap<String, QValue>)iterator));
            } else if (qValue.isLowValue() && !(iterator = this.m_aAcceptCharsetList.getAllQValuesGreaterThan(qValue.getQuality())).isEmpty()) {
                this.logWarn("Character encoding '" + (String)object + "' is not best supported by the request (" + String.valueOf(qValue) + "). Better charsets are: " + UnifiedResponse._getAsStringText((ICommonsMap<String, QValue>)iterator));
            }
            httpServletResponse.setCharacterEncoding((String)object);
        } else if (this.m_aMimeType == null) {
            this.logWarn("Also no character encoding present");
        } else {
            switch (this.m_aMimeType.getContentType()) {
                case TEXT: 
                case MULTIPART: {
                    this.logWarn("A character encoding for MimeType '" + this.m_aMimeType.getAsString() + "' is appreciated.");
                    break;
                }
            }
        }
        if (this.m_aCookies != null) {
            for (Cookie cookie : this.m_aCookies.values()) {
                httpServletResponse.addCookie(cookie);
            }
        }
        this._applyContent(httpServletResponse, bl2);
    }

    @Nonnull
    public static UnifiedResponse createSimple(@Nonnull HttpServletRequest httpServletRequest) {
        return new UnifiedResponse(RequestHelper.getHttpVersion(httpServletRequest), RequestHelper.getHttpMethod(httpServletRequest), httpServletRequest);
    }
}

