/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.mock.MockServletContext;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MockServletPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockServletPool.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final MockServletContext m_aSC;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<ServletItem> m_aServlets = new CommonsArrayList();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bInvalidated = false;

    public MockServletPool(@Nonnull MockServletContext mockServletContext) {
        this.m_aSC = (MockServletContext)ValueEnforcer.notNull((Object)mockServletContext, (String)"ServletContext");
    }

    public void registerServlet(@Nonnull Class<? extends Servlet> clazz, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this.registerServlet(clazz, string, string2, null);
    }

    public void registerServlet(@Nonnull Class<? extends Servlet> clazz, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable Map<String, String> map) {
        ValueEnforcer.notNull(clazz, (String)"ServletClass");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ServletPath");
        this.m_aRWLock.writeLocked(() -> {
            Object object2;
            for (Object object2 : this.m_aServlets) {
                if (((ServletItem)object2).getServletPath().equals(string)) {
                    throw new IllegalArgumentException("Another servlet with the path '" + string + "' is already registered: " + object2);
                }
                if (!((ServletItem)object2).getServletName().equals(string2)) continue;
                throw new IllegalArgumentException("Another servlet with the name '" + string2 + "' is already registered: " + object2);
            }
            Iterator iterator = (Servlet)GenericReflection.newInstance((Class)clazz);
            if (iterator == null) {
                throw new IllegalArgumentException("Failed to instantiate servlet class " + clazz);
            }
            object2 = this.m_aSC.createServletConfig(string2, map);
            try {
                iterator.init((ServletConfig)object2);
            }
            catch (ServletException servletException) {
                throw new IllegalStateException("Failed to init servlet " + iterator + " with configuration  " + object2 + " for path '" + string + "'");
            }
            this.m_aServlets.add((Object)new ServletItem((Servlet)iterator, string));
        });
    }

    @Nullable
    public Servlet getServletOfPath(@Nullable String string) {
        return (Servlet)this.m_aRWLock.readLockedGet(() -> {
            int n;
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            if (StringHelper.hasText((String)string)) {
                this.m_aServlets.findAll(servletItem -> servletItem.matchesPath(string), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
            }
            if ((n = commonsArrayList.size()) == 0) {
                return null;
            }
            if (n > 1 && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Found more than 1 servlet matching path '" + string + "' - using first one: " + commonsArrayList);
            }
            return ((ServletItem)commonsArrayList.getFirst()).getServlet();
        });
    }

    public void invalidate() {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bInvalidated) {
                throw new IllegalArgumentException("Servlet pool already invalidated!");
            }
            this.m_bInvalidated = true;
            for (ServletItem servletItem : this.m_aServlets) {
                try {
                    servletItem.getServlet().destroy();
                }
                catch (Exception exception) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("Failed to destroy servlet " + servletItem, (Throwable)exception);
                }
            }
            this.m_aServlets.clear();
        });
    }

    @Immutable
    private static final class ServletItem {
        private final Servlet m_aServlet;
        private final String m_sServletPath;
        private final String m_sServletPathRegEx;

        @Nonnull
        @Nonempty
        private static String _getAsRegEx(@Nonnull @Nonempty String string) {
            String string2 = string;
            if (string2.endsWith("/*")) {
                string2 = string.substring(0, string.length() - 2);
            }
            return StringHelper.replaceAll((String)string2, (String)"*", (CharSequence)".*");
        }

        public ServletItem(@Nonnull Servlet servlet, @Nonnull @Nonempty String string) {
            this.m_aServlet = (Servlet)ValueEnforcer.notNull((Object)servlet, (String)"Servlet");
            this.m_sServletPath = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ServletPath");
            this.m_sServletPathRegEx = ServletItem._getAsRegEx(string);
        }

        @Nonnull
        public Servlet getServlet() {
            return this.m_aServlet;
        }

        @Nonnull
        @Nonempty
        public String getServletName() {
            return this.m_aServlet.getServletConfig().getServletName();
        }

        @Nonnull
        @Nonempty
        public String getServletPath() {
            return this.m_sServletPath;
        }

        public boolean matchesPath(@Nonnull String string) {
            return RegExHelper.stringMatchesPattern((String)this.m_sServletPathRegEx, (String)string);
        }

        public String toString() {
            return new ToStringGenerator((Object)this).append("Servlet", (Object)this.m_aServlet).append("ServletPath", (Object)this.m_sServletPath).append("ServletPathRegEx", (Object)this.m_sServletPathRegEx).getToString();
        }
    }
}

