/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.session;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.iterate.EmptyEnumeration;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.EChange;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SessionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionHelper.class);
    private static final SessionHelper INSTANCE = new SessionHelper();

    private SessionHelper() {
    }

    @Nonnull
    public static EChange safeInvalidateSession(@Nullable HttpSession httpSession) {
        if (httpSession != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invalidating session " + httpSession.getId());
                }
                httpSession.invalidate();
                return EChange.CHANGED;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return EChange.UNCHANGED;
    }

    @Nonnull
    public static Enumeration<String> getAllAttributes(@Nonnull HttpSession httpSession) {
        ValueEnforcer.notNull((Object)httpSession, (String)"Session");
        try {
            return (Enumeration)GenericReflection.uncheckedCast((Object)httpSession.getAttributeNames());
        }
        catch (IllegalStateException illegalStateException) {
            return new EmptyEnumeration();
        }
    }

    @Nonnull
    public static HttpSession safeRenewSession(@Nonnull HttpServletRequest httpServletRequest) {
        ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invalidating session " + httpSession.getId() + " for renewal");
                }
                httpSession.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return httpServletRequest.getSession(true);
    }
}

