/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.useragent.UsetAgentKeyValuePair;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class UserAgentElementList {
    private final ICommonsList<Object> m_aList;

    public UserAgentElementList() {
        this.m_aList = new CommonsArrayList();
    }

    public UserAgentElementList(@Nonnull UserAgentElementList userAgentElementList) {
        this.m_aList = userAgentElementList.getAllElements();
    }

    public void add(@Nonnull UsetAgentKeyValuePair usetAgentKeyValuePair) {
        ValueEnforcer.notNull((Object)usetAgentKeyValuePair, (String)"Pair");
        this.m_aList.add((Object)usetAgentKeyValuePair);
    }

    public void add(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        this.m_aList.add((Object)string);
    }

    public void add(@Nonnull ICommonsList<String> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"Items");
        this.m_aList.add(iCommonsList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Object> getAllElements() {
        return (ICommonsList)this.m_aList.getClone();
    }

    @Nullable
    public String getPairValue(@Nullable String string) {
        for (Object e : this.m_aList) {
            UsetAgentKeyValuePair usetAgentKeyValuePair;
            if (!(e instanceof UsetAgentKeyValuePair) || !EqualsHelper.equals((Object)(usetAgentKeyValuePair = (UsetAgentKeyValuePair)e).getKey(), (Object)string)) continue;
            return usetAgentKeyValuePair.getValue();
        }
        return null;
    }

    @Nullable
    public String getListItemStartingWith(@Nullable String string) {
        for (Object e : this.m_aList) {
            if (!(e instanceof List)) continue;
            for (Object e2 : (List)e) {
                if (!((String)e2).startsWith(string)) continue;
                return (String)e2;
            }
        }
        return null;
    }

    public boolean containsString(@Nullable String string) {
        for (Object e : this.m_aList) {
            if (!(e instanceof String) || !((String)e).equals(string)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getStringValueFollowing(@Nullable String string) {
        int n = -1;
        int n2 = 0;
        for (Object e : this.m_aList) {
            if (!(e instanceof String)) continue;
            if (n >= 0 && n2 == n + 1) {
                return (String)e;
            }
            if (((String)e).equals(string)) {
                n = n2;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator(null).append("List", this.m_aList).getToString();
    }
}

