/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.spider;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.useragent.spider.EWebSpiderType;
import com.helger.useragent.spider.WebSpiderInfo;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.microdom.util.MicroHelper;
import com.helger.xml.microdom.util.XMLListHandler;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class WebSpiderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSpiderManager.class);
    private final ICommonsMap<String, WebSpiderInfo> m_aMap = new CommonsHashMap();

    private WebSpiderManager() {
        this._readSpiderList("codelists/spiderlist.xml");
        this._readSearchSpiders("codelists/spiders_vbulletin.xml");
        this._readSpiderList2("codelists/spiderlist2.xml");
    }

    @Nonnull
    private static String _getUnifiedID(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    private void _readSpiderList(String string) {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)new ClassPathResource(string));
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("spider")) {
            WebSpiderInfo webSpiderInfo = new WebSpiderInfo(iMicroElement.getAttributeValue("ident"));
            webSpiderInfo.setName(MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)"name"));
            String string2 = MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)"type");
            EWebSpiderType eWebSpiderType = EWebSpiderType.getFromIDOrNull(string2);
            if (string2 != null && eWebSpiderType == null && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unknown web spider type '" + string2 + "'");
            }
            webSpiderInfo.setType(eWebSpiderType);
            webSpiderInfo.setInfo(MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)"info"));
            this.m_aMap.put((Object)WebSpiderManager._getUnifiedID(webSpiderInfo.getID()), (Object)webSpiderInfo);
        }
    }

    private void _readSearchSpiders(String string) {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)new ClassPathResource(string));
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("spider")) {
            String string2 = iMicroElement.getAttributeValue("ident");
            WebSpiderInfo webSpiderInfo = (WebSpiderInfo)this.m_aMap.get((Object)WebSpiderManager._getUnifiedID(string2));
            if (webSpiderInfo != null) continue;
            webSpiderInfo = new WebSpiderInfo(string2);
            webSpiderInfo.setName(MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)"name"));
            this.m_aMap.put((Object)WebSpiderManager._getUnifiedID(webSpiderInfo.getID()), (Object)webSpiderInfo);
        }
    }

    private void _readSpiderList2(String string) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (XMLListHandler.readList((IHasInputStream)new ClassPathResource(string), (Collection)commonsArrayList).isFailure()) {
            throw new IllegalStateException("Failed to read spiderlist2 from " + string);
        }
        for (String string3 : commonsArrayList) {
            String string4 = WebSpiderManager._getUnifiedID(string3);
            this.m_aMap.computeIfAbsent((Object)string4, string2 -> new WebSpiderInfo((String)string2).setName(string3));
        }
    }

    @Nonnull
    public static WebSpiderManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<WebSpiderInfo> getAllKnownSpiders() {
        return this.m_aMap.copyOfValues();
    }

    @Nullable
    public WebSpiderInfo getWebSpiderFromUserAgent(@Nonnull String string) {
        String string2 = WebSpiderManager._getUnifiedID(string);
        for (Map.Entry entry : this.m_aMap.entrySet()) {
            if (!string2.contains((CharSequence)entry.getKey())) continue;
            return (WebSpiderInfo)entry.getValue();
        }
        return null;
    }

    private static final class SingletonHolder {
        static final WebSpiderManager INSTANCE = new WebSpiderManager();

        private SingletonHolder() {
        }
    }
}

