/*
 * Decompiled with CFR 0.152.
 */
package com.helger.useragent.uaprofile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.base64.Base64;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.url.URLHelper;
import com.helger.useragent.uaprofile.IUAProfileHeaderProvider;
import com.helger.useragent.uaprofile.UAProfile;
import com.helger.useragent.uaprofile.UAProfileDiff;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class UAProfileDatabase {
    public static final int EXPECTED_MD5_DIGEST_LENGTH = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(UAProfileDatabase.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsSet<UAProfile> UNIQUE_UA_PROFILES = new CommonsHashSet();
    @GuardedBy(value="RW_LOCK")
    private static Consumer<? super UAProfile> s_aNewUAProfileCallback;
    private static final UAProfileDatabase INSTANCE;

    private UAProfileDatabase() {
    }

    @Nullable
    public static Consumer<? super UAProfile> getNewUAProfileCallback() {
        return (Consumer)RW_LOCK.readLockedGet(() -> s_aNewUAProfileCallback);
    }

    public static void setNewUAProfileCallback(@Nullable Consumer<? super UAProfile> consumer) {
        RW_LOCK.writeLocked(() -> {
            s_aNewUAProfileCallback = consumer;
        });
    }

    @Nullable
    private static String _getExtendedNamespaceValue(@Nonnull String string) {
        Matcher matcher = RegExHelper.getMatcher((String)".+ns=(\\d+).*", (String)string);
        return matcher.matches() ? matcher.group(1) : null;
    }

    @Nonnull
    private static String _getUnifiedHeaderName(@Nonnull String string) {
        return string.toLowerCase(Locale.US);
    }

    @Nullable
    private static String _getCleanedUp(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return string;
        }
        String string2 = string.trim();
        if (StringHelper.getFirstChar((CharSequence)string2) == '\"') {
            string2 = string2.substring(1);
        }
        if (StringHelper.getLastChar((CharSequence)string2) == '\"') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Nonnull
    private static ICommonsMap<Integer, String> _getProfileDiffData(@Nonnull IUAProfileHeaderProvider iUAProfileHeaderProvider, String string) {
        ICommonsCollection<String> iCommonsCollection = iUAProfileHeaderProvider.getHeaders("X-Wap-Profile-Diff");
        if (iCommonsCollection.isEmpty() && (iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Profile-Diff")).isEmpty()) {
            iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Wap-Profile-Diff");
        }
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Object object : iCommonsCollection) {
            int n = ((String)(object = ((String)object).trim())).indexOf(59);
            if (n == -1) {
                LOGGER.warn("Failed to find ';' in profile diff header value '" + (String)object + "'!");
                continue;
            }
            String string2 = ((String)object).substring(0, n);
            int n2 = StringParser.parseInt((String)string2, (int)-1);
            if (n2 == -1) {
                LOGGER.warn("Failed to convert UAProf difference index '" + string2 + "' to a number!");
                continue;
            }
            object = ((String)object).substring(n + 1).trim();
            commonsHashMap.put((Object)n2, object);
        }
        if (commonsHashMap.isEmpty() && string != null) {
            String string3 = UAProfileDatabase._getUnifiedHeaderName(string + "-Profile-Diff-");
            for (String string4 : iUAProfileHeaderProvider.getAllHeaderNames()) {
                if (!(string4 = UAProfileDatabase._getUnifiedHeaderName(string4)).startsWith(string3)) continue;
                int n = StringParser.parseInt((String)string4.substring(string3.length()), (int)-1);
                if (n != -1) {
                    String string5 = iUAProfileHeaderProvider.getHeaderValue(string4);
                    string5 = UAProfileDatabase._getCleanedUp(string5);
                    commonsHashMap.put((Object)n, (Object)string5);
                    continue;
                }
                LOGGER.warn("Failed to extract numerical number from header name '" + string4 + "'");
            }
        }
        return commonsHashMap;
    }

    @Nullable
    public static UAProfile getUAProfileFromRequest(@Nonnull IUAProfileHeaderProvider iUAProfileHeaderProvider) {
        Object object;
        Object object2;
        String string3;
        Object object3;
        ValueEnforcer.notNull((Object)iUAProfileHeaderProvider, (String)"HeaderProvider");
        String string2 = null;
        ICommonsCollection<String> iCommonsCollection = iUAProfileHeaderProvider.getHeaders("X-Wap-Profile");
        if (iCommonsCollection.isEmpty() && (iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Profile")).isEmpty() && (iCommonsCollection = iUAProfileHeaderProvider.getHeaders("Wap-Profile")).isEmpty()) {
            object3 = iUAProfileHeaderProvider.getHeaderValue("Opt");
            if (object3 == null) {
                object3 = iUAProfileHeaderProvider.getHeaderValue("Man");
            }
            if (object3 != null) {
                string2 = UAProfileDatabase._getExtendedNamespaceValue((String)object3);
                if (string2 != null) {
                    iCommonsCollection = iUAProfileHeaderProvider.getHeaders(string2 + "-Profile");
                    if (iCommonsCollection.isEmpty()) {
                        LOGGER.warn("Found CCPP header namespace '" + string2 + "' but found no profile header!");
                    }
                } else {
                    LOGGER.warn("Failed to extract namespace value from CCPP header '" + (String)object3 + "'");
                }
            }
        }
        object3 = new CommonsArrayList();
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (String string3 : iCommonsCollection) {
            if (!StringHelper.hasText((String)(string3 = UAProfileDatabase._getCleanedUp(string3)))) continue;
            Iterator iterator = new StringTokenizer(string3, "\",");
            while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                Object object4 = ((StringTokenizer)((Object)iterator)).nextToken().trim();
                if (!StringHelper.hasText((String)object4)) continue;
                object2 = RegExHelper.getMatcher((String)"^(\\d+)-(.+)$", (String)object4);
                if (((Matcher)object2).matches()) {
                    object = ((Matcher)object2).group(1);
                    String string4 = ((Matcher)object2).group(2);
                    int n = StringParser.parseInt((String)object, (int)-1);
                    if (n != -1) {
                        if (StringHelper.hasText((String)string4)) {
                            byte[] byArray = Base64.safeDecode((String)string4);
                            if (byArray != null) {
                                if (byArray.length == 16) {
                                    commonsHashMap.put((Object)n, (Object)byArray);
                                    continue;
                                }
                                LOGGER.warn("Decoded Base64 profile diff digest has an illegal length of " + byArray.length);
                                continue;
                            }
                            LOGGER.warn("Failed to decode Base64 profile diff digest '" + string4 + "' from token '" + (String)object4 + "'");
                            continue;
                        }
                        LOGGER.warn("Found no diff digest in token '" + (String)object4 + "'");
                        continue;
                    }
                    LOGGER.warn("Failed to parse profile diff index from '" + (String)object4 + "'");
                    continue;
                }
                if (URLHelper.getAsURL((String)object4) != null) {
                    object3.add(object4);
                    continue;
                }
                LOGGER.error("Failed to convert profile token '" + (String)object4 + "' to a URL!");
            }
        }
        if (object3.isEmpty() && commonsHashMap.isEmpty()) {
            return null;
        }
        ICommonsMap<Integer, String> iCommonsMap = UAProfileDatabase._getProfileDiffData(iUAProfileHeaderProvider, string2);
        string3 = new CommonsHashMap();
        for (Object object4 : iCommonsMap.entrySet()) {
            object2 = (Integer)object4.getKey();
            object = (byte[])commonsHashMap.get(object2);
            if (object != null) {
                string3.put(object2, (Object)new UAProfileDiff((String)object4.getValue(), (byte[])object));
                continue;
            }
            LOGGER.warn("Found profile diff data but no digest for index " + (Integer)object2);
        }
        for (Object object4 : commonsHashMap.keySet()) {
            if (iCommonsMap.containsKey(object4)) continue;
            LOGGER.warn("Found profile diff digest but no data for index " + (Integer)object4);
        }
        if (object3.isEmpty() && string3.isEmpty()) {
            return null;
        }
        return new UAProfile((List<String>)object3, (Map<Integer, UAProfileDiff>)((Object)string3));
    }

    @Nonnull
    public static UAProfile getParsedUAProfile(@Nonnull IUAProfileHeaderProvider iUAProfileHeaderProvider) {
        boolean bl;
        UAProfile uAProfile = UAProfileDatabase.getUAProfileFromRequest(iUAProfileHeaderProvider);
        if (uAProfile == null) {
            return UAProfile.EMPTY;
        }
        if (uAProfile.isSet() && (bl = RW_LOCK.writeLockedBoolean(() -> UNIQUE_UA_PROFILES.add((Object)uAProfile)))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Found UA-Profile info: " + uAProfile.toString());
            }
            if (s_aNewUAProfileCallback != null) {
                s_aNewUAProfileCallback.accept(uAProfile);
            }
        }
        return uAProfile;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<UAProfile> getAllUniqueUAProfiles() {
        return (ICommonsSet)RW_LOCK.readLockedGet(() -> UNIQUE_UA_PROFILES.getClone());
    }

    static {
        INSTANCE = new UAProfileDatabase();
    }
}

