/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.encoding;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.codec.IEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AndroidFilenameEncoder
implements IEncoder<String, String> {
    public static final char DEFAULT_REPLACEMENT_CHAR = '_';
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._-+,@\u00a3$\u20ac!\u00bd\u00a7~'=()[]{}0123456789";

    @Nonnull
    public static String getSafeAndroidFilename(@Nonnull String string) {
        return AndroidFilenameEncoder.getSafeAndroidFilename(string, '_');
    }

    @Nonnull
    public static String getSafeAndroidFilename(@Nonnull String string, char c) {
        ValueEnforcer.notNull((Object)string, (String)"Src");
        if (ALLOWED_CHARS.indexOf(c) < 0) {
            throw new IllegalArgumentException("Passed character is an invalid replacement char: " + c);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c2 : string.toCharArray()) {
            if (ALLOWED_CHARS.indexOf(c2) >= 0) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getEncoded(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return AndroidFilenameEncoder.getSafeAndroidFilename(string);
    }
}

