/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.web.fileupload.IFileItem;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FileItemResource
implements IReadableResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileItemResource.class);
    private final IFileItem m_aFileItem;
    private int m_nHashCode = 0;

    public FileItemResource(@Nonnull IFileItem iFileItem) {
        this.m_aFileItem = (IFileItem)ValueEnforcer.notNull((Object)iFileItem, (String)"FileItem");
    }

    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Nonnull
    public String getPath() {
        return this.m_aFileItem.getNameSecure();
    }

    @Nullable
    public InputStream getInputStream() {
        return this.m_aFileItem.getInputStream();
    }

    public boolean isReadMultiple() {
        return this.m_aFileItem.isReadMultiple();
    }

    public boolean exists() {
        return true;
    }

    @Nullable
    public URL getAsURL() {
        LOGGER.warn("Cannot convert an IFileItem to a URL: " + this.toString());
        return null;
    }

    @Nullable
    public File getAsFile() {
        LOGGER.warn("Cannot convert an IFileItem to a File: " + this.toString());
        return null;
    }

    @Nonnull
    public IReadableResource getReadableCloneForPath(@Nonnull String string) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FileItemResource fileItemResource = (FileItemResource)object;
        return this.m_aFileItem.equals(fileItemResource.m_aFileItem);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_aFileItem).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("fileItem", (Object)this.m_aFileItem).getToString();
    }
}

