/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.parse;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FileOperations;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.system.SystemProperties;
import com.helger.web.fileupload.IFileItem;
import com.helger.web.fileupload.IFileItemHeaders;
import com.helger.web.fileupload.IFileItemHeadersSupport;
import com.helger.web.fileupload.exception.FileUploadException;
import com.helger.web.fileupload.io.DeferredFileOutputStream;
import com.helger.web.fileupload.io.FileUploadHelper;
import com.helger.web.fileupload.parse.ParameterParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DiskFileItem
implements IFileItem,
IFileItemHeadersSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskFileItem.class);
    public static final Charset DEFAULT_CHARSET_OBJ = StandardCharsets.ISO_8859_1;
    public static final String DEFAULT_CHARSET = DEFAULT_CHARSET_OBJ.name();
    private static final String UID = StringHelper.replaceAll((String)StringHelper.replaceAll((String)UUID.randomUUID().toString(), (char)':', (char)'_'), (char)'-', (char)'_');
    private static final AtomicInteger TEMP_FILE_COUNTER = new AtomicInteger(0);
    private String m_sFieldName;
    private final String m_sContentType;
    private boolean m_bIsFormField;
    private final String m_sFilename;
    private long m_nSize = -1L;
    private final int m_nSizeThreshold;
    private final File m_aTempDir;
    private byte[] m_aCachedContent;
    private DeferredFileOutputStream m_aDFOS;
    private File m_aTempFile;
    private File m_aDFOSFile;
    private IFileItemHeaders m_aHeaders;

    public DiskFileItem(@Nullable String string, @Nullable String string2, boolean bl, @Nullable String string3, @Nonnegative int n, @Nullable File file) {
        this.m_sFieldName = string;
        this.m_sContentType = string2;
        this.m_bIsFormField = bl;
        this.m_sFilename = string3;
        this.m_nSizeThreshold = ValueEnforcer.isGT0((int)n, (String)"SizeThreshold");
        File file2 = this.m_aTempDir = file != null ? file : new File(SystemProperties.getTmpDir());
        if (!FileHelper.existsDir((File)this.m_aTempDir)) {
            throw new IllegalArgumentException("The tempory directory for file uploads is not existing: " + this.m_aTempDir.getAbsolutePath());
        }
        if (!this.m_aTempDir.canRead()) {
            throw new IllegalArgumentException("The tempory directory for file uploads cannot be read: " + this.m_aTempDir.getAbsolutePath());
        }
        if (!this.m_aTempDir.canWrite()) {
            throw new IllegalArgumentException("The tempory directory for file uploads cannot be written: " + this.m_aTempDir.getAbsolutePath());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.m_aDFOS.isInMemory()) {
            this._ensureCachedContentIsPresent();
        } else {
            this.m_aCachedContent = null;
            this.m_aDFOSFile = this.m_aDFOS.getFile();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try (DeferredFileOutputStream deferredFileOutputStream = this.getOutputStream();){
            if (this.m_aCachedContent != null) {
                ((OutputStream)deferredFileOutputStream).write(this.m_aCachedContent);
            } else {
                FileInputStream fileInputStream = FileHelper.getInputStream((File)this.m_aDFOSFile);
                StreamHelper.copyInputStreamToOutputStream((InputStream)fileInputStream, (OutputStream)deferredFileOutputStream);
                FileOperations.deleteFile((File)this.m_aDFOSFile);
                this.m_aDFOSFile = null;
            }
        }
        this.m_aCachedContent = null;
    }

    @Nonnull
    public final File getTempDirectory() {
        return this.m_aTempDir;
    }

    @Nonnull
    protected File getTempFile() {
        if (this.m_aTempFile == null) {
            String string = StringHelper.getLeadingZero((int)TEMP_FILE_COUNTER.getAndIncrement(), (int)8);
            String string2 = "upload_" + UID + "_" + string + ".tmp";
            this.m_aTempFile = new File(this.m_aTempDir, string2);
        }
        return this.m_aTempFile;
    }

    private void _ensureCachedContentIsPresent() {
        if (this.m_aCachedContent == null) {
            this.m_aCachedContent = this.m_aDFOS.getData();
        }
    }

    @Override
    @Nonnull
    public InputStream getInputStream() {
        if (this.isInMemory()) {
            this._ensureCachedContentIsPresent();
            return new NonBlockingByteArrayInputStream(this.m_aCachedContent);
        }
        return FileHelper.getInputStream((File)this.m_aDFOS.getFile());
    }

    public boolean isReadMultiple() {
        return true;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.m_sContentType;
    }

    @Nullable
    public String getCharSet() {
        ICommonsMap<String, String> iCommonsMap = new ParameterParser().setLowerCaseNames(true).parse(this.getContentType(), ';');
        return (String)iCommonsMap.get((Object)"charset");
    }

    @Override
    @Nullable
    public String getNameUnchecked() {
        return this.m_sFilename;
    }

    @Override
    @Nullable
    public String getName() {
        return FileUploadHelper.checkFileName(this.m_sFilename);
    }

    @Override
    @Nullable
    public String getNameSecure() {
        String string = FilenameHelper.getAsSecureValidFilename((String)this.m_sFilename);
        if (!EqualsHelper.equals((Object)string, (Object)this.m_sFilename)) {
            LOGGER.info("FileItem filename was changed from '" + this.m_sFilename + "' to '" + string + "'");
        }
        return string;
    }

    @Override
    public boolean isInMemory() {
        return this.m_aCachedContent != null || this.m_aDFOS.isInMemory();
    }

    @Override
    @Nonnegative
    public long getSize() {
        if (this.m_nSize >= 0L) {
            return this.m_nSize;
        }
        if (this.m_aCachedContent != null) {
            return this.m_aCachedContent.length;
        }
        if (this.m_aDFOS.isInMemory()) {
            return this.m_aDFOS.getDataLength();
        }
        return this.m_aDFOS.getFile().length();
    }

    @Override
    @Nullable
    @ReturnsMutableObject(value="Speed")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] directGet() {
        if (this.isInMemory()) {
            this._ensureCachedContentIsPresent();
            return this.m_aCachedContent;
        }
        return SimpleFileIO.getAllFileBytes((File)this.m_aDFOS.getFile());
    }

    @Nullable
    @ReturnsMutableCopy
    public byte[] getCopy() {
        if (this.isInMemory()) {
            this._ensureCachedContentIsPresent();
            return ArrayHelper.getCopy((byte[])this.m_aCachedContent);
        }
        return SimpleFileIO.getAllFileBytes((File)this.m_aDFOS.getFile());
    }

    @Override
    @Nonnull
    public String getString() {
        return this.getStringWithFallback(DEFAULT_CHARSET_OBJ);
    }

    @Nonnull
    public String getStringWithFallback(@Nonnull Charset charset) {
        String string = this.getCharSet();
        Charset charset2 = CharsetHelper.getCharsetFromNameOrDefault((String)string, (Charset)charset);
        return this.getString(charset2);
    }

    @Override
    @Nonnull
    public ISuccessIndicator write(@Nonnull File file) throws FileUploadException {
        ValueEnforcer.notNull((Object)file, (String)"DstFile");
        if (this.isInMemory()) {
            return SimpleFileIO.writeFile((File)file, (byte[])this.directGet());
        }
        File file2 = this.getStoreLocation();
        if (file2 != null) {
            this.m_nSize = file2.length();
            if (FileOperations.renameFile((File)file2, (File)file).isSuccess()) {
                return ESuccess.SUCCESS;
            }
            return FileOperations.copyFile((File)file2, (File)file);
        }
        throw new FileUploadException("Cannot write uploaded file to: " + file.getAbsolutePath());
    }

    @Override
    public void delete() {
        FileIOError fileIOError;
        this.m_aCachedContent = null;
        File file = this.getStoreLocation();
        if (file != null && (fileIOError = FileOperations.deleteFileIfExisting((File)file)).isFailure()) {
            LOGGER.error("Failed to delete temporary file " + file + " with error " + fileIOError.toString());
        }
    }

    @Override
    @Nullable
    public String getFieldName() {
        return this.m_sFieldName;
    }

    @Override
    public void setFieldName(@Nullable String string) {
        this.m_sFieldName = string;
    }

    @Override
    public boolean isFormField() {
        return this.m_bIsFormField;
    }

    @Override
    public void setFormField(boolean bl) {
        this.m_bIsFormField = bl;
    }

    @Override
    @Nullable
    public IFileItemHeaders getHeaders() {
        return this.m_aHeaders;
    }

    @Override
    public void setHeaders(@Nullable IFileItemHeaders iFileItemHeaders) {
        this.m_aHeaders = iFileItemHeaders;
    }

    @Override
    @Nonnull
    public DeferredFileOutputStream getOutputStream() {
        if (this.m_aDFOS == null) {
            File file = this.getTempFile();
            this.m_aDFOS = new DeferredFileOutputStream(this.m_nSizeThreshold, file);
        }
        return this.m_aDFOS;
    }

    @Nullable
    public File getStoreLocation() {
        return this.m_aDFOS == null ? null : this.m_aDFOS.getFile();
    }

    @Override
    public void onEndOfRequest() {
        if (this.m_aDFOS != null) {
            LOGGER.info("Deleting temporary DiskFileItem " + this.m_aDFOS.getFile());
            FileOperations.deleteFileIfExisting((File)this.m_aDFOS.getFile());
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("nameSecure", (Object)this.getNameSecure()).appendIfNotNull("storeLocation", (Object)this.getStoreLocation()).append("size", this.getSize()).append("isFormField", this.m_bIsFormField).append("fieldName", (Object)this.m_sFieldName).append("headers", (Object)this.m_aHeaders).getToString();
    }
}

