/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.attr.IAttributeContainerAny;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.string.StringHelper;
import com.helger.servlet.request.RequestHelper;
import com.helger.web.fileupload.IFileItem;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IRequestParamContainer
extends IAttributeContainerAny<String> {
    @Nonnull
    default public ICommonsMap<String, IFileItem> getAllUploadedFileItems() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Map.Entry entry : this.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof IFileItem)) continue;
            commonsHashMap.put((Object)((String)entry.getKey()), (Object)((IFileItem)v));
        }
        return commonsHashMap;
    }

    @Nonnull
    default public ICommonsMap<String, IFileItem[]> getAllUploadedFileItemsComplete() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Map.Entry entry : this.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof IFileItem) {
                commonsHashMap.put((Object)string, (Object)new IFileItem[]{(IFileItem)v});
                continue;
            }
            if (!(v instanceof IFileItem[])) continue;
            commonsHashMap.put((Object)string, (Object)((IFileItem[])ArrayHelper.getCopy((Object[])((IFileItem[])v))));
        }
        return commonsHashMap;
    }

    @Nonnull
    default public ICommonsList<IFileItem> getAllUploadedFileItemValues() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (Object e : this.values()) {
            if (e instanceof IFileItem) {
                commonsArrayList.add((Object)((IFileItem)e));
                continue;
            }
            if (!(e instanceof IFileItem[])) continue;
            Collections.addAll(commonsArrayList, (IFileItem[])e);
        }
        return commonsArrayList;
    }

    @Nullable
    default public IFileItem getAsFileItem(@Nullable String string) {
        return (IFileItem)this.getSafeCastedValue(string, IFileItem.class);
    }

    default public boolean isCheckBoxChecked(@Nullable String string, boolean bl) {
        if (StringHelper.hasText((String)string)) {
            String string2 = this.getAsString(string);
            if (string2 != null) {
                return true;
            }
            if (this.containsKey(RequestHelper.getCheckBoxHiddenFieldName((String)string))) {
                return false;
            }
        }
        return bl;
    }

    default public boolean hasCheckBoxValue(@Nonnull @Nonempty String string, @Nonnull String string2, boolean bl) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FieldName");
        ValueEnforcer.notNull((Object)string2, (String)"FieldValue");
        ICommonsOrderedSet iCommonsOrderedSet = this.getAsStringSet(string);
        if (iCommonsOrderedSet != null) {
            return iCommonsOrderedSet.contains((Object)string2);
        }
        iCommonsOrderedSet = this.getAsStringSet(RequestHelper.getCheckBoxHiddenFieldName((String)string));
        if (iCommonsOrderedSet != null && iCommonsOrderedSet.contains((Object)string2)) {
            return false;
        }
        return bl;
    }

    @Nullable
    default public String getAsStringTrimmed(@Nullable String string) {
        return StringHelper.trim((String)this.getAsString(string));
    }

    @Nullable
    default public String getAsStringTrimmed(@Nullable String string, @Nullable String string2) {
        return StringHelper.trim((String)this.getAsString(string, string2));
    }
}

