/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.impl;

import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import com.helger.scope.SessionScope;
import com.helger.web.scope.ISessionWebScope;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionWebScope
extends SessionScope
implements ISessionWebScope {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionWebScope.class);
    private final LocalDateTime m_aCreationDT = PDTFactory.getCurrentLocalDateTime();
    private final HttpSession m_aHttpSession;

    public SessionWebScope(@Nonnull HttpSession httpSession) {
        super(httpSession.getId());
        this.m_aHttpSession = httpSession;
    }

    @Override
    @Nonnull
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    public void initScope() {
        Enumeration enumeration = this.m_aHttpSession.getAttributeNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = this.m_aHttpSession.getAttribute(string);
                this.attrs().putIn((Object)string, object);
            }
        }
    }

    @Nonnull
    public EContinue selfDestruct() {
        try {
            this.m_aHttpSession.invalidate();
            return EContinue.BREAK;
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn("Session '" + this.getID() + "' was already invalidated, but was still contained!");
            return EContinue.CONTINUE;
        }
    }

    @Override
    @Nonnull
    public HttpSession getSession() {
        return this.m_aHttpSession;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("HttpSession", (Object)this.m_aHttpSession).getToString();
    }

    private static /* synthetic */ EContinue lambda$new$0(String string, Object object) {
        if (object != null && !(object instanceof Serializable)) {
            LOGGER.warn("Value of class " + object.getClass().getName() + " should implement Serializable!");
        }
        return EContinue.CONTINUE;
    }
}

