/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.scope.mgr;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.scope.ISessionScope;
import com.helger.scope.mgr.ScopeSessionManager;
import com.helger.web.scope.ISessionWebScope;
import jakarta.servlet.http.HttpSession;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class WebScopeSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebScopeSessionManager.class);
    private static final WebScopeSessionManager INSTANCE = new WebScopeSessionManager();

    private WebScopeSessionManager() {
    }

    @Nullable
    public static ISessionWebScope getSessionWebScopeOfID(@Nullable String string) {
        ISessionScope iSessionScope = ScopeSessionManager.getInstance().getSessionScopeOfID(string);
        if (iSessionScope == null) {
            return null;
        }
        if (!(iSessionScope instanceof ISessionWebScope)) {
            LOGGER.warn("The passed scope ID '" + string + "' is not a session web scope: " + iSessionScope.toString());
            return null;
        }
        return (ISessionWebScope)iSessionScope;
    }

    @Nullable
    public static ISessionWebScope getSessionWebScopeOfSession(@Nullable HttpSession httpSession) {
        return httpSession == null ? null : WebScopeSessionManager.getSessionWebScopeOfID(httpSession.getId());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsCollection<ISessionWebScope> getAllSessionWebScopes() {
        return ScopeSessionManager.getInstance().getAllSessionScopes().getAllInstanceOf(ISessionWebScope.class);
    }

    public static void destroyAllWebSessions() {
        for (ISessionWebScope iSessionWebScope : WebScopeSessionManager.getAllSessionWebScopes()) {
            if (!iSessionWebScope.selfDestruct().isContinue()) continue;
            ScopeSessionManager.getInstance().onScopeEnd((ISessionScope)iSessionWebScope);
        }
    }
}

