/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.encoding;

import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.RFC1522BCodec;
import com.helger.commons.codec.RFC1522QCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public final class RFC2047Helper {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final RFC2047Helper INSTANCE = new RFC2047Helper();

    private RFC2047Helper() {
    }

    @Nullable
    public static String encode(@Nullable String string) {
        return RFC2047Helper.encode(string, DEFAULT_CHARSET, ECodec.B);
    }

    @Nullable
    public static String encode(@Nullable String string, @Nonnull Charset charset) {
        return RFC2047Helper.encode(string, charset, ECodec.B);
    }

    @Nullable
    public static String encode(@Nullable String string, @Nonnull Charset charset, ECodec eCodec) {
        if (string == null) {
            return null;
        }
        try {
            switch (eCodec.ordinal()) {
                case 1: {
                    return new RFC1522QCodec(charset).getEncoded(string);
                }
            }
            return new RFC1522BCodec(charset).getEncoded(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    @Nullable
    public static String decode(@Nullable String string) {
        if (string == null) {
            return null;
        }
        try {
            return new RFC1522BCodec().getDecoded(string);
        }
        catch (DecodeException decodeException) {
            try {
                return new RFC1522QCodec().getDecoded(string);
            }
            catch (Exception exception) {
                return string;
            }
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static enum ECodec {
        B,
        Q;

    }
}

