/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload;

import com.helger.commons.io.IHasInputStream;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.web.fileupload.exception.FileUploadException;
import jakarta.activation.DataSource;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IFileItem
extends DataSource,
IHasInputStream {
    @Nonnull
    public InputStream getInputStream();

    @Nonnull
    public OutputStream getOutputStream();

    @Nullable
    public String getContentType();

    @Nullable
    public String getName();

    @Nullable
    public String getNameSecure();

    @Nullable
    public String getNameUnchecked();

    public boolean isInMemory();

    @Nonnegative
    public long getSize();

    public byte[] directGet();

    @Nonnull
    default public String getString(@Nonnull Charset charset) {
        return new String(this.directGet(), charset);
    }

    @Nonnull
    public String getString();

    @Nonnull
    public ISuccessIndicator write(@Nonnull File var1) throws FileUploadException;

    public void delete();

    public String getFieldName();

    public void setFieldName(String var1);

    public boolean isFormField();

    public void setFormField(boolean var1);

    public void onEndOfRequest();
}

