/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.parse;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.IteratorHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.web.fileupload.IFileItemHeaders;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FileItemHeaders
implements IFileItemHeaders {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsMap<String, ICommonsList<String>> m_aHeaderNameToValueListMap = new CommonsHashMap();
    private final ICommonsOrderedSet<String> m_aHeaderNameList = new CommonsLinkedHashSet();

    @Override
    @Nullable
    public String getHeader(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"HeaderName");
        String string2 = string.toLowerCase(Locale.US);
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aHeaderNameToValueListMap.get((Object)string2));
        return iCommonsList == null ? null : (String)iCommonsList.getFirstOrNull();
    }

    @Override
    @Nullable
    public String getHeaderContentDisposition() {
        return this.getHeader("Content-Disposition");
    }

    @Override
    @Nullable
    public String getHeaderContentType() {
        return this.getHeader("Content-Type");
    }

    @Override
    @Nullable
    public String getHeaderContentLength() {
        return this.getHeader("Content-Length");
    }

    @Override
    @Nonnull
    public Iterator<String> getHeaders(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"HeaderName");
        String string2 = string.toLowerCase(Locale.US);
        ICommonsList iCommonsList = (ICommonsList)this.m_aRWLock.readLockedGet(() -> (ICommonsList)this.m_aHeaderNameToValueListMap.get((Object)string2));
        return IteratorHelper.getIterator((Iterable)iCommonsList);
    }

    @Override
    @Nonnull
    public Iterator<String> getHeaderNames() {
        return (Iterator)this.m_aRWLock.readLockedGet(() -> this.m_aHeaderNameList.iterator());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllHeaderNames() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aHeaderNameList.getCopyAsList());
    }

    public void addHeader(@Nonnull String string, @Nullable String string2) {
        ValueEnforcer.notNull((Object)string, (String)"HeaderName");
        String string3 = string.toLowerCase(Locale.US);
        this.m_aRWLock.writeLocked(() -> {
            ICommonsList iCommonsList = (ICommonsList)this.m_aHeaderNameToValueListMap.get((Object)string3);
            if (iCommonsList == null) {
                iCommonsList = new CommonsArrayList();
                this.m_aHeaderNameToValueListMap.put((Object)string3, (Object)iCommonsList);
                this.m_aHeaderNameList.add((Object)string3);
            }
            iCommonsList.add((Object)string2);
        });
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("HeaderNameToValueListMap", this.m_aHeaderNameToValueListMap).getToString();
    }
}

