/*
 * Decompiled with CFR 0.152.
 */
package com.helger.web.fileupload.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.request.RequestHelper;
import com.helger.web.fileupload.IRequestContext;
import java.io.IOException;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestContext
implements IRequestContext {
    private final HttpServletRequest m_aHttpRequest;

    public ServletRequestContext(@Nonnull HttpServletRequest httpServletRequest) {
        this.m_aHttpRequest = (HttpServletRequest)ValueEnforcer.notNull((Object)httpServletRequest, (String)"HttpRequest");
    }

    @Override
    @Nullable
    public String getCharacterEncoding() {
        return this.m_aHttpRequest.getCharacterEncoding();
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.m_aHttpRequest.getContentType();
    }

    @Override
    @CheckForSigned
    public long getContentLength() {
        return RequestHelper.getContentLength((HttpServletRequest)this.m_aHttpRequest);
    }

    @Nonnull
    public ServletInputStream getInputStream() throws IOException {
        return this.m_aHttpRequest.getInputStream();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("contentLength", this.getContentLength()).append("contentType", (Object)this.getContentType()).getToString();
    }
}

