/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.http.EHttpVersion;
import com.helger.servlet.ServletContextPathHolder;
import com.helger.servlet.ServletHelper;
import com.helger.servlet.ServletSettings;
import com.helger.servlet.StaticServerInfo;
import com.helger.servlet.http.CountingOnlyHttpServletResponse;
import com.helger.servlet.request.RequestLogger;
import com.helger.servlet.response.StatusAwareHttpResponseWrapper;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.impl.RequestWebScope;
import com.helger.web.scope.multipart.RequestWebScopeMultipart;
import com.helger.web.scope.request.RequestScopeInitializer;
import com.helger.xservlet.XServletSettings;
import com.helger.xservlet.exception.IXServletExceptionHandler;
import com.helger.xservlet.exception.XServletLoggingExceptionHandler;
import com.helger.xservlet.filter.IXServletHighLevelFilter;
import com.helger.xservlet.filter.IXServletLowLevelFilter;
import com.helger.xservlet.filter.XServletFilterConsistency;
import com.helger.xservlet.filter.XServletFilterSecurityHttpReferrerPolicy;
import com.helger.xservlet.filter.XServletFilterSecurityPoxy;
import com.helger.xservlet.filter.XServletFilterSecurityXFrameOptions;
import com.helger.xservlet.filter.XServletFilterTimer;
import com.helger.xservlet.filter.XServletFilterTrackRequest;
import com.helger.xservlet.forcedredirect.ForcedRedirectException;
import com.helger.xservlet.forcedredirect.ForcedRedirectManager;
import com.helger.xservlet.handler.IXServletBasicHandler;
import com.helger.xservlet.handler.IXServletHandler;
import com.helger.xservlet.handler.XServletHandlerOPTIONS;
import com.helger.xservlet.handler.XServletHandlerRegistry;
import com.helger.xservlet.handler.XServletHandlerTRACE;
import com.helger.xservlet.servletstatus.ServletStatusManager;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractXServlet
extends HttpServlet {
    public static final String REQUEST_ATTR_HANDLED_ASYNC = "$ph-request-is-async";
    public static final String REQUEST_ATTR_SCOPE_CREATED = "$ph-request-scope-created";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXServlet.class);
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsTotal = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.total"));
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsAccepted = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.accepted"));
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsHandled = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.handled"));
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsPRG = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.post-redirect-get"));
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsWithException = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.withexception"));
    private final IMutableStatisticsHandlerKeyedCounter m_aCounterRequestsPerVersionAccepted = StatisticsManager.getKeyedCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests-per-version.accepted"));
    private final IMutableStatisticsHandlerKeyedCounter m_aCounterRequestsPerVersionHandled = StatisticsManager.getKeyedCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests-per-version.handled"));
    private final IMutableStatisticsHandlerKeyedCounter m_aCounterRequestsPerMethodAccepted = StatisticsManager.getKeyedCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests-per-method.accepted"));
    private final IMutableStatisticsHandlerKeyedCounter m_aCounterRequestsPerMethodHandled = StatisticsManager.getKeyedCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests-per-method.handled"));
    private final IMutableStatisticsHandlerKeyedCounter m_aCounterHttpMethodUnhandled = StatisticsManager.getKeyedCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$method.unhandled"));
    private static final AtomicBoolean FIRST_REQUEST = new AtomicBoolean(true);
    private final XServletHandlerRegistry m_aHandlerRegistry = new XServletHandlerRegistry();
    private final ICommonsList<IXServletLowLevelFilter> m_aFilterLowLevelList = new CommonsArrayList();
    private final ICommonsList<IXServletHighLevelFilter> m_aFilterHighLevelList = new CommonsArrayList();
    private final CallbackList<IXServletExceptionHandler> m_aExceptionHandler = new CallbackList();
    private final XServletSettings m_aSettings = new XServletSettings();
    private final ServletStatusManager m_aStatusMgr;

    public AbstractXServlet() {
        this.m_aHandlerRegistry.registerHandler(EHttpMethod.TRACE, new XServletHandlerTRACE(), false);
        this.m_aHandlerRegistry.registerHandler(EHttpMethod.HEAD, (httpServletRequest, httpServletResponse, eHttpVersion, eHttpMethod, iRequestWebScope) -> {
            CountingOnlyHttpServletResponse countingOnlyHttpServletResponse = new CountingOnlyHttpServletResponse(httpServletResponse);
            this._invokeHandler(httpServletRequest, (HttpServletResponse)countingOnlyHttpServletResponse, eHttpVersion, EHttpMethod.GET, iRequestWebScope);
            countingOnlyHttpServletResponse.setContentLengthAutomatically();
        }, false);
        this.m_aHandlerRegistry.registerHandler(EHttpMethod.OPTIONS, new XServletHandlerOPTIONS(this.m_aHandlerRegistry::getAllowedHttpMethodsString), false);
        this.m_aExceptionHandler.add((ICallback)new XServletLoggingExceptionHandler());
        this.m_aStatusMgr = ServletStatusManager.getInstance();
        this.m_aStatusMgr.onServletCtor(((Object)((Object)this)).getClass());
    }

    @Nonnull
    @ReturnsMutableObject
    protected final XServletHandlerRegistry handlerRegistry() {
        return this.m_aHandlerRegistry;
    }

    @Nonnull
    @ReturnsMutableObject
    protected final ICommonsList<IXServletLowLevelFilter> filterLowLevelList() {
        return this.m_aFilterLowLevelList;
    }

    @Nonnull
    @ReturnsMutableObject
    protected final ICommonsList<IXServletHighLevelFilter> filterHighLevelList() {
        return this.m_aFilterHighLevelList;
    }

    @Nonnull
    @ReturnsMutableObject
    protected final CallbackList<IXServletExceptionHandler> exceptionHandler() {
        return this.m_aExceptionHandler;
    }

    public final XServletSettings settings() {
        return this.m_aSettings;
    }

    @Nonnull
    protected final ServletStatusManager getServletStatusMgr() {
        return this.m_aStatusMgr;
    }

    public final void log(String string) {
        super.log(string);
        LOGGER.info(string);
    }

    public final void log(String string, Throwable throwable) {
        super.log(string, throwable);
        LOGGER.error(string, throwable);
    }

    public final void init(@Nonnull ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.m_aStatusMgr.onServletInit(((Object)((Object)this)).getClass());
        try {
            CommonsHashMap commonsHashMap = new CommonsHashMap();
            Enumeration enumeration = servletConfig.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                commonsHashMap.put((Object)string, (Object)servletConfig.getInitParameter(string));
            }
            this.m_aHandlerRegistry.forEachHandlerThrowing(arg_0 -> AbstractXServlet.lambda$init$1((ICommonsMap)commonsHashMap, arg_0));
        }
        catch (ServletException servletException) {
            this.m_aStatusMgr.onServletInitFailed((Exception)((Object)servletException), ((Object)((Object)this)).getClass());
            throw servletException;
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void destroy() {
        this.m_aHandlerRegistry.forEachHandler(IXServletBasicHandler::onServletDestroy);
        this.m_aStatusMgr.onServletDestroy(((Object)((Object)this)).getClass());
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _invokeHandler(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull IRequestWebScope iRequestWebScope) throws ServletException, IOException {
        this.m_aCounterRequestsAccepted.increment();
        IXServletHandler iXServletHandler = this.m_aHandlerRegistry.getHandler(eHttpMethod);
        if (iXServletHandler == null) {
            this.m_aCounterHttpMethodUnhandled.increment(eHttpMethod.getName());
            httpServletResponse.setHeader("Allow", this.m_aHandlerRegistry.getAllowedHttpMethodsString());
            if (eHttpVersion.is10()) {
                httpServletResponse.sendError(400);
            } else {
                httpServletResponse.sendError(405);
            }
            return;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList(2 + this.m_aFilterHighLevelList.size());
        commonsArrayList.add((Object)new XServletFilterTimer(this));
        commonsArrayList.add((Object)new XServletFilterTrackRequest());
        commonsArrayList.addAll(this.m_aFilterHighLevelList);
        try {
            for (IXServletHighLevelFilter iXServletHighLevelFilter : commonsArrayList) {
                iXServletHighLevelFilter.beforeRequest(iRequestWebScope);
            }
            iXServletHandler.onRequest(httpServletRequest, httpServletResponse, eHttpVersion, eHttpMethod, iRequestWebScope);
            this.m_aCounterRequestsHandled.increment();
            this.m_aCounterRequestsPerVersionHandled.increment(eHttpVersion.getName());
            this.m_aCounterRequestsPerMethodHandled.increment(eHttpMethod.getName());
        }
        catch (ForcedRedirectException forcedRedirectException) {
            this.m_aCounterRequestsPRG.increment();
            ForcedRedirectManager.getInstance().createForcedRedirect(forcedRedirectException);
            if (eHttpVersion.is10()) {
                httpServletResponse.setStatus(302);
            } else {
                httpServletResponse.setStatus(303);
            }
            Object object = forcedRedirectException.getRedirectTargetURL().getAsStringWithEncodedParameters();
            if (ServletSettings.isEncodeURLs()) {
                object = httpServletResponse.encodeRedirectURL((String)object);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending redirect to '" + (String)object + "'");
            }
            httpServletResponse.addHeader("Location", (String)object);
        }
        catch (Exception exception) {
            this.m_aCounterRequestsWithException.increment();
            if (this.m_aExceptionHandler.forEachBreakable(iXServletExceptionHandler -> iXServletExceptionHandler.onException(iRequestWebScope, exception)).isContinue()) {
                throw exception;
            }
        }
        finally {
            for (Object object : commonsArrayList) {
                try {
                    object.afterRequest(iRequestWebScope);
                }
                catch (Exception exception) {
                    LOGGER.error("Exception in high-level filter afterRequest of " + String.valueOf(object) + " - caught and ignored", (Throwable)exception);
                }
            }
        }
    }

    @OverrideOnDemand
    protected void logInvalidRequestSetup(@Nonnull String string, @Nonnull HttpServletRequest httpServletRequest) {
        this.log(string + ":\n" + RequestLogger.getRequestDebugString((HttpServletRequest)httpServletRequest).toString());
    }

    protected final void service(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block25: {
            Object object2;
            this.m_aCounterRequestsTotal.increment();
            this.m_aStatusMgr.onServletInvocation(((Object)((Object)this)).getClass());
            String string = httpServletRequest.getProtocol();
            EHttpVersion eHttpVersion = EHttpVersion.getFromNameOrNull((String)string);
            if (eHttpVersion == null) {
                this.logInvalidRequestSetup("Request has unsupported HTTP version (" + string + ")!", httpServletRequest);
                httpServletResponse.sendError(505);
                return;
            }
            this.m_aCounterRequestsPerVersionAccepted.increment(eHttpVersion.getName());
            String string2 = ServletHelper.getRequestMethod((HttpServletRequest)httpServletRequest);
            EHttpMethod eHttpMethod = EHttpMethod.getFromNameOrNull((String)string2);
            if (eHttpMethod == null) {
                this.logInvalidRequestSetup("Request has unsupported HTTP method (" + string2 + ")!", httpServletRequest);
                httpServletResponse.sendError(501);
                return;
            }
            this.m_aCounterRequestsPerMethodAccepted.increment(eHttpMethod.getName());
            if (FIRST_REQUEST.getAndSet(false) && !StaticServerInfo.isSet()) {
                StaticServerInfo.init((String)httpServletRequest.getScheme(), (String)httpServletRequest.getServerName(), (int)httpServletRequest.getServerPort(), (String)ServletContextPathHolder.getContextPath());
            }
            StatusAwareHttpResponseWrapper statusAwareHttpResponseWrapper = StatusAwareHttpResponseWrapper.wrap((HttpServletResponse)httpServletResponse);
            CommonsArrayList commonsArrayList = new CommonsArrayList(4 + this.m_aFilterLowLevelList.size());
            commonsArrayList.add((Object)XServletFilterSecurityPoxy.INSTANCE);
            commonsArrayList.add((Object)XServletFilterConsistency.INSTANCE);
            if (this.m_aSettings.hasHttpReferrerPolicy()) {
                commonsArrayList.add((Object)new XServletFilterSecurityHttpReferrerPolicy(this.m_aSettings.getHttpReferrerPolicy()));
            }
            if (this.m_aSettings.hasXFrameOptions()) {
                commonsArrayList.add((Object)new XServletFilterSecurityXFrameOptions(this.m_aSettings.getXFrameOptionsType(), this.m_aSettings.getXFrameOptionsDomain()));
            }
            commonsArrayList.addAll(this.m_aFilterLowLevelList);
            boolean bl = true;
            for (Object object2 : commonsArrayList) {
                if (!object2.beforeRequest(httpServletRequest, (HttpServletResponse)statusAwareHttpResponseWrapper, eHttpVersion, eHttpMethod).isBreak()) continue;
                bl = false;
                return;
            }
            boolean bl2 = false;
            object2 = null;
            try {
                if (!bl) break block25;
                BiFunction<HttpServletRequest, HttpServletResponse, IRequestWebScope> biFunction = this.m_aSettings.isMultipartEnabled() ? RequestWebScopeMultipart::new : RequestWebScope::new;
                try (IXServletLowLevelFilter iXServletLowLevelFilter = RequestScopeInitializer.create((HttpServletRequest)httpServletRequest, (HttpServletResponse)statusAwareHttpResponseWrapper, (BiFunction)biFunction);){
                    IRequestWebScope iRequestWebScope = iXServletLowLevelFilter.getRequestScope();
                    iRequestWebScope.attrs().putIn((Object)REQUEST_ATTR_SCOPE_CREATED, iXServletLowLevelFilter.isNew());
                    this._invokeHandler(httpServletRequest, (HttpServletResponse)statusAwareHttpResponseWrapper, eHttpVersion, eHttpMethod, iRequestWebScope);
                    bl2 = iRequestWebScope.attrs().getAsBoolean((Object)REQUEST_ATTR_HANDLED_ASYNC, false);
                    if (bl2) {
                        iXServletLowLevelFilter.internalSetDontDestroyRequestScope();
                    }
                }
            }
            catch (Exception exception) {
                object2 = exception;
                this.log("Servlet exception propagated to the outside", exception);
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof ServletException) {
                    throw (ServletException)((Object)exception);
                }
                throw new ServletException("Wrapped " + exception.getClass().getName(), (Throwable)exception);
            }
            finally {
                for (IXServletLowLevelFilter iXServletLowLevelFilter : commonsArrayList) {
                    try {
                        iXServletLowLevelFilter.afterRequest(httpServletRequest, (HttpServletResponse)statusAwareHttpResponseWrapper, eHttpVersion, eHttpMethod, bl, (Throwable)object2, bl2);
                    }
                    catch (ServletException | IOException throwable) {
                        LOGGER.error("Exception in low-level filter afterRequest of " + String.valueOf(iXServletLowLevelFilter) + " - re-thrown", throwable);
                    }
                }
            }
        }
    }

    public final void service(@Nonnull ServletRequest servletRequest, @Nonnull ServletResponse servletResponse) throws ServletException, IOException {
        super.service(servletRequest, servletResponse);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("HandlerRegistry", (Object)this.m_aHandlerRegistry).append("FilterList", this.m_aFilterLowLevelList).append("ExceptionHandler", this.m_aExceptionHandler).append("Settings", (Object)this.m_aSettings).getToString();
    }

    private static /* synthetic */ void lambda$init$1(ICommonsMap iCommonsMap, IXServletHandler iXServletHandler) throws ServletException {
        iXServletHandler.onServletInit((ICommonsMap<String, String>)iCommonsMap);
    }
}

