
package com.helger.xsds.xades132;

import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;


/**
 * <p>Java class for OCSPIdentifierType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="OCSPIdentifierType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="ResponderID" type="{http://uri.etsi.org/01903/v1.3.2#}ResponderIDType"/&gt;
 *         &lt;element name="ProducedAt" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="URI" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-offset-dt-extension</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OCSPIdentifierType", propOrder = {
    "responderID",
    "producedAt"
})
@CodingStyleguideUnaware
public class OCSPIdentifierType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ResponderID", required = true)
    private ResponderIDType responderID;
    @XmlElement(name = "ProducedAt", required = true, type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime producedAt;
    @XmlAttribute(name = "URI")
    @XmlSchemaType(name = "anyURI")
    private String uri;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public OCSPIdentifierType() {
    }

    /**
     * Gets the value of the responderID property.
     * 
     * @return
     *     possible object is
     *     {@link ResponderIDType }
     *     
     */
    @Nullable
    public ResponderIDType getResponderID() {
        return responderID;
    }

    /**
     * Sets the value of the responderID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResponderIDType }
     *     
     */
    public void setResponderID(
        @Nullable
        ResponderIDType value) {
        this.responderID = value;
    }

    /**
     * Gets the value of the producedAt property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getProducedAt() {
        return producedAt;
    }

    /**
     * Sets the value of the producedAt property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProducedAt(
        @Nullable
        XMLOffsetDateTime value) {
        this.producedAt = value;
    }

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getURI() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setURI(
        @Nullable
        String value) {
        this.uri = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final OCSPIdentifierType rhs = ((OCSPIdentifierType) o);
        if (!EqualsHelper.equals(producedAt, rhs.producedAt)) {
            return false;
        }
        if (!EqualsHelper.equals(responderID, rhs.responderID)) {
            return false;
        }
        if (!EqualsHelper.equals(uri, rhs.uri)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(producedAt).append(responderID).append(uri).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("producedAt", producedAt).append("responderID", responderID).append("uri", uri).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        OCSPIdentifierType ret) {
        ret.producedAt = producedAt;
        ret.responderID = ((responderID == null)?null:responderID.clone());
        ret.uri = uri;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public OCSPIdentifierType clone() {
        OCSPIdentifierType ret = new OCSPIdentifierType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of producedAt. May be <code>null</code>.
     */
    @Nullable
    public LocalDateTime getProducedAtLocal() {
        return (producedAt == null)?null:producedAt.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be <code>null</code>.
     */
    public void setProducedAt(
        @Nullable
        final LocalDateTime aValue) {
        producedAt = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
