
package com.helger.xsds.xades132;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;


/**
 * <p>Java class for SignedSignaturePropertiesType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SignedSignaturePropertiesType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SigningTime" minOccurs="0"/&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SigningCertificate" minOccurs="0"/&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SigningCertificateV2" minOccurs="0"/&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SignaturePolicyIdentifier" minOccurs="0"/&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SignatureProductionPlace" minOccurs="0"/&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SignatureProductionPlaceV2" minOccurs="0"/&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SignerRole" minOccurs="0"/&gt;
 *         &lt;element ref="{http://uri.etsi.org/01903/v1.3.2#}SignerRoleV2" minOccurs="0"/&gt;
 *         &lt;any namespace='##other' maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="Id" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-offset-dt-extension</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignedSignaturePropertiesType", propOrder = {
    "signingTime",
    "signingCertificate",
    "signingCertificateV2",
    "signaturePolicyIdentifier",
    "signatureProductionPlace",
    "signatureProductionPlaceV2",
    "signerRole",
    "signerRoleV2",
    "any"
})
@CodingStyleguideUnaware
public class SignedSignaturePropertiesType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SigningTime", type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime signingTime;
    @XmlElement(name = "SigningCertificate")
    private CertIDListType signingCertificate;
    @XmlElement(name = "SigningCertificateV2")
    private CertIDListV2Type signingCertificateV2;
    @XmlElement(name = "SignaturePolicyIdentifier")
    private SignaturePolicyIdentifierType signaturePolicyIdentifier;
    @XmlElement(name = "SignatureProductionPlace")
    private SignatureProductionPlaceType signatureProductionPlace;
    @XmlElement(name = "SignatureProductionPlaceV2")
    private SignatureProductionPlaceV2Type signatureProductionPlaceV2;
    @XmlElement(name = "SignerRole")
    private SignerRoleType signerRole;
    @XmlElement(name = "SignerRoleV2")
    private SignerRoleV2Type signerRoleV2;
    @XmlAnyElement(lax = true)
    private List<Object> any;
    @XmlAttribute(name = "Id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    private String id;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public SignedSignaturePropertiesType() {
    }

    /**
     * Gets the value of the signingTime property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getSigningTime() {
        return signingTime;
    }

    /**
     * Sets the value of the signingTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSigningTime(
        @Nullable
        XMLOffsetDateTime value) {
        this.signingTime = value;
    }

    /**
     * Gets the value of the signingCertificate property.
     * 
     * @return
     *     possible object is
     *     {@link CertIDListType }
     *     
     */
    @Nullable
    public CertIDListType getSigningCertificate() {
        return signingCertificate;
    }

    /**
     * Sets the value of the signingCertificate property.
     * 
     * @param value
     *     allowed object is
     *     {@link CertIDListType }
     *     
     */
    public void setSigningCertificate(
        @Nullable
        CertIDListType value) {
        this.signingCertificate = value;
    }

    /**
     * Gets the value of the signingCertificateV2 property.
     * 
     * @return
     *     possible object is
     *     {@link CertIDListV2Type }
     *     
     */
    @Nullable
    public CertIDListV2Type getSigningCertificateV2() {
        return signingCertificateV2;
    }

    /**
     * Sets the value of the signingCertificateV2 property.
     * 
     * @param value
     *     allowed object is
     *     {@link CertIDListV2Type }
     *     
     */
    public void setSigningCertificateV2(
        @Nullable
        CertIDListV2Type value) {
        this.signingCertificateV2 = value;
    }

    /**
     * Gets the value of the signaturePolicyIdentifier property.
     * 
     * @return
     *     possible object is
     *     {@link SignaturePolicyIdentifierType }
     *     
     */
    @Nullable
    public SignaturePolicyIdentifierType getSignaturePolicyIdentifier() {
        return signaturePolicyIdentifier;
    }

    /**
     * Sets the value of the signaturePolicyIdentifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignaturePolicyIdentifierType }
     *     
     */
    public void setSignaturePolicyIdentifier(
        @Nullable
        SignaturePolicyIdentifierType value) {
        this.signaturePolicyIdentifier = value;
    }

    /**
     * Gets the value of the signatureProductionPlace property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureProductionPlaceType }
     *     
     */
    @Nullable
    public SignatureProductionPlaceType getSignatureProductionPlace() {
        return signatureProductionPlace;
    }

    /**
     * Sets the value of the signatureProductionPlace property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureProductionPlaceType }
     *     
     */
    public void setSignatureProductionPlace(
        @Nullable
        SignatureProductionPlaceType value) {
        this.signatureProductionPlace = value;
    }

    /**
     * Gets the value of the signatureProductionPlaceV2 property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureProductionPlaceV2Type }
     *     
     */
    @Nullable
    public SignatureProductionPlaceV2Type getSignatureProductionPlaceV2() {
        return signatureProductionPlaceV2;
    }

    /**
     * Sets the value of the signatureProductionPlaceV2 property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureProductionPlaceV2Type }
     *     
     */
    public void setSignatureProductionPlaceV2(
        @Nullable
        SignatureProductionPlaceV2Type value) {
        this.signatureProductionPlaceV2 = value;
    }

    /**
     * Gets the value of the signerRole property.
     * 
     * @return
     *     possible object is
     *     {@link SignerRoleType }
     *     
     */
    @Nullable
    public SignerRoleType getSignerRole() {
        return signerRole;
    }

    /**
     * Sets the value of the signerRole property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignerRoleType }
     *     
     */
    public void setSignerRole(
        @Nullable
        SignerRoleType value) {
        this.signerRole = value;
    }

    /**
     * Gets the value of the signerRoleV2 property.
     * 
     * @return
     *     possible object is
     *     {@link SignerRoleV2Type }
     *     
     */
    @Nullable
    public SignerRoleV2Type getSignerRoleV2() {
        return signerRoleV2;
    }

    /**
     * Sets the value of the signerRoleV2 property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignerRoleV2Type }
     *     
     */
    public void setSignerRoleV2(
        @Nullable
        SignerRoleV2Type value) {
        this.signerRoleV2 = value;
    }

    /**
     * Gets the value of the any property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the any property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAny().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<Object> getAny() {
        if (any == null) {
            any = new ArrayList<Object>();
        }
        return this.any;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(
        @Nullable
        String value) {
        this.id = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SignedSignaturePropertiesType rhs = ((SignedSignaturePropertiesType) o);
        if (!EqualsHelper.equalsCollection(any, rhs.any)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(signaturePolicyIdentifier, rhs.signaturePolicyIdentifier)) {
            return false;
        }
        if (!EqualsHelper.equals(signatureProductionPlace, rhs.signatureProductionPlace)) {
            return false;
        }
        if (!EqualsHelper.equals(signatureProductionPlaceV2, rhs.signatureProductionPlaceV2)) {
            return false;
        }
        if (!EqualsHelper.equals(signerRole, rhs.signerRole)) {
            return false;
        }
        if (!EqualsHelper.equals(signerRoleV2, rhs.signerRoleV2)) {
            return false;
        }
        if (!EqualsHelper.equals(signingCertificate, rhs.signingCertificate)) {
            return false;
        }
        if (!EqualsHelper.equals(signingCertificateV2, rhs.signingCertificateV2)) {
            return false;
        }
        if (!EqualsHelper.equals(signingTime, rhs.signingTime)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(any).append(id).append(signaturePolicyIdentifier).append(signatureProductionPlace).append(signatureProductionPlaceV2).append(signerRole).append(signerRoleV2).append(signingCertificate).append(signingCertificateV2).append(signingTime).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("any", any).append("id", id).append("signaturePolicyIdentifier", signaturePolicyIdentifier).append("signatureProductionPlace", signatureProductionPlace).append("signatureProductionPlaceV2", signatureProductionPlaceV2).append("signerRole", signerRole).append("signerRoleV2", signerRoleV2).append("signingCertificate", signingCertificate).append("signingCertificateV2", signingCertificateV2).append("signingTime", signingTime).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAny(
        @Nullable
        final List<Object> aList) {
        any = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAnyEntries() {
        return (!getAny().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAnyEntries() {
        return getAny().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAnyCount() {
        return getAny().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public Object getAnyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAny().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAny(
        @Nonnull
        final Object elem) {
        getAny().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SignedSignaturePropertiesType ret) {
        if (any == null) {
            ret.any = null;
        } else {
            List<Object> retAny = new ArrayList<Object>();
            for (Object aItem: getAny()) {
                retAny.add(aItem);
            }
            ret.any = retAny;
        }
        ret.id = id;
        ret.signaturePolicyIdentifier = ((signaturePolicyIdentifier == null)?null:signaturePolicyIdentifier.clone());
        ret.signatureProductionPlace = ((signatureProductionPlace == null)?null:signatureProductionPlace.clone());
        ret.signatureProductionPlaceV2 = ((signatureProductionPlaceV2 == null)?null:signatureProductionPlaceV2 .clone());
        ret.signerRole = ((signerRole == null)?null:signerRole.clone());
        ret.signerRoleV2 = ((signerRoleV2 == null)?null:signerRoleV2 .clone());
        ret.signingCertificate = ((signingCertificate == null)?null:signingCertificate.clone());
        ret.signingCertificateV2 = ((signingCertificateV2 == null)?null:signingCertificateV2 .clone());
        ret.signingTime = signingTime;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SignedSignaturePropertiesType clone() {
        SignedSignaturePropertiesType ret = new SignedSignaturePropertiesType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of signingTime. May be <code>null</code>.
     */
    @Nullable
    public LocalDateTime getSigningTimeLocal() {
        return (signingTime == null)?null:signingTime.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be <code>null</code>.
     */
    public void setSigningTime(
        @Nullable
        final LocalDateTime aValue) {
        signingTime = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
