
package com.helger.xsds.xades141;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.xades132.ObjectIdentifierType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for SignaturePolicyStoreType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SignaturePolicyStoreType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{http://uri.etsi.org/01903/v1.4.1#}SPDocSpecification"/>
 *         <choice>
 *           <element name="SignaturePolicyDocument" type="{http://www.w3.org/2001/XMLSchema}base64Binary"/>
 *           <element name="SigPolDocLocalURI" type="{http://www.w3.org/2001/XMLSchema}anyURI"/>
 *         </choice>
 *       </sequence>
 *       <attribute name="Id" type="{http://www.w3.org/2001/XMLSchema}ID" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignaturePolicyStoreType", propOrder = {
    "spDocSpecification",
    "signaturePolicyDocument",
    "sigPolDocLocalURI"
})
@CodingStyleguideUnaware
public class SignaturePolicyStoreType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SPDocSpecification", required = true)
    private ObjectIdentifierType spDocSpecification;
    @XmlElement(name = "SignaturePolicyDocument")
    private byte[] signaturePolicyDocument;
    @XmlElement(name = "SigPolDocLocalURI")
    @XmlSchemaType(name = "anyURI")
    private String sigPolDocLocalURI;
    @XmlAttribute(name = "Id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    private String id;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SignaturePolicyStoreType() {
    }

    /**
     * Gets the value of the spDocSpecification property.
     * 
     * @return
     *     possible object is
     *     {@link ObjectIdentifierType }
     *     
     */
    @Nullable
    public ObjectIdentifierType getSPDocSpecification() {
        return spDocSpecification;
    }

    /**
     * Sets the value of the spDocSpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link ObjectIdentifierType }
     *     
     */
    public void setSPDocSpecification(
        @Nullable
        ObjectIdentifierType value) {
        this.spDocSpecification = value;
    }

    /**
     * Gets the value of the signaturePolicyDocument property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    @Nullable
    public byte[] getSignaturePolicyDocument() {
        return signaturePolicyDocument;
    }

    /**
     * Sets the value of the signaturePolicyDocument property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setSignaturePolicyDocument(
        @Nullable
        byte[] value) {
        this.signaturePolicyDocument = value;
    }

    /**
     * Gets the value of the sigPolDocLocalURI property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSigPolDocLocalURI() {
        return sigPolDocLocalURI;
    }

    /**
     * Sets the value of the sigPolDocLocalURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSigPolDocLocalURI(
        @Nullable
        String value) {
        this.sigPolDocLocalURI = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(
        @Nullable
        String value) {
        this.id = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SignaturePolicyStoreType rhs = ((SignaturePolicyStoreType) o);
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(sigPolDocLocalURI, rhs.sigPolDocLocalURI)) {
            return false;
        }
        if (!EqualsHelper.equals(signaturePolicyDocument, rhs.signaturePolicyDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(spDocSpecification, rhs.spDocSpecification)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(id).append(sigPolDocLocalURI).append(signaturePolicyDocument).append(spDocSpecification).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("id", id).append("sigPolDocLocalURI", sigPolDocLocalURI).append("signaturePolicyDocument", signaturePolicyDocument).append("spDocSpecification", spDocSpecification).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SignaturePolicyStoreType ret) {
        ret.id = id;
        ret.sigPolDocLocalURI = sigPolDocLocalURI;
        ret.signaturePolicyDocument = ArrayHelper.getCopy(signaturePolicyDocument);
        ret.spDocSpecification = ((spDocSpecification == null)?null:spDocSpecification.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SignaturePolicyStoreType clone() {
        SignaturePolicyStoreType ret = new SignaturePolicyStoreType();
        cloneTo(ret);
        return ret;
    }

}
