/*
 * Decompiled with CFR 0.152.
 */
package com.heliorm.sql.mysql;

import com.heliorm.Database;
import com.heliorm.Field;
import com.heliorm.OrmException;
import com.heliorm.Table;
import com.heliorm.sql.OrmSqlException;
import com.heliorm.sql.SqlDriver;
import com.heliorm.sql.TableGenerator;
import com.heliorm.sql.mysql.MysqlDialectGenerator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;

public final class MySqlDriver
extends SqlDriver {
    public MySqlDriver(Map<Database, Database> aliases) {
        super(aliases);
    }

    public MySqlDriver() {
        super(Collections.emptyMap());
    }

    protected String fullTableName(Table table) throws OrmException {
        return String.format("%s.%s", this.databaseName(table), this.tableName(table));
    }

    protected String fullFieldName(Table table, Field field) throws OrmException {
        return String.format("%s.`%s`", this.fullTableName(table), field.getSqlName());
    }

    protected String fieldName(Table table, Field field) {
        return String.format("`%s`", field.getSqlName());
    }

    protected String virtualFieldName(String name) {
        return String.format("`%s`", name);
    }

    protected String virtualValue(String name) {
        return String.format("'%s'", name);
    }

    protected TableGenerator getTableGenerator() {
        return new MysqlDialectGenerator();
    }

    protected String castNull(Field field) {
        return "NULL";
    }

    protected Object getKeyValueFromResultSet(ResultSet rs, Field field) throws OrmException {
        try {
            int idx = 1;
            switch (field.getFieldType()) {
                case LONG: {
                    return rs.getLong(idx);
                }
                case INTEGER: {
                    return rs.getInt(idx);
                }
                case STRING: {
                    return rs.getString(idx);
                }
                case SHORT: 
                case BYTE: 
                case DOUBLE: 
                case FLOAT: 
                case BOOLEAN: 
                case ENUM: 
                case DATE: 
                case INSTANT: {
                    throw new OrmException(String.format("Field type '%s' is not a supported primary key type", field.getFieldType()));
                }
            }
            throw new OrmException(String.format("Field type '%s' is unsupported. BUG!", field.getFieldType()));
        }
        catch (SQLException ex) {
            throw new OrmSqlException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String fieldType(Table<?> table, Field field) throws OrmException {
        switch (field.getFieldType()) {
            case BOOLEAN: {
                return "TINYINT(1)";
            }
            case BYTE: {
                return "TINYINT";
            }
            case SHORT: {
                return "SMALLINT";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case LONG: {
                return "BIGINT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case FLOAT: {
                return "REAL";
            }
            case ENUM: {
                return String.format("ENUM(%s)", this.getEnumValues(field));
            }
            case STRING: {
                int length = 255;
                if (field.isPrimaryKey()) {
                    length = 36;
                }
                if (field.getLength().isPresent()) {
                    length = (Integer)field.getLength().get();
                }
                return String.format("VARCHAR(%d)", length);
            }
            case DATE: {
                return "DATE";
            }
            case INSTANT: {
                return "DATETIME";
            }
        }
        throw new OrmSqlException(String.format("Unkown field type '%s'. BUG!", field.getFieldType()));
    }

    private String getEnumValues(Field<?, ?> field) {
        StringJoiner sql = new StringJoiner(",");
        Class javaType = field.getJavaType();
        for (Object v : javaType.getEnumConstants()) {
            sql.add(String.format("'%s'", ((Enum)v).name()));
        }
        return sql.toString();
    }

    protected boolean supportsUnionAll() {
        return true;
    }

    protected boolean supportsTransactions() {
        return true;
    }
}

