/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.atlas;

import com.mongodb.atlas.model.Cluster;
import com.mongodb.atlas.model.ClustersResult;
import com.mongodb.atlas.model.DatabasesResult;
import com.mongodb.atlas.model.LogCollectionJob;
import com.mongodb.atlas.model.LogCollectionJobRequest;
import com.mongodb.atlas.model.MeasurementsResult;
import com.mongodb.atlas.model.ProcessesResult;
import com.mongodb.atlas.model.ProjectsResult;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface AtlasApi {
    @GET(value="groups")
    public Call<ProjectsResult> getProjects();

    @GET(value="groups/{groupId}/clusters")
    public Call<ClustersResult> getClusters(@Path(value="groupId") String var1);

    @GET(value="groups/{groupId}/clusters/{clusterName}")
    public Call<Cluster> getCluster(@Path(value="groupId") String var1, @Path(value="clusterName") String var2);

    @GET(value="groups/{groupId}/processes")
    public Call<ProcessesResult> getProcesses(@Path(value="groupId") String var1);

    @GET(value="groups/{groupId}/processes")
    public Call<ProcessesResult> getProcesses(@Path(value="groupId") String var1, @Query(value="pageNum") Integer var2);

    @GET(value="groups/{groupId}/processes/{hostId}/measurements?granularity=PT1M&period=P2D&&m=CACHE_BYTES_READ_INTO&m=CACHE_BYTES_WRITTEN_FROM")
    public Call<MeasurementsResult> getMeasurements(@Path(value="groupId") String var1, @Path(value="hostId") String var2);

    @GET(value="groups/{groupId}/processes/{hostId}/disks/xbdb/measurements?granularity=PT1M&period=P2D&m=DISK_PARTITION_IOPS_TOTAL")
    public Call<MeasurementsResult> getDiskMeasurements(@Path(value="groupId") String var1, @Path(value="hostId") String var2);

    @GET(value="groups/{groupId}/processes/{hostId}/databases")
    public Call<DatabasesResult> getDatabases(@Path(value="groupId") String var1, @Path(value="hostId") String var2);

    @GET(value="groups/{groupId}/processes/{hostId}/databases/{databaseName}/measurements?granularity=PT24H&period=PT24H")
    public Call<MeasurementsResult> getDatabaseMeasurements(@Path(value="groupId") String var1, @Path(value="hostId") String var2, @Path(value="databaseName") String var3);

    @Headers(value={"Content-Type: application/json"})
    @POST(value="groups/{groupId}/logCollectionJobs")
    public Call<LogCollectionJob> startLogCollectionJob(@Path(value="groupId") String var1, @Body LogCollectionJobRequest var2);
}

