/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.atlas;

import com.mongodb.okhttp.AuthenticationCacheInterceptor;
import com.mongodb.okhttp.CachingAuthenticatorDecorator;
import com.mongodb.okhttp.digest.CachingAuthenticator;
import com.mongodb.okhttp.digest.Credentials;
import com.mongodb.okhttp.digest.DigestAuthenticator;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class AtlasServiceGenerator {
    private static final String BASE_URL = "https://cloud.mongodb.com/api/atlas/v1.0/";
    private static Retrofit.Builder builder = new Retrofit.Builder().baseUrl("https://cloud.mongodb.com/api/atlas/v1.0/").addConverterFactory((Converter.Factory)GsonConverterFactory.create());
    private static Retrofit retrofit = builder.build();
    private static OkHttpClient client;
    private static HttpLoggingInterceptor logging;

    static {
        logging = new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BASIC);
    }

    public static <S> S createService(Class<S> serviceClass, String username, String apiKey) {
        DigestAuthenticator authenticator = new DigestAuthenticator(new Credentials(username, apiKey));
        ConcurrentHashMap<String, CachingAuthenticator> authCache = new ConcurrentHashMap<String, CachingAuthenticator>();
        client = new OkHttpClient.Builder().authenticator((Authenticator)new CachingAuthenticatorDecorator(authenticator, authCache)).addInterceptor((Interceptor)new AuthenticationCacheInterceptor(authCache)).addInterceptor((Interceptor)logging).build();
        builder.client(client);
        retrofit = builder.build();
        return (S)retrofit.create(serviceClass);
    }

    public static void shutdown() {
        client.connectionPool().evictAll();
    }
}

