/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.atlas;

import com.mongodb.ConnectionString;
import com.mongodb.atlas.AtlasApi;
import com.mongodb.atlas.AtlasServiceGenerator;
import com.mongodb.atlas.model.AWSInstanceSize;
import com.mongodb.atlas.model.Cluster;
import com.mongodb.atlas.model.ClustersResult;
import com.mongodb.atlas.model.Database;
import com.mongodb.atlas.model.DatabasesResult;
import com.mongodb.atlas.model.DatabasesStats;
import com.mongodb.atlas.model.LogCollectionJob;
import com.mongodb.atlas.model.LogCollectionJobRequest;
import com.mongodb.atlas.model.Measurement;
import com.mongodb.atlas.model.MeasurementDataPoint;
import com.mongodb.atlas.model.MeasurementsResult;
import com.mongodb.atlas.model.Process;
import com.mongodb.atlas.model.ProcessesResult;
import com.mongodb.atlas.model.Project;
import com.mongodb.atlas.model.ProjectsResult;
import com.mongodb.client.MongoClient;
import com.mongodb.util.ByteSizesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class AtlasUtil {
    private static final String[] FTDC_LOGS = new String[]{"FTDC"};
    private static Logger logger = LoggerFactory.getLogger(AtlasUtil.class);
    private AtlasApi service;
    private CodecRegistry pojoCodecRegistry;
    private MongoClient mongoClient;
    private String mongoUri;
    private DescriptiveStatistics diskStats = new DescriptiveStatistics();

    public AtlasUtil(String username, String apiKey, String mongoUri) {
        this.service = AtlasServiceGenerator.createService(AtlasApi.class, username, apiKey);
        this.mongoUri = mongoUri;
        this.init();
    }

    private void init() {
        this.pojoCodecRegistry = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()});
        ConnectionString source = new ConnectionString(this.mongoUri);
    }

    public List<Project> getProjects() throws IOException {
        Call<ProjectsResult> callSync = this.service.getProjects();
        Response response = callSync.execute();
        ProjectsResult projects = (ProjectsResult)response.body();
        return projects.getProjects();
    }

    public List<Cluster> getClusters(String groupId) throws IOException {
        Call<ClustersResult> callSync = this.service.getClusters(groupId);
        Response response = callSync.execute();
        ClustersResult clusters = (ClustersResult)response.body();
        return clusters.getClusters();
    }

    public Cluster getCluster(String groupId, String clusterName) throws IOException {
        Call<Cluster> callSync = this.service.getCluster(groupId, clusterName);
        Response response = callSync.execute();
        Cluster cluster = (Cluster)response.body();
        return cluster;
    }

    public List<Process> getProcesses(String groupId) throws IOException {
        List<Process> procList;
        Call<ProcessesResult> callSync = this.service.getProcesses(groupId);
        Response response = callSync.execute();
        ProcessesResult procs = (ProcessesResult)response.body();
        int total = procs.getTotalCount();
        if (total > (procList = procs.getProcesses()).size()) {
            ArrayList<Process> result = new ArrayList<Process>();
            result.addAll(procList);
            int processed = procList.size();
            int pageNum = 2;
            while (processed < total) {
                callSync = this.service.getProcesses(groupId, pageNum++);
                response = callSync.execute();
                procs = (ProcessesResult)response.body();
                procList = procs.getProcesses();
                processed += procList.size();
                result.addAll(procList);
            }
            return result;
        }
        return procList;
    }

    public void getLogs(String groupId, String hostId, long startDate) throws IOException {
        LogCollectionJobRequest req = new LogCollectionJobRequest();
        req.setResourceType("REPLICASET");
        req.setResourceName(hostId);
        req.setLogTypes(FTDC_LOGS);
        Call<LogCollectionJob> logCall = this.service.startLogCollectionJob(groupId, req);
        Response logResponse = logCall.execute();
        LogCollectionJob job = (LogCollectionJob)logResponse.body();
    }

    public void getMeasurements(String groupId, String hostId) throws IOException {
        Call<MeasurementsResult> callSync = this.service.getMeasurements(groupId, hostId);
        Response response = callSync.execute();
        MeasurementsResult result = (MeasurementsResult)response.body();
        if (result != null) {
            List<Measurement> measurements = result.getMeasurements();
            for (Measurement m : measurements) {
                for (MeasurementDataPoint d : m.getDataPoints()) {
                    if (d.getValue() == null) continue;
                    System.out.println(d);
                }
            }
        }
    }

    public DescriptiveStatistics getDiskStats(String groupId, String processId) throws IOException {
        this.diskStats.clear();
        Call<MeasurementsResult> callSync = this.service.getDiskMeasurements(groupId, processId);
        Response response = callSync.execute();
        MeasurementsResult result = (MeasurementsResult)response.body();
        if (result != null) {
            List<Measurement> measurements = result.getMeasurements();
            for (Measurement m : measurements) {
                for (MeasurementDataPoint d : m.getDataPoints()) {
                    if (d.getValue() == null) continue;
                    this.diskStats.addValue(d.getValue().doubleValue());
                }
            }
        }
        return this.diskStats;
    }

    public List<String> getDatabaseNames(String groupId, String processId) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        Call<DatabasesResult> callSync = this.service.getDatabases(groupId, processId);
        Response response = callSync.execute();
        DatabasesResult result = (DatabasesResult)response.body();
        if (result != null) {
            for (Database db : result.getDatabases()) {
                if (db.getDatabaseName().equals("local")) continue;
                results.add(db.getDatabaseName());
            }
        }
        return results;
    }

    private double getDbMeasurement(Measurement m) {
        double total = 0.0;
        for (MeasurementDataPoint d : m.getDataPoints()) {
            if (d.getValue() != null) {
                if (!m.getUnits().equals("BYTES")) {
                    throw new RuntimeException("Unexpected unit: " + m.getUnits());
                }
                double gb = ByteSizesUtil.bytesToGigabytes(d.getValue());
                total += gb;
                continue;
            }
            throw new RuntimeException("null dataPoint, WTF!?");
        }
        return total;
    }

    public DatabasesStats getDatabasesStats(String groupId, String hostId) throws IOException {
        DatabasesStats stats = new DatabasesStats();
        List<String> databases = this.getDatabaseNames(groupId, hostId);
        for (String dbName : databases) {
            Call<MeasurementsResult> callSync = this.service.getDatabaseMeasurements(groupId, hostId, dbName);
            Response response = callSync.execute();
            MeasurementsResult result = (MeasurementsResult)response.body();
            if (result == null) continue;
            List<Measurement> measurements = result.getMeasurements();
            for (Measurement m : measurements) {
                if (m.getName().equals("DATABASE_DATA_SIZE")) {
                    stats.addDataSize(this.getDbMeasurement(m));
                    continue;
                }
                if (!m.getName().equals("DATABASE_INDEX_SIZE")) continue;
                stats.addIndexSize(this.getDbMeasurement(m));
            }
        }
        return stats;
    }

    public void getMeasurements(String groupId) throws IOException {
        List<Process> procs = this.getProcesses(groupId);
        System.out.println(String.format("%-30s %10s %10s %-10s %-12s %-12s %-12s %-12s %-12s", "cluster", "itype", "RAM GB", "IOPS", "dataSizeGB", "indexSizeGB", "max IOPS", "avg IOPS", "95p IOPS"));
        TreeMap<String, String> results = new TreeMap<String, String>();
        for (Process process : procs) {
            if (!process.getTypeName().equals("REPLICA_PRIMARY")) continue;
            DatabasesStats stats = this.getDatabasesStats(groupId, process.getId());
            String clusterName = StringUtils.substringBefore((String)process.getReplicaSetName(), (String)"-shard-");
            DescriptiveStatistics diskStats = this.getDiskStats(groupId, process.getId());
            Cluster cluster = this.getCluster(groupId, clusterName);
            String instanceName = cluster.getProviderSettings().getInstanceSizeName();
            AWSInstanceSize aws = AWSInstanceSize.findByName(instanceName).get();
            String display = String.format("%-30s %10s %-8.1f %-10d %-12.1f %-12.1f %-12.1f %-12.1f %-12.1f", cluster.getName(), instanceName, aws.getRamSizeGB(), cluster.getProviderSettings().getDiskIOPS(), stats.getTotalDataSize(), stats.getTotalIndexSize(), diskStats.getMax(), diskStats.getMean(), diskStats.getPercentile(95.0));
            results.put(cluster.getName(), display);
        }
        for (Map.Entry entry : results.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            System.out.println(value);
        }
    }
}

