/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.atlas;

import com.mongodb.atlas.AtlasServiceGenerator;
import com.mongodb.atlas.AtlasUtil;
import com.mongodb.atlas.model.Cluster;
import com.mongodb.atlas.model.Project;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class AtlasUtilApp {
    private static Options options;
    private static final String COLL_COUNTS = "compareCounts";
    private static final String CHUNK_COUNTS = "chunkCounts";
    private static final String COMPARE_IDS = "compareIds";

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"API user");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"user");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)"API key");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"key");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"k"));
        OptionBuilder.withArgName((String)"Group Id");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"groupId");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"g"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                AtlasUtilApp.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            AtlasUtilApp.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            AtlasUtilApp.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("statsUtil", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = AtlasUtilApp.initializeAndParseCommandLineOptions(args);
        AtlasUtil util = new AtlasUtil(line.getOptionValue("u"), line.getOptionValue("k"), "mongodb://localhost:27017/atlasMetrics");
        String group = line.getOptionValue("g");
        if (group != null) {
            ZonedDateTime d = LocalDate.now().atStartOfDay(ZoneId.of("UTC")).with(TemporalAdjusters.previous(DayOfWeek.MONDAY));
            Instant i = d.toInstant();
            long startDate = i.toEpochMilli();
            List<Cluster> clusters = util.getClusters(group);
            for (Cluster c : clusters) {
                System.out.println(c);
            }
            util.getLogs(group, "atlas-7d8hfg-shard-15", startDate);
        } else {
            List<Project> projects = util.getProjects();
            for (Project p : projects) {
                System.out.println(p);
                List<Cluster> clusters = util.getClusters(p.getId());
                for (Cluster c : clusters) {
                    System.out.println(c);
                }
            }
        }
        AtlasServiceGenerator.shutdown();
    }
}

