/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.atlas.model;

import java.util.Arrays;
import java.util.Optional;

public enum AWSInstanceSize {
    M10(new Builder().printableName("M10").ramSizeGB(2.0).numCPUs(0.2).numDataDisks(1).maxEBSStandardIOPS(3000).defaultDataDiskSizeGB(10).wiredTigerEngineConfigString("cache_size=512MB").maxIncomingConnections(350).electionTimeoutMillis(10000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M20(new Builder().printableName("M20").ramSizeGB(4.0).numCPUs(0.4).numDataDisks(1).maxEBSStandardIOPS(3000).defaultDataDiskSizeGB(20).wiredTigerEngineConfigString("cache_size=1024MB").maxIncomingConnections(700).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M30(new Builder().printableName("M30").ramSizeGB(8.0).numCPUs(2.0).numDataDisks(1).maxEBSStandardIOPS(3600).maxEBSIOPS(3600).defaultDataDiskSizeGB(40).wiredTigerEngineConfigString("cache_size=2048MB").maxIncomingConnections(2000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M40(new Builder().printableName("M40").ramSizeGB(16.0).numCPUs(4.0).numDataDisks(1).maxEBSStandardIOPS(6000).maxEBSIOPS(6000).defaultDataDiskSizeGB(80).wiredTigerEngineConfigString("cache_size=8192MB").maxIncomingConnections(4000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M50(new Builder().printableName("M50").ramSizeGB(32.0).numCPUs(8.0).numDataDisks(1).maxEBSStandardIOPS(8000).maxEBSIOPS(8000).defaultDataDiskSizeGB(160).wiredTigerEngineConfigString("cache_size=18432MB").maxIncomingConnections(16000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M60(new Builder().printableName("M60").ramSizeGB(64.0).numCPUs(16.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(16000).defaultDataDiskSizeGB(320).wiredTigerEngineConfigString("cache_size=36864MB").maxIncomingConnections(32000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M100(new Builder().printableName("M100").ramSizeGB(160.0).numCPUs(40.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(32000).defaultDataDiskSizeGB(1000).wiredTigerEngineConfigString("cache_size=102400MB").maxIncomingConnections(96000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M140(new Builder().printableName("M140").ramSizeGB(192.0).numCPUs(48.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(32000).defaultDataDiskSizeGB(1000).wiredTigerEngineConfigString("cache_size=122880MB").maxIncomingConnections(96000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M200(new Builder().printableName("M200").ramSizeGB(256.0).numCPUs(64.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(32000).defaultDataDiskSizeGB(1500).wiredTigerEngineConfigString("cache_size=167936MB").maxIncomingConnections(128000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    M300(new Builder().printableName("M300").ramSizeGB(384.0).numCPUs(96.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(32000).defaultDataDiskSizeGB(2000).wiredTigerEngineConfigString("cache_size=245760MB").maxIncomingConnections(128000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096})),
    R40(new Builder().printableName("R40").ramSizeGB(15.24).numCPUs(2.0).numDataDisks(1).maxEBSStandardIOPS(3000).maxEBSIOPS(3000).defaultDataDiskSizeGB(80).wiredTigerEngineConfigString("cache_size=8192MB").maxIncomingConnections(4000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096}).isLowCPU(true).highCPUEquivalent(M40.name())),
    R50(new Builder().printableName("R50").ramSizeGB(30.5).numCPUs(4.0).numDataDisks(1).maxEBSStandardIOPS(6000).maxEBSIOPS(6000).defaultDataDiskSizeGB(160).wiredTigerEngineConfigString("cache_size=18432MB").maxIncomingConnections(16000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096}).isLowCPU(true).highCPUEquivalent(M50.name())),
    R60(new Builder().printableName("R60").ramSizeGB(61.0).numCPUs(8.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(12000).defaultDataDiskSizeGB(320).wiredTigerEngineConfigString("cache_size=36864MB").maxIncomingConnections(32000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096}).isLowCPU(true).highCPUEquivalent(M60.name())),
    R80(new Builder().printableName("R80").ramSizeGB(122.0).numCPUs(16.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(18750).defaultDataDiskSizeGB(750).wiredTigerEngineConfigString("cache_size=73728MB").maxIncomingConnections(64000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096}).isLowCPU(true).highCPUEquivalent("M80")),
    R200(new Builder().printableName("R200").ramSizeGB(244.0).numCPUs(32.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(32000).defaultDataDiskSizeGB(1500).wiredTigerEngineConfigString("cache_size=167936MB").maxIncomingConnections(128000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096}).isLowCPU(true).highCPUEquivalent(M200.name())),
    R400(new Builder().printableName("R400").ramSizeGB(488.0).numCPUs(64.0).numDataDisks(1).maxEBSStandardIOPS(10000).maxEBSIOPS(32000).defaultDataDiskSizeGB(3000).wiredTigerEngineConfigString("cache_size=335872MB").maxIncomingConnections(128000).electionTimeoutMillis(5000).storageOptionsGB(new int[]{10, 20, 40, 80, 160, 320, 1024, 4096}).isLowCPU(true).highCPUEquivalent("M400")),
    M40_NVME(new Builder().printableName("M40_NVME").ramSizeGB(15.25).numCPUs(2.0).numDataDisks(1).maxEBSStandardIOPS(3000).maxEBSIOPS(3000).maxSSDReadIOPS(100125).maxSSDWriteIOPS(35000).defaultDataDiskSizeGB(380).backupDiskSizeGB(400).backupDiskIOPS(3000).wiredTigerEngineConfigString("cache_size=8192MB").maxIncomingConnections(4000).electionTimeoutMillis(5000).isNVMe(true).raidEndMiB(362396).highCPUEquivalent(M40.name())),
    M50_NVME(new Builder().printableName("M50_NVME").ramSizeGB(30.5).numCPUs(4.0).numDataDisks(1).maxEBSStandardIOPS(6000).maxEBSIOPS(6000).maxSSDReadIOPS(206250).maxSSDWriteIOPS(70000).defaultDataDiskSizeGB(760).backupDiskSizeGB(800).backupDiskIOPS(6000).wiredTigerEngineConfigString("cache_size=18432MB").maxIncomingConnections(16000).electionTimeoutMillis(5000).isNVMe(true).raidEndMiB(724793).highCPUEquivalent(M50.name())),
    M60_NVME(new Builder().printableName("M60_NVME").ramSizeGB(61.0).numCPUs(8.0).numDataDisks(1).maxEBSStandardIOPS(12000).maxEBSIOPS(12000).maxSSDReadIOPS(421500).maxSSDWriteIOPS(180000).defaultDataDiskSizeGB(1600).backupDiskSizeGB(1680).backupDiskIOPS(12000).wiredTigerEngineConfigString("cache_size=36864MB").maxIncomingConnections(32000).electionTimeoutMillis(5000).isNVMe(true).raidEndMiB(1449585).highCPUEquivalent(M60.name())),
    M80_NVME(new Builder().printableName("M80_NVME").ramSizeGB(122.0).numCPUs(16.0).numDataDisks(2).maxEBSStandardIOPS(16000).maxEBSIOPS(16000).maxSSDReadIOPS(825000).maxSSDWriteIOPS(360000).defaultDataDiskSizeGB(1600).backupDiskSizeGB(1680).backupDiskIOPS(16000).wiredTigerEngineConfigString("cache_size=73728MB").maxIncomingConnections(64000).electionTimeoutMillis(5000).isNVMe(true).raidEndMiB(1449585).highCPUEquivalent("M80")),
    M200_NVME(new Builder().printableName("M200_NVME").ramSizeGB(244.0).numCPUs(32.0).numDataDisks(4).maxEBSStandardIOPS(18000).maxEBSIOPS(18000).maxSSDReadIOPS(1650000).maxSSDWriteIOPS(720000).defaultDataDiskSizeGB(3100).backupDiskSizeGB(3255).backupDiskIOPS(18000).wiredTigerEngineConfigString("cache_size=167936MB").maxIncomingConnections(128000).electionTimeoutMillis(5000).isNVMe(true).raidEndMiB(1449585).highCPUEquivalent(M200.name())),
    M400_NVME(new Builder().printableName("M400_NVME").ramSizeGB(512.0).numCPUs(72.0).numDataDisks(8).maxEBSStandardIOPS(18000).maxEBSIOPS(18000).defaultDataDiskSizeGB(4000).maxSSDReadIOPS(3300000).maxSSDWriteIOPS(1400000).backupDiskSizeGB(4200).backupDiskIOPS(18000).wiredTigerEngineConfigString("cache_size=335872MB").maxIncomingConnections(128000).electionTimeoutMillis(5000).isNVMe(true).isMetal(true).raidEndMiB(953675).highCPUEquivalent("M400"));

    private static final int MAX_DISK_SIZE_GB = 4096;
    private final String _printableName;
    private final double _ramSizeGB;
    private final double _numCPUs;
    private final int _numDataDisks;
    private final int _defaultDataDiskSizeGB;
    private final int[] _storageOptionsGB;
    private final int _maxEBSStandardIOPS;
    private final int _maxEBSIOPS;
    private final Integer _maxSSDReadIOPS;
    private final Integer _maxSSDWriteIOPS;
    private final int _minEBSIOPSPerGB = 3;
    private final int _maxEBSIOPSPerGB = 30;
    private final int _minEBSIOPS = 100;
    private final int _backupDiskSizeGB;
    private final int _backupDiskIOPS;
    private final String _wiredTigerEngineConfigString;
    private final Integer _maxIncomingConnections;
    private final Integer _electionTimeoutMillis;
    private final boolean _isLowCPU;
    private final String _highCPUEquivalent;
    private final boolean _isNVMe;
    private final boolean _isMetal;
    private final Integer _raidEndMiB;
    private final int _diskToRamRatio;

    private AWSInstanceSize(Builder pBuilder) {
        this._printableName = pBuilder.printableName;
        this._ramSizeGB = pBuilder.ramSizeGB;
        this._numCPUs = pBuilder.numCPUs;
        this._numDataDisks = pBuilder.numDataDisks;
        this._defaultDataDiskSizeGB = pBuilder.defaultDiskSizeGB;
        this._storageOptionsGB = pBuilder.storageOptionsGB;
        this._maxEBSStandardIOPS = pBuilder.maxEBSStandardIOPS;
        this._maxEBSIOPS = pBuilder.maxEBSIOPS;
        this._maxSSDReadIOPS = pBuilder.maxSSDReadIOPS;
        this._maxSSDWriteIOPS = pBuilder.maxSSDWriteIOPS;
        this._backupDiskSizeGB = pBuilder.backupDiskSizeGB;
        this._backupDiskIOPS = pBuilder.backupDiskIOPS;
        this._wiredTigerEngineConfigString = pBuilder.wiredTigerEngineConfigString;
        this._maxIncomingConnections = pBuilder.maxIncomingConnections;
        this._electionTimeoutMillis = pBuilder.electionTimeoutMillis;
        this._isLowCPU = pBuilder.isLowCPU;
        this._highCPUEquivalent = pBuilder.highCPUEquivalent;
        this._isNVMe = pBuilder.isNVMe;
        this._isMetal = pBuilder.isMetal;
        this._raidEndMiB = pBuilder.raidEndMiB;
        this._diskToRamRatio = pBuilder.diskToRamRatio;
    }

    public String getName() {
        return this.name();
    }

    public String getPrintableName() {
        return this._printableName;
    }

    public double getRamSizeGB() {
        return this._ramSizeGB;
    }

    public double getNumCPUs() {
        return this._numCPUs;
    }

    public int getNumDataDisks() {
        return this._numDataDisks;
    }

    public int getMaxCloudProviderDiskSizeGB() {
        return 4096;
    }

    public int getDefaultDiskSizeGB() {
        return this._defaultDataDiskSizeGB;
    }

    public int[] getStorageOptionsGB() {
        return this._storageOptionsGB;
    }

    public int getMaxEBSStandardIOPS() {
        return this._maxEBSStandardIOPS;
    }

    public int getMaxEBSIOPS() {
        return this._maxEBSIOPS;
    }

    public Optional<Integer> getMaxSSDReadIOPS() {
        return Optional.ofNullable(this._maxSSDReadIOPS);
    }

    public Optional<Integer> getMaxSSDWriteIOPS() {
        return Optional.ofNullable(this._maxSSDWriteIOPS);
    }

    public Optional<Integer> getBackupDiskSizeGB() {
        return Optional.ofNullable(this._backupDiskSizeGB);
    }

    public Optional<Integer> getBackupDiskIOPS() {
        return Optional.ofNullable(this._backupDiskIOPS);
    }

    public int getMinEBSIOPSPerGB() {
        return 3;
    }

    public int getMaxEBSIOPSPerGB() {
        return 30;
    }

    public int getMinEBSIOPS() {
        return 100;
    }

    public int getMidIOPS() {
        return (this._maxEBSIOPS - 100) / 2 + 100;
    }

    public int getDiskToRamRatio() {
        return this._diskToRamRatio;
    }

    public int getMidIOPS(double pDiskSize) {
        return (this.getMaxIOPS(pDiskSize) - this.getMinEBSIOPS(pDiskSize)) / 2 + this.getMinEBSIOPS(pDiskSize);
    }

    public Optional<Integer> getMaxIncomingConnections() {
        return Optional.ofNullable(this._maxIncomingConnections);
    }

    public Optional<Integer> getElectionTimeoutMillis() {
        return Optional.ofNullable(this._electionTimeoutMillis);
    }

    public Optional<String> getWiredTigerEngineConfigString() {
        return Optional.ofNullable(this._wiredTigerEngineConfigString);
    }

    public boolean isLowCPU() {
        return this._isLowCPU;
    }

    public String getHighCPUEquivalent() {
        return this._highCPUEquivalent;
    }

    public boolean isNVMe() {
        return this._isNVMe;
    }

    public boolean isMetal() {
        return this._isMetal;
    }

    public Optional<Integer> getRaidEndMiB() {
        return Optional.ofNullable(this._raidEndMiB);
    }

    public int getMinEBSIOPS(double pDiskSizeGB) {
        int upperBound = Math.min(this.getMinEBSIOPSPerGB() * (int)pDiskSizeGB, this.getMaxIOPS(pDiskSizeGB));
        return Math.min(Math.max(100, upperBound), this.getMaxEBSStandardIOPS());
    }

    public int getMaxIOPS(double pDiskSizeGB) {
        int maxIOPS = this._maxEBSIOPS == 0 ? this._maxEBSStandardIOPS : this._maxEBSIOPS;
        return Math.min(maxIOPS, this.getMaxEBSIOPSPerGB() * (int)pDiskSizeGB);
    }

    public int getScaledIOPS(int pCurrentDiskIOPS, double pCurrentDiskSizeGB, double pNewDiskSizeGB, boolean pIsNVMeFeatureEnabled) {
        if (this.equals((Object)M10) || this.equals((Object)M20)) {
            int newIOPS = Math.min(this.getMaxEBSStandardIOPS(), this.getMinEBSIOPSPerGB() * (int)pNewDiskSizeGB);
            return Math.max(100, newIOPS);
        }
        if (pIsNVMeFeatureEnabled) {
            int minIOPS = this.getMinEBSIOPS(pNewDiskSizeGB);
            int maxIOPS = this.getMaxIOPS(pNewDiskSizeGB);
            if (pCurrentDiskIOPS < minIOPS) {
                return minIOPS;
            }
            if (pCurrentDiskIOPS > maxIOPS) {
                return maxIOPS;
            }
            return pCurrentDiskIOPS;
        }
        if (pCurrentDiskIOPS == this.getMaxIOPS(pCurrentDiskSizeGB)) {
            return this.getMaxIOPS(pNewDiskSizeGB);
        }
        if (pCurrentDiskIOPS == this.getMidIOPS(pCurrentDiskSizeGB)) {
            return this.getMidIOPS(pNewDiskSizeGB);
        }
        return Math.min(this.getMinEBSIOPS(pNewDiskSizeGB), this.getMaxEBSStandardIOPS());
    }

    public static Optional<AWSInstanceSize> findByName(String pInstanceType) {
        return Arrays.asList(AWSInstanceSize.values()).stream().filter(i -> i.name().equals(pInstanceType)).findFirst();
    }

    private static class Builder {
        private String printableName;
        private double ramSizeGB;
        private int diskToRamRatio;
        private double numCPUs;
        private int numDataDisks;
        private int defaultDiskSizeGB;
        private int[] storageOptionsGB;
        private int maxEBSStandardIOPS;
        private int maxEBSIOPS;
        private Integer maxSSDReadIOPS;
        private Integer maxSSDWriteIOPS;
        private int backupDiskSizeGB;
        private int backupDiskIOPS;
        private String wiredTigerEngineConfigString;
        private Integer maxIncomingConnections;
        private Integer electionTimeoutMillis;
        private boolean isLowCPU;
        private String highCPUEquivalent;
        private boolean isNVMe;
        private boolean isMetal;
        private Integer raidEndMiB;

        private Builder() {
        }

        public Builder printableName(String pPrintableName) {
            this.printableName = pPrintableName;
            return this;
        }

        public Builder ramSizeGB(double pRamSizeGB) {
            this.ramSizeGB = pRamSizeGB;
            return this;
        }

        public Builder numCPUs(double pNumCPUs) {
            this.numCPUs = pNumCPUs;
            return this;
        }

        public Builder numDataDisks(int pNumDataDisks) {
            this.numDataDisks = pNumDataDisks;
            return this;
        }

        public Builder defaultDataDiskSizeGB(int pDefaultDiskSizeGB) {
            this.defaultDiskSizeGB = pDefaultDiskSizeGB;
            return this;
        }

        public Builder storageOptionsGB(int[] pStorageOptionsGB) {
            this.storageOptionsGB = pStorageOptionsGB;
            return this;
        }

        public Builder maxEBSStandardIOPS(int pMaxEBSStandardIOPS) {
            this.maxEBSStandardIOPS = pMaxEBSStandardIOPS;
            return this;
        }

        public Builder maxEBSIOPS(int pMaxEBSIOPS) {
            this.maxEBSIOPS = pMaxEBSIOPS;
            return this;
        }

        public Builder backupDiskSizeGB(int pBackupDiskSizeGB) {
            this.backupDiskSizeGB = pBackupDiskSizeGB;
            return this;
        }

        public Builder backupDiskIOPS(int pBackupDiskIOPS) {
            this.backupDiskIOPS = pBackupDiskIOPS;
            return this;
        }

        public Builder maxSSDReadIOPS(int pMaxSSDReadIOPS) {
            this.maxSSDReadIOPS = pMaxSSDReadIOPS;
            return this;
        }

        public Builder maxSSDWriteIOPS(int pMaxSSDWriteIOPS) {
            this.maxSSDWriteIOPS = pMaxSSDWriteIOPS;
            return this;
        }

        public Builder wiredTigerEngineConfigString(String pConfigString) {
            this.wiredTigerEngineConfigString = pConfigString;
            return this;
        }

        public Builder maxIncomingConnections(Integer pMaxIncomingConnections) {
            this.maxIncomingConnections = pMaxIncomingConnections;
            return this;
        }

        public Builder electionTimeoutMillis(Integer pElectionTimeoutMillis) {
            this.electionTimeoutMillis = pElectionTimeoutMillis;
            return this;
        }

        public Builder isLowCPU(boolean pIsLowCPU) {
            this.isLowCPU = pIsLowCPU;
            return this;
        }

        public Builder highCPUEquivalent(String pHighCPUEquivalent) {
            this.highCPUEquivalent = pHighCPUEquivalent;
            return this;
        }

        public Builder isNVMe(boolean pIsNVMe) {
            this.isNVMe = pIsNVMe;
            return this;
        }

        public Builder isMetal(boolean pIsMetal) {
            this.isMetal = pIsMetal;
            return this;
        }

        public Builder raidEndMiB(Integer pRaidEndMiB) {
            this.raidEndMiB = pRaidEndMiB;
            return this;
        }

        public Builder diskToRamRatio(int pDiskToRamRatio) {
            this.diskToRamRatio = pDiskToRamRatio;
            return this;
        }
    }
}

