/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.cloud;

import com.mongodb.atlas.model.DatabasesResult;
import com.mongodb.atlas.model.MeasurementsResult;
import com.mongodb.atlas.model.ProcessesResult;
import com.mongodb.cloud.model.Cluster;
import com.mongodb.cloud.model.ClustersResult;
import com.mongodb.cloud.model.DisksResult;
import com.mongodb.cloud.model.HostsResult;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;

public interface AtlasApi {
    @GET(value="groups/{groupId}/clusters")
    public Call<ClustersResult> getClusters(@Path(value="groupId") String var1);

    @GET(value="groups/{groupId}/hosts")
    public Call<HostsResult> getHosts(@Path(value="groupId") String var1);

    @GET(value="groups/{groupId}/hosts/{hostId}/disks")
    public Call<DisksResult> getDisks(@Path(value="groupId") String var1, @Path(value="hostId") String var2);

    @GET(value="groups/{groupId}/clusters/{clusterName}")
    public Call<Cluster> getCluster(@Path(value="groupId") String var1, @Path(value="clusterName") String var2);

    @GET(value="groups/{groupId}/processes")
    public Call<ProcessesResult> getProcesses(@Path(value="groupId") String var1);

    @GET(value="groups/{groupId}/processes/{hostId}/measurements?granularity=PT1M&period=P2D&&m=CACHE_BYTES_READ_INTO&m=CACHE_BYTES_WRITTEN_FROM")
    public Call<MeasurementsResult> getMeasurements(@Path(value="groupId") String var1, @Path(value="hostId") String var2);

    @GET(value="groups/{groupId}/hosts/{hostId}/disks/{partitionName}/measurements?granularity=PT1H&period=P2D")
    public Call<MeasurementsResult> getDiskMeasurements(@Path(value="groupId") String var1, @Path(value="hostId") String var2, @Path(value="partitionName") String var3);

    @GET(value="groups/{groupId}/processes/{hostId}/disks/xbdb/measurements?granularity=PT1M&period=P2D&m=DISK_PARTITION_IOPS_TOTAL")
    public Call<MeasurementsResult> getDiskMeasurements(@Path(value="groupId") String var1, @Path(value="hostId") String var2);

    @GET(value="groups/{groupId}/processes/{hostId}/databases")
    public Call<DatabasesResult> getDatabases(@Path(value="groupId") String var1, @Path(value="hostId") String var2);

    @GET(value="groups/{groupId}/processes/{hostId}/databases/{databaseName}/measurements?granularity=PT24H&period=PT24H")
    public Call<MeasurementsResult> getDatabaseMeasurements(@Path(value="groupId") String var1, @Path(value="hostId") String var2, @Path(value="databaseName") String var3);
}

