/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.cloud;

import com.mongodb.atlas.model.Database;
import com.mongodb.atlas.model.DatabasesResult;
import com.mongodb.atlas.model.DatabasesStats;
import com.mongodb.atlas.model.Measurement;
import com.mongodb.atlas.model.MeasurementDataPoint;
import com.mongodb.atlas.model.MeasurementsResult;
import com.mongodb.atlas.model.Process;
import com.mongodb.atlas.model.ProcessesResult;
import com.mongodb.client.MongoClient;
import com.mongodb.cloud.AtlasApi;
import com.mongodb.cloud.CloudServiceGenerator;
import com.mongodb.cloud.model.Cluster;
import com.mongodb.cloud.model.ClustersResult;
import com.mongodb.cloud.model.Disk;
import com.mongodb.cloud.model.DisksResult;
import com.mongodb.cloud.model.Host;
import com.mongodb.cloud.model.HostsResult;
import com.mongodb.util.ByteSizesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class CloudUtil {
    private static Logger logger = LoggerFactory.getLogger(CloudUtil.class);
    private AtlasApi service;
    private CodecRegistry pojoCodecRegistry;
    private MongoClient mongoClient;
    private String mongoUri;
    private DescriptiveStatistics diskStats = new DescriptiveStatistics();

    public CloudUtil(String username, String apiKey, String mongoUri) {
        this.service = CloudServiceGenerator.createService(AtlasApi.class, username, apiKey);
        this.mongoUri = mongoUri;
        this.init();
    }

    private void init() {
        this.pojoCodecRegistry = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()});
    }

    public List<Cluster> getClusters(String groupId) throws IOException {
        Call<ClustersResult> callSync = this.service.getClusters(groupId);
        Response response = callSync.execute();
        ClustersResult clusters = (ClustersResult)response.body();
        return clusters.getClusters();
    }

    public List<Host> getHosts(String groupId) throws IOException {
        Call<HostsResult> callSync = this.service.getHosts(groupId);
        Response response = callSync.execute();
        HostsResult result = (HostsResult)response.body();
        return result.getHosts();
    }

    public List<Disk> getDisks(String groupId, String hostId) throws IOException {
        Call<DisksResult> callSync = this.service.getDisks(groupId, hostId);
        Response response = callSync.execute();
        DisksResult result = (DisksResult)response.body();
        return result.getDisks();
    }

    public Cluster getCluster(String groupId, String clusterName) throws IOException {
        Call<Cluster> callSync = this.service.getCluster(groupId, clusterName);
        Response response = callSync.execute();
        Cluster cluster = (Cluster)response.body();
        return cluster;
    }

    public List<Process> getProcesses(String groupId) throws IOException {
        Call<ProcessesResult> callSync = this.service.getProcesses(groupId);
        Response response = callSync.execute();
        System.out.println(response);
        ProcessesResult procs = (ProcessesResult)response.body();
        return procs.getProcesses();
    }

    public void getMeasurements(String groupId, String hostId) throws IOException {
        Call<MeasurementsResult> callSync = this.service.getMeasurements(groupId, hostId);
        Response response = callSync.execute();
        MeasurementsResult result = (MeasurementsResult)response.body();
        if (result != null) {
            List<Measurement> measurements = result.getMeasurements();
            for (Measurement m : measurements) {
                for (MeasurementDataPoint d : m.getDataPoints()) {
                    if (d.getValue() == null) continue;
                    System.out.println(String.valueOf(m.getName()) + " " + d);
                }
            }
        }
    }

    public List<Measurement> getDiskMeasurements(String groupId, String hostId, String paritionName) throws IOException {
        Call<MeasurementsResult> callSync = this.service.getDiskMeasurements(groupId, hostId, paritionName);
        Response response = callSync.execute();
        MeasurementsResult result = (MeasurementsResult)response.body();
        if (result != null) {
            return result.getMeasurements();
        }
        return null;
    }

    public DescriptiveStatistics getDiskStats(String groupId, String processId) throws IOException {
        this.diskStats.clear();
        Call<MeasurementsResult> callSync = this.service.getDiskMeasurements(groupId, processId);
        Response response = callSync.execute();
        MeasurementsResult result = (MeasurementsResult)response.body();
        if (result != null) {
            List<Measurement> measurements = result.getMeasurements();
            for (Measurement m : measurements) {
                for (MeasurementDataPoint d : m.getDataPoints()) {
                    if (d.getValue() == null) continue;
                    this.diskStats.addValue(d.getValue().doubleValue());
                }
            }
        }
        return this.diskStats;
    }

    public List<String> getDatabaseNames(String groupId, String processId) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        Call<DatabasesResult> callSync = this.service.getDatabases(groupId, processId);
        Response response = callSync.execute();
        DatabasesResult result = (DatabasesResult)response.body();
        if (result != null) {
            for (Database db : result.getDatabases()) {
                if (db.getDatabaseName().equals("local")) continue;
                results.add(db.getDatabaseName());
            }
        }
        return results;
    }

    public static double bytesToGigabytes(double pV) {
        return pV * 9.31323E-10;
    }

    private double getDbMeasurement(Measurement m) {
        double total = 0.0;
        for (MeasurementDataPoint d : m.getDataPoints()) {
            if (d.getValue() != null) {
                if (!m.getUnits().equals("BYTES")) {
                    throw new RuntimeException("Unexpected unit: " + m.getUnits());
                }
                double gb = CloudUtil.bytesToGigabytes(d.getValue());
                total += gb;
                continue;
            }
            throw new RuntimeException("null dataPoint, WTF!?");
        }
        return total;
    }

    public DatabasesStats getDatabasesStats(String groupId, String hostId) throws IOException {
        DatabasesStats stats = new DatabasesStats();
        List<String> databases = this.getDatabaseNames(groupId, hostId);
        for (String dbName : databases) {
            Call<MeasurementsResult> callSync = this.service.getDatabaseMeasurements(groupId, hostId, dbName);
            Response response = callSync.execute();
            MeasurementsResult result = (MeasurementsResult)response.body();
            if (result == null) continue;
            List<Measurement> measurements = result.getMeasurements();
            for (Measurement m : measurements) {
                if (m.getName().equals("DATABASE_DATA_SIZE")) {
                    stats.addDataSize(this.getDbMeasurement(m));
                    continue;
                }
                if (!m.getName().equals("DATABASE_INDEX_SIZE")) continue;
                stats.addIndexSize(this.getDbMeasurement(m));
            }
        }
        return stats;
    }

    public void getMeasurements(String groupId) throws IOException {
        List<Host> hosts = this.getHosts(groupId);
        for (Host host : hosts) {
            List<Disk> disks = this.getDisks(groupId, host.getId());
            for (Disk disk : disks) {
                List<Measurement> measurements = this.getDiskMeasurements(groupId, host.getId(), disk.getPartitionName());
                for (Measurement m : measurements) {
                    if (!m.getName().equals("DISK_PARTITION_SPACE_FREE")) continue;
                    List<MeasurementDataPoint> dps = m.getDataPoints();
                    MeasurementDataPoint firstPoint = dps.get(0);
                    double firstGB = ByteSizesUtil.bytesToGigabytes(firstPoint.getValue());
                    MeasurementDataPoint lastPoint = dps.get(dps.size() - 1);
                    double lastGB = ByteSizesUtil.bytesToGigabytes(lastPoint.getValue());
                    double delta = firstGB - lastGB;
                    double perDay = delta / 2.0;
                    double days = lastGB / perDay;
                    System.out.println(String.valueOf(host.getHostname()) + "    " + disk.getPartitionName() + " " + lastGB + " " + delta + " " + days);
                }
            }
        }
    }
}

