/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.cloud;

import com.mongodb.cloud.CloudUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CloudUtilApp {
    private static Options options;
    private static final String COLL_COUNTS = "compareCounts";
    private static final String CHUNK_COUNTS = "chunkCounts";
    private static final String COMPARE_IDS = "compareIds";

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"API user");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"user");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)"API key");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"key");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"k"));
        OptionBuilder.withArgName((String)"Group Id");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"groupId");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"g"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                CloudUtilApp.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            CloudUtilApp.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            CloudUtilApp.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("statsUtil", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = CloudUtilApp.initializeAndParseCommandLineOptions(args);
        CloudUtil util = new CloudUtil(line.getOptionValue("u"), line.getOptionValue("k"), "mongodb://localhost:27017/atlasMetrics");
        util.getMeasurements(line.getOptionValue("g"));
    }
}

