/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.corruptutil;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bson.BsonSerializationException;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorruptFinderWorker
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(CorruptFinderWorker.class);
    private MongoCollection<RawBsonDocument> collection;
    private MongoClient client;
    FileOutputStream fos = null;
    ZipOutputStream zipStream = null;
    private File outDir;

    public CorruptFinderWorker(MongoClient client, MongoCollection<RawBsonDocument> collection, File outDir) {
        this.collection = collection;
        this.client = client;
        this.outDir = outDir;
    }

    private void zip(String path, byte[] bytes) throws IOException {
        if (this.fos == null) {
            File outFile = new File(this.outDir, String.valueOf(this.collection.getNamespace().getFullName()) + ".zip");
            this.fos = new FileOutputStream(outFile);
            this.zipStream = new ZipOutputStream(this.fos);
        }
        ZipEntry zipEntry = new ZipEntry(path);
        this.zipStream.putNextEntry(zipEntry);
        this.zipStream.write(bytes, 0, bytes.length);
        this.zipStream.closeEntry();
    }

    private void handleCorrupt(RawBsonDocument doc, BsonValue id) {
        ByteBuffer buffer = doc.getByteBuffer().asNIO();
        try {
            this.zip(String.valueOf(id.toString()) + ".bson", buffer.array());
        }
        catch (IOException e) {
            logger.error("Error adding to zip", (Throwable)e);
        }
    }

    @Override
    public void run() {
        long start;
        MongoCursor cursor = null;
        long last = start = System.currentTimeMillis();
        long count = 0L;
        long corruptCount = 0L;
        try {
            cursor = this.collection.find().noCursorTimeout(true).iterator();
            Long total = this.collection.countDocuments();
            while (cursor.hasNext()) {
                ++count;
                RawBsonDocument doc = (RawBsonDocument)cursor.next();
                BsonValue id = null;
                try {
                    id = doc.get((Object)"_id");
                }
                catch (Exception e) {
                    ++corruptCount;
                    logger.trace(String.format("%s - Error reading doc id, count: %s, error: %s", this.collection.getNamespace(), count, e));
                    this.handleCorrupt(doc, id);
                    continue;
                }
                try {
                    String e = doc.toJson();
                }
                catch (BsonSerializationException bse) {
                    ++corruptCount;
                    logger.trace(String.format("%s - Error serializing doc with _id: %s, count: %s, error: %s", new Object[]{this.collection.getNamespace(), id, count, bse}));
                    this.handleCorrupt(doc, id);
                    continue;
                }
                long current = System.currentTimeMillis();
                long delta = (current - last) / 1000L;
                if (delta < 30L) continue;
                logger.debug(String.format("%s - checked %s / %s documents, corruptCount: %s", this.collection.getNamespace(), count, total));
                last = current;
            }
        }
        finally {
            cursor.close();
            if (this.fos != null) {
                try {
                    this.zipStream.close();
                    this.fos.close();
                }
                catch (IOException e) {
                    logger.debug("Error closing zip file", (Throwable)e);
                }
            }
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
        logger.debug(String.format("Done validating %s, %s documents in %f seconds, corruptCount: %s", this.collection.getNamespace(), count, dur, corruptCount));
    }
}

