/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.corruptutil;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.corruptutil.CorruptFinderWorker;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bson.RawBsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorruptUtil {
    private static Logger logger = LoggerFactory.getLogger(CorruptUtil.class);
    private Set<String> databasesBlacklist = new HashSet<String>(Arrays.asList("system", "local", "config", "admin"));
    private Set<String> collectionsBlacklist = new HashSet<String>(Arrays.asList("system.indexes", "system.profile"));
    private static Options options;
    private MongoClient sourceClient;
    private int threads = 4;
    private File outDir;
    private ExecutorService executor;

    public CorruptUtil(String sourceUriStr) {
        ConnectionString connectionString = new ConnectionString(sourceUriStr);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        this.sourceClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
    }

    public void run() throws InterruptedException {
        this.executor = Executors.newFixedThreadPool(this.threads);
        MongoIterable dbNames = this.sourceClient.listDatabaseNames();
        for (String dbName : dbNames) {
            if (this.databasesBlacklist.contains(dbName)) continue;
            MongoDatabase db = this.sourceClient.getDatabase(dbName);
            logger.debug("db " + dbName);
            MongoIterable collectionNames = db.listCollectionNames();
            for (String collectionName : collectionNames) {
                if (this.collectionsBlacklist.contains(collectionName)) continue;
                MongoCollection coll = db.getCollection(collectionName, RawBsonDocument.class);
                CorruptFinderWorker worker = new CorruptFinderWorker(this.sourceClient, (MongoCollection<RawBsonDocument>)coll, this.outDir);
                this.executor.execute(worker);
            }
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            logger.debug("Waiting for executor to terminate");
            Thread.sleep(1000L);
        }
        logger.debug("CorruptUtil complete");
    }

    private void setThreads(int threads) {
        this.threads = threads;
    }

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"Source cluster connection uri");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"source");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"Zip output path");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"outDir");
        OptionBuilder.isRequired((boolean)true);
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withArgName((String)"# threads");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"threads");
        options.addOption(OptionBuilder.create((String)"t"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                CorruptUtil.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            CorruptUtil.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            CorruptUtil.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("logParser", options);
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String outDirStr;
        File outDir;
        CommandLine line = CorruptUtil.initializeAndParseCommandLineOptions(args);
        CorruptUtil util = new CorruptUtil(line.getOptionValue("s"));
        String threadsStr = line.getOptionValue("t");
        if (threadsStr != null) {
            int threads = Integer.parseInt(threadsStr);
            util.setThreads(threads);
        }
        if (!(outDir = new File(outDirStr = line.getOptionValue("o"))).canWrite()) {
            throw new IOException("Can't write to outDir " + outDirStr);
        }
        util.setOutDir(outDir);
        util.run();
    }

    private void setOutDir(File outDir) {
        this.outDir = outDir;
    }
}

