/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.diffutil.DiffResult;
import com.mongodb.diffutil.OplogTailingDiffUtil;
import com.mongodb.model.Namespace;
import com.mongodb.util.DiffUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffTask
implements Callable<DiffResult> {
    protected static final Logger logger = LoggerFactory.getLogger(OplogTailingDiffUtil.class);
    private static final Document SORT_ID = new Document("_id", (Object)1);
    private Namespace ns;
    private Set<Object> buffer;
    private MongoClient sourceMongoClient;
    private MongoClient destMongoClient;
    private String sourceShardId;
    private long id;

    public DiffTask(Set<Object> buffer, String sourceShardId, Namespace ns, MongoClient sourceClient, MongoClient destClient, long id) {
        this.buffer = buffer;
        this.ns = ns;
        this.sourceMongoClient = sourceClient;
        this.destMongoClient = destClient;
        this.sourceShardId = sourceShardId;
        this.id = id;
    }

    @Override
    public DiffResult call() throws Exception {
        DiffResult result = new DiffResult(this.sourceShardId);
        Bson filter = Filters.in((String)"_id", this.buffer);
        MongoDatabase sourceDb = this.sourceMongoClient.getDatabase(this.ns.getDatabaseName());
        MongoDatabase destDb = this.destMongoClient.getDatabase(this.ns.getDatabaseName());
        MongoCollection sourceColl = sourceDb.getCollection(this.ns.getCollectionName(), RawBsonDocument.class);
        MongoCollection destColl = destDb.getCollection(this.ns.getCollectionName(), RawBsonDocument.class);
        MongoCursor sourceCursor = sourceColl.find(filter).sort((Bson)SORT_ID).iterator();
        MongoCursor destCursor = destColl.find(filter).sort((Bson)SORT_ID).iterator();
        RawBsonDocument sourceDoc = null;
        RawBsonDocument destDoc = null;
        byte[] sourceBytes = null;
        byte[] destBytes = null;
        long lastReport = System.currentTimeMillis();
        while (sourceCursor.hasNext()) {
            sourceDoc = (RawBsonDocument)sourceCursor.next();
            BsonValue sourceId = sourceDoc.get((Object)"_id");
            if (!destCursor.hasNext()) {
                logger.error(String.format("%s - destCursor exhausted, doc %s missing", this.ns, sourceId));
                result.incrementMissing();
                continue;
            }
            destDoc = (RawBsonDocument)destCursor.next();
            sourceBytes = sourceDoc.getByteBuffer().array();
            destBytes = destDoc.getByteBuffer().array();
            if (sourceBytes.length == destBytes.length) {
                if (!DiffUtils.compareHashes(sourceBytes, destBytes)) {
                    BsonValue id = sourceDoc.get((Object)"_id");
                    if (sourceDoc.equals((Object)destDoc)) {
                        logger.error(String.format("%s - docs equal, but hash mismatch, id: %s", this.ns, id));
                        result.incrementKeysMisordered();
                    } else {
                        logger.error(String.format("%s - doc hash mismatch, id: %s", this.ns, id));
                        result.incrementHashMismatched();
                    }
                } else {
                    result.incrementMatches();
                }
            } else {
                logger.debug("Doc sizes not equal, id: " + sourceId);
                boolean xx = DiffUtils.compareDocuments(this.ns.getNamespace(), sourceDoc, destDoc);
                result.incrementHashMismatched();
            }
            result.incrementTotal();
        }
        return result;
    }
}

