/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.diffutil.DiffSummary;
import com.mongodb.model.Namespace;
import com.mongodb.model.ShardCollection;
import com.mongodb.util.DiffUtils;
import com.mongodb.util.bson.BsonValueComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bson.BsonDateTime;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffUtil {
    private static Logger logger = LoggerFactory.getLogger(DiffUtil.class);
    private String sourceClusterUri;
    private String destClusterUri;
    private MongoClient sourceClient;
    private MongoClient destClient;
    private Set<Namespace> includedNamespaces = new HashSet<Namespace>();
    private Set<String> includedNamespaceStrings = new HashSet<String>();
    private Set<String> includedDatabases = new HashSet<String>();
    private Map<String, Set<String>> includedCollections = new HashMap<String, Set<String>>();
    private static final Document SORT_ID = new Document("_id", (Object)1);
    private Map<String, Document> sourceDbInfoMap = new TreeMap<String, Document>();
    private Map<String, Document> destDbInfoMap = new TreeMap<String, Document>();
    private BsonValueComparator comparator = new BsonValueComparator();
    MongoDatabase currentSourceDb;
    MongoDatabase currentDestDb;
    private String currentDbName;
    private String currentCollectionName;
    private String currentNs;
    private boolean reportMissing = true;
    private boolean reportMatches = false;
    private int batchSize;
    long sourceTotal = 0L;
    long destTotal = 0L;
    long lastReport;
    long sourceCount;
    long destCount;

    public void init() {
        ConnectionString source = new ConnectionString(this.sourceClusterUri);
        this.sourceClient = MongoClients.create((ConnectionString)source);
        this.sourceClient.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
        logger.debug("Connected to source");
        ConnectionString dest = new ConnectionString(this.destClusterUri);
        this.destClient = MongoClients.create((ConnectionString)dest);
        this.destClient.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
        Document listDatabases = new Document("listDatabases", (Object)1);
        Document sourceDatabases = this.sourceClient.getDatabase("admin").runCommand((Bson)listDatabases);
        Document destDatabases = this.destClient.getDatabase("admin").runCommand((Bson)listDatabases);
        List sourceDatabaseInfo = (List)sourceDatabases.get((Object)"databases");
        List destDatabaseInfo = (List)destDatabases.get((Object)"databases");
        if (this.includedNamespaces == null || this.includedNamespaces.isEmpty()) {
            this.populateDbMap(sourceDatabaseInfo, this.sourceDbInfoMap);
        } else {
            for (Document dbInfo : sourceDatabaseInfo) {
                String dbName = dbInfo.getString((Object)"name");
                if (!this.includedDatabases.contains(dbName)) continue;
                this.sourceDbInfoMap.put(dbName, dbInfo);
            }
        }
        this.populateDbMap(destDatabaseInfo, this.destDbInfoMap);
    }

    public DiffSummary compareDocuments(boolean parallelCursorMode) {
        DiffSummary ds = null;
        boolean filtered = !this.includedCollections.isEmpty();
        logger.debug("Starting compareDocuments mode, filtered {}", (Object)filtered);
        ds = parallelCursorMode ? this.compare2() : this.compareAllDocumentsInCollectionUsingQueryMode();
        logger.debug(String.format("%s dbs compared, %s collections compared, missingDbs %s, docMatches: %s, missingDocs: %s, hashMismatched: %s, keysMisordered: %s", ds.totalDbs, ds.totalCollections, ds.missingDbs, ds.totalMatches, ds.totalMissingDocs, ds.totalHashMismatched, ds.totalKeysMisordered));
        return ds;
    }

    private DiffSummary compareAllDocumentsInCollectionUsingQueryMode() {
        DiffSummary ds = new DiffSummary();
        long sourceCount = this.currentSourceDb.getCollection(this.currentCollectionName).countDocuments();
        long destCount = this.currentDestDb.getCollection(this.currentCollectionName).countDocuments();
        logger.debug(String.format("Starting collection: %s - %d documents", this.currentNs, sourceCount));
        if (sourceCount != destCount) {
            logger.error(String.format("%s - doc count mismatch - sourceCount: %s, destCount: %s", this.currentNs, sourceCount, destCount));
        }
        MongoCollection sourceColl = this.currentSourceDb.getCollection(this.currentCollectionName, RawBsonDocument.class);
        MongoCollection destColl = this.currentDestDb.getCollection(this.currentCollectionName, RawBsonDocument.class);
        MongoCursor sourceCursor = sourceColl.find().sort((Bson)SORT_ID).iterator();
        RawBsonDocument sourceDoc = null;
        Object destDoc = null;
        Object sourceBytes = null;
        Object destBytes = null;
        long missing = 0L;
        long matches = 0L;
        long keysMisordered = 0L;
        long hashMismatched = 0L;
        long total = 0L;
        long lastReport = System.currentTimeMillis();
        ArrayList<RawBsonDocument> sourceBuffer = new ArrayList<RawBsonDocument>(this.batchSize);
        ArrayList<BsonValue> sourceIds = new ArrayList<BsonValue>(this.batchSize);
        ArrayList destBuffer = new ArrayList(this.batchSize);
        while (sourceCursor.hasNext()) {
            sourceDoc = (RawBsonDocument)sourceCursor.next();
            BsonValue sourceId = sourceDoc.get((Object)"_id");
            sourceBuffer.add(sourceDoc);
            sourceIds.add(sourceId);
            if (sourceBuffer.size() < this.batchSize) continue;
            destColl.find(Filters.in((String)"_id", sourceIds)).sort((Bson)SORT_ID).into(destBuffer);
        }
        ++ds.totalCollections;
        ds.totalMatches += matches;
        ds.totalKeysMisordered += keysMisordered;
        ds.totalHashMismatched += hashMismatched;
        ds.totalMissingDocs += missing;
        logger.debug(String.format("%s.%s complete - matches: %d, missing: %d, outOfOrderKeys: %s, hashMismatched: %d", this.currentSourceDb.getName(), this.currentCollectionName, matches, missing, keysMisordered, hashMismatched));
        return ds;
    }

    private DiffSummary compareAllDocumentsInCollection() {
        DiffSummary ds = new DiffSummary();
        this.sourceTotal = 0L;
        this.destTotal = 0L;
        this.sourceCount = 0L;
        this.destCount = 0L;
        this.lastReport = System.currentTimeMillis();
        this.sourceCount = this.currentSourceDb.getCollection(this.currentCollectionName).countDocuments();
        long destCount = this.currentDestDb.getCollection(this.currentCollectionName).countDocuments();
        logger.debug(String.format("Starting collection: %s - %d documents", this.currentNs, this.sourceCount));
        if (this.sourceCount != destCount) {
            logger.error(String.format("%s - doc count mismatch - sourceCount: %s, destCount: %s", this.currentNs, this.sourceCount, destCount));
        }
        MongoCollection sourceColl = this.currentSourceDb.getCollection(this.currentCollectionName, RawBsonDocument.class);
        MongoCollection destColl = this.currentDestDb.getCollection(this.currentCollectionName, RawBsonDocument.class);
        MongoCursor sourceCursor = sourceColl.find().sort((Bson)SORT_ID).iterator();
        MongoCursor destCursor = destColl.find().sort((Bson)SORT_ID).iterator();
        RawBsonDocument sourceDoc = null;
        RawBsonDocument destDoc = null;
        byte[] sourceBytes = null;
        byte[] destBytes = null;
        long missing = 0L;
        long matches = 0L;
        long keysMisordered = 0L;
        long hashMismatched = 0L;
        while (sourceCursor.hasNext()) {
            sourceDoc = (RawBsonDocument)sourceCursor.next();
            ++this.sourceTotal;
            BsonValue sourceId = sourceDoc.get((Object)"_id");
            BsonValue destId = null;
            while (!sourceId.equals(destId)) {
                if (destCursor.hasNext()) {
                    destDoc = (RawBsonDocument)destCursor.next();
                    ++this.destTotal;
                } else {
                    logger.error(String.format("%s - destCursor exhausted, doc %s missing", this.currentNs, sourceId));
                    ++missing;
                    continue;
                }
                destId = destDoc.get((Object)"_id");
                this.statusCheck();
            }
            sourceBytes = sourceDoc.getByteBuffer().array();
            if (sourceBytes.length == (destBytes = destDoc.getByteBuffer().array()).length) {
                if (!DiffUtils.compareHashes(sourceBytes, destBytes)) {
                    BsonValue id = sourceDoc.get((Object)"_id");
                    if (sourceDoc.equals((Object)destDoc)) {
                        logger.error(String.format("%s - docs equal, but hash mismatch, id: %s", this.currentNs, id));
                        ++keysMisordered;
                    } else {
                        BsonDateTime sourceDate = sourceDoc.getDateTime((Object)"date");
                        BsonDateTime destDate = null;
                        if (sourceDate != null) {
                            destDate = destDoc.getDateTime((Object)"date");
                            logger.error(String.format("%s - doc hash mismatch, id: %s, sourceDate: %s, destDate: %s", this.currentNs, id, new Date(sourceDate.getValue()), new Date(destDate.getValue())));
                        } else {
                            logger.error(String.format("%s - doc hash mismatch, id: %s", this.currentNs, id));
                        }
                        ++hashMismatched;
                    }
                } else {
                    ++matches;
                }
            } else {
                logger.debug("Doc sizes not equal, id: " + sourceId);
                boolean xx = DiffUtils.compareDocuments(this.currentNs, sourceDoc, destDoc);
                ++hashMismatched;
            }
            this.statusCheck();
        }
        ++ds.totalCollections;
        ds.totalMatches += matches;
        ds.totalKeysMisordered += keysMisordered;
        ds.totalHashMismatched += hashMismatched;
        ds.totalMissingDocs += missing;
        logger.debug(String.format("%s.%s complete - matches: %d, missing: %d, outOfOrderKeys: %s, hashMismatched: %d", this.currentSourceDb.getName(), this.currentCollectionName, matches, missing, keysMisordered, hashMismatched));
        return ds;
    }

    private void statusCheck() {
        long now = System.currentTimeMillis();
        long elapsedSinceLastReport = now - this.lastReport;
        if (elapsedSinceLastReport >= 30000L) {
            logger.debug("source: {}/{} - {} percent complete, destTotal: {}", new Object[]{this.sourceTotal, this.sourceCount, this.sourceTotal / this.sourceCount, this.destTotal});
            this.lastReport = now;
        }
    }

    private void populateDbMap(List<Document> dbInfoList, Map<String, Document> databaseMap) {
        for (Document dbInfo : dbInfoList) {
            databaseMap.put(dbInfo.getString((Object)"name"), dbInfo);
        }
    }

    private List<Document> splitVector(String namespace) {
        Document splitVectorCmd = new Document("splitVector", (Object)namespace);
        Document keyPattern = new Document("_id", (Object)1);
        splitVectorCmd.append("keyPattern", (Object)keyPattern);
        splitVectorCmd.append("maxChunkSizeBytes", (Object)1000000);
        Document splits = this.destClient.getDatabase("admin").runCommand((Bson)splitVectorCmd);
        List splitKeys = (List)splits.get((Object)"splitKeys");
        logger.debug("splits: " + splitKeys);
        return splitKeys;
    }

    private void populateCollectionList(MongoDatabase db, List<ShardCollection> list) {
        MongoCollection shardsColl = db.getCollection("collections", ShardCollection.class);
        shardsColl.find(Filters.eq((String)"dropped", (Object)false)).sort(Sorts.ascending((String[])new String[]{"_id"})).into(list);
    }

    public String getSourceClusterUri() {
        return this.sourceClusterUri;
    }

    public void setSourceClusterUri(String sourceClusterUri) {
        this.sourceClusterUri = sourceClusterUri;
    }

    public String getDestClusterUri() {
        return this.destClusterUri;
    }

    public void setDestClusterUri(String destClusterUri) {
        this.destClusterUri = destClusterUri;
    }

    public DiffSummary compare2() {
        DiffSummary ds = new DiffSummary();
        logger.debug("Starting compare2 mode");
        Document sort = new Document("_id", (Object)1);
        boolean filtered = !this.includedCollections.isEmpty();
        for (String dbName : this.sourceDbInfoMap.keySet()) {
            Document destInfo = this.destDbInfoMap.get(dbName);
            if (dbName.equals("admin") || dbName.equals("local") || dbName.equals("config")) continue;
            if (destInfo != null) {
                ++ds.totalDbs;
                MongoDatabase sourceDb = this.sourceClient.getDatabase(dbName);
                MongoDatabase destDb = this.destClient.getDatabase(dbName);
                MongoIterable sourceCollectionNames = sourceDb.listCollectionNames();
                for (String collectionName : sourceCollectionNames) {
                    Set<String> colls;
                    if (collectionName.equals("system.profile") || collectionName.equals("system.indexes") || filtered && !(colls = this.includedCollections.get(dbName)).contains(collectionName)) continue;
                    ++ds.totalCollections;
                    logger.debug(String.format("Starting collection %s, namespace %s.%s", ds.totalCollections, dbName, collectionName));
                    MongoCollection sourceColl = sourceDb.getCollection(collectionName, RawBsonDocument.class);
                    MongoCollection destColl = destDb.getCollection(collectionName, RawBsonDocument.class);
                    long sourceCount = 0L;
                    long destCount = 0L;
                    MongoCursor sourceCursor = sourceColl.find().sort((Bson)sort).iterator();
                    MongoCursor destCursor = destColl.find().sort((Bson)sort).iterator();
                    RawBsonDocument sourceDoc = null;
                    RawBsonDocument sourceNext = null;
                    BsonValue sourceKey = null;
                    RawBsonDocument destDoc = null;
                    RawBsonDocument destNext = null;
                    BsonValue destKey = null;
                    Integer compare = null;
                    while (sourceCursor.hasNext() || sourceNext != null || destCursor.hasNext() || destNext != null) {
                        byte[] destBytes;
                        if (sourceNext != null) {
                            sourceDoc = sourceNext;
                            sourceNext = null;
                            sourceKey = sourceDoc.get((Object)"_id");
                        } else if (sourceCursor.hasNext()) {
                            sourceDoc = (RawBsonDocument)sourceCursor.next();
                            ++sourceCount;
                            sourceKey = sourceDoc.get((Object)"_id");
                        } else {
                            sourceDoc = null;
                            sourceKey = null;
                        }
                        if (destNext != null) {
                            destDoc = destNext;
                            destNext = null;
                            destKey = destDoc.get((Object)"_id");
                        } else if (destCursor.hasNext()) {
                            destDoc = (RawBsonDocument)destCursor.next();
                            ++destCount;
                            destKey = destDoc.get((Object)"_id");
                        } else {
                            destDoc = null;
                            destKey = null;
                        }
                        if (sourceKey != null && destKey != null) {
                            compare = this.comparator.compare(sourceKey, destKey);
                        } else {
                            if (sourceKey == null) {
                                ++ds.totalMissingDocs;
                                continue;
                            }
                            if (destKey == null) {
                                if (this.reportMissing) {
                                    logger.error(String.format("%s - fail: %s missing on dest", collectionName, sourceKey));
                                }
                                ++ds.totalMissingDocs;
                                continue;
                            }
                        }
                        if (compare < 0) {
                            if (this.reportMissing) {
                                logger.error(String.format("%s - fail: %s missing on dest", collectionName, sourceKey));
                            }
                            ++ds.totalMissingDocs;
                            destNext = destDoc;
                            continue;
                        }
                        if (compare > 0) {
                            ++ds.totalMissingDocs;
                            sourceNext = sourceDoc;
                            continue;
                        }
                        byte[] sourceBytes = sourceDoc.getByteBuffer().array();
                        if (sourceBytes.length == (destBytes = destDoc.getByteBuffer().array()).length) {
                            if (!DiffUtils.compareHashes(sourceBytes, destBytes)) {
                                BsonValue id = sourceDoc.get((Object)"_id");
                                if (sourceDoc.equals((Object)destDoc)) {
                                    logger.error(String.format("%s - docs equal, but hash mismatch, id: %s", this.currentNs, id));
                                    ++ds.totalKeysMisordered;
                                    continue;
                                }
                                logger.error(String.format("%s - doc hash mismatch, id: %s", this.currentNs, id));
                                ++ds.totalHashMismatched;
                                continue;
                            }
                            ++ds.totalMatches;
                            continue;
                        }
                        logger.debug("Doc sizes not equal, source id: {}, dest id: {}" + sourceKey, (Object)destKey);
                        boolean xx = DiffUtils.compareDocuments(this.currentNs, sourceDoc, destDoc);
                        ++ds.totalHashMismatched;
                    }
                    logger.debug(String.format("%s - complete. sourceCount: %s, destCount: %s", collectionName, sourceCount, destCount));
                }
                continue;
            }
            logger.error(String.format("Destination db not found, name: %s", dbName));
            ++ds.missingDbs;
        }
        logger.debug(String.format("%s dbs compared, %s collections compared, missingDbs %s, idMatches: %s, missingDocs: %s", ds.totalDbs, ds.totalCollections, ds.missingDbs, ds.totalMatches, ds.totalMissingDocs));
        return ds;
    }

    public void compareIds() {
        DiffSummary ds = new DiffSummary();
        logger.debug("Starting compareIds mode");
        Document sort = new Document("_id", (Object)1);
        boolean filtered = !this.includedCollections.isEmpty();
        for (String dbName : this.sourceDbInfoMap.keySet()) {
            Document destInfo = this.destDbInfoMap.get(dbName);
            if (destInfo != null) {
                if (dbName.equals("admin") || dbName.equals("local") || dbName.equals("config")) continue;
                ++ds.totalDbs;
                MongoDatabase sourceDb = this.sourceClient.getDatabase(dbName);
                MongoDatabase destDb = this.destClient.getDatabase(dbName);
                MongoIterable sourceCollectionNames = sourceDb.listCollectionNames();
                for (String collectionName : sourceCollectionNames) {
                    Set<String> colls;
                    if (collectionName.equals("system.profile") || collectionName.equals("system.indexes") || filtered && !(colls = this.includedCollections.get(dbName)).contains(collectionName)) continue;
                    ++ds.totalCollections;
                    logger.debug(String.format("Starting namespace %s.%s", dbName, collectionName));
                    MongoCollection sourceColl = sourceDb.getCollection(collectionName, RawBsonDocument.class);
                    MongoCollection destColl = destDb.getCollection(collectionName, RawBsonDocument.class);
                    long sourceCount = 0L;
                    long destCount = 0L;
                    MongoCursor sourceCursor = sourceColl.find().sort((Bson)sort).projection((Bson)sort).iterator();
                    MongoCursor destCursor = destColl.find().sort((Bson)sort).projection((Bson)sort).iterator();
                    RawBsonDocument sourceDoc = null;
                    RawBsonDocument sourceNext = null;
                    BsonValue sourceKey = null;
                    RawBsonDocument destDoc = null;
                    RawBsonDocument destNext = null;
                    BsonValue destKey = null;
                    Integer compare = null;
                    while (sourceCursor.hasNext() || sourceNext != null || destCursor.hasNext() || destNext != null) {
                        if (sourceNext != null) {
                            sourceDoc = sourceNext;
                            sourceNext = null;
                            sourceKey = sourceDoc.get((Object)"_id");
                        } else if (sourceCursor.hasNext()) {
                            sourceDoc = (RawBsonDocument)sourceCursor.next();
                            ++sourceCount;
                            sourceKey = sourceDoc.get((Object)"_id");
                        } else {
                            sourceDoc = null;
                            sourceKey = null;
                        }
                        if (destNext != null) {
                            destDoc = destNext;
                            destNext = null;
                            destKey = destDoc.get((Object)"_id");
                        } else if (destCursor.hasNext()) {
                            destDoc = (RawBsonDocument)destCursor.next();
                            ++destCount;
                            destKey = destDoc.get((Object)"_id");
                        } else {
                            destDoc = null;
                            destKey = null;
                        }
                        if (sourceKey != null && destKey != null) {
                            compare = this.comparator.compare(sourceKey, destKey);
                        } else {
                            if (sourceKey == null) {
                                if (this.reportMissing) {
                                    logger.error(String.format("%s - fail: %s missing on source", collectionName, destKey));
                                }
                                ++ds.totalMissingDocs;
                                continue;
                            }
                            if (destKey == null) {
                                if (this.reportMissing) {
                                    logger.error(String.format("%s - fail: %s missing on dest", collectionName, sourceKey));
                                }
                                ++ds.totalMissingDocs;
                                continue;
                            }
                        }
                        if (compare < 0) {
                            if (this.reportMissing) {
                                logger.error(String.format("%s - fail: %s missing on dest", collectionName, sourceKey));
                            }
                            ++ds.totalMissingDocs;
                            destNext = destDoc;
                            continue;
                        }
                        if (compare > 0) {
                            if (this.reportMissing) {
                                logger.warn(String.format("%s - fail: %s missing on source", collectionName, destKey));
                            }
                            ++ds.totalMissingDocs;
                            sourceNext = sourceDoc;
                            continue;
                        }
                        if (this.reportMatches) {
                            logger.debug("match on {}, _id: {}", (Object)collectionName, (Object)sourceKey);
                            RawBsonDocument s = (RawBsonDocument)sourceColl.find(Filters.eq((String)"_id", (Object)sourceKey)).projection(Projections.include((String[])new String[]{"deviceid", "tenantid", "date"})).first();
                            RawBsonDocument d = (RawBsonDocument)destColl.find(Filters.eq((String)"_id", (Object)sourceKey)).projection(Projections.include((String[])new String[]{"deviceid", "tenantid", "date"})).first();
                            logger.debug("src dupe: {}", (Object)s);
                            logger.debug("dest dupe: {}", (Object)d);
                        }
                        ++ds.totalMatches;
                    }
                    logger.debug(String.format("%s - complete. sourceCount: %s, destCount: %s", collectionName, sourceCount, destCount));
                }
                continue;
            }
            logger.error(String.format("Destination db not found, name: %s", dbName));
            ++ds.missingDbs;
        }
        logger.debug(String.format("%s dbs compared, %s collections compared, missingDbs %s, idMatches: %s, missingDocs: %s", ds.totalDbs, ds.totalCollections, ds.missingDbs, ds.totalMatches, ds.totalMissingDocs));
    }

    public DiffSummary compareShardCounts() {
        DiffSummary ds = new DiffSummary();
        logger.debug("Starting compareShardCounts mode");
        boolean filtered = !this.includedCollections.isEmpty();
        for (String dbName : this.sourceDbInfoMap.keySet()) {
            Document destInfo = this.destDbInfoMap.get(dbName);
            if (destInfo != null) {
                if (dbName.equals("admin") || dbName.equals("local") || dbName.equals("config")) continue;
                ++ds.totalDbs;
                MongoDatabase sourceDb = this.sourceClient.getDatabase(dbName);
                MongoDatabase destDb = this.destClient.getDatabase(dbName);
                MongoIterable sourceCollectionNames = sourceDb.listCollectionNames();
                for (String collectionName : sourceCollectionNames) {
                    if (collectionName.equals("system.profile") || collectionName.equals("system.indexes") || collectionName.startsWith("system.")) continue;
                    Namespace ns = new Namespace(dbName, collectionName);
                    if (filtered && !this.includedNamespaces.contains(ns)) continue;
                    long[] result = this.doCounts(sourceDb, destDb, collectionName);
                    this.sourceTotal += result[0];
                    this.destTotal += result[1];
                }
                logger.debug("Database {} - source count sourceTotal: {}, dest count sourceTotal {}", new Object[]{dbName, this.sourceTotal, this.destTotal});
                continue;
            }
            logger.warn(String.format("Destination db not found, name: %s", dbName));
        }
        return ds;
    }

    private long[] doCounts(MongoDatabase sourceDb, MongoDatabase destDb, String collectionName) {
        return this.doCounts(sourceDb, destDb, collectionName, null);
    }

    private long[] doCounts(MongoDatabase sourceDb, MongoDatabase destDb, String collectionName, Bson query) {
        long[] result = new long[2];
        Long sourceCount = null;
        Long destCount = null;
        if (query == null) {
            sourceCount = sourceDb.getCollection(collectionName).countDocuments();
            destCount = destDb.getCollection(collectionName).countDocuments();
        } else {
            sourceCount = sourceDb.getCollection(collectionName).countDocuments(query);
            destCount = destDb.getCollection(collectionName).countDocuments(query);
        }
        result[0] = sourceCount;
        result[1] = destCount;
        if (sourceCount.equals(destCount)) {
            logger.debug(String.format("%s.%s count matches: %s", sourceDb.getName(), collectionName, sourceCount));
            return result;
        }
        logger.warn(String.format("%s.%s count MISMATCH - source: %s, dest: %s, query: %s", sourceDb.getName(), collectionName, sourceCount, destCount, query));
        return result;
    }

    public void setIncludes(String[] includes) {
        if (includes != null) {
            Collections.addAll(this.includedNamespaceStrings, includes);
            String[] stringArray = includes;
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                String nsStr = stringArray[n2];
                if (nsStr.contains(".")) {
                    Namespace ns = new Namespace(nsStr);
                    this.includedNamespaces.add(ns);
                    this.includedDatabases.add(ns.getDatabaseName());
                    Set<String> colls = this.includedCollections.get(ns.getDatabaseName());
                    if (colls == null) {
                        colls = new HashSet<String>();
                        this.includedCollections.put(ns.getDatabaseName(), colls);
                    }
                    colls.add(ns.getCollectionName());
                } else {
                    this.includedDatabases.add(nsStr);
                }
                ++n2;
            }
        }
    }

    public void setReportMissing(boolean reportMissing) {
        this.reportMissing = reportMissing;
    }

    public void setReportMatches(boolean reportMatches) {
        this.reportMatches = reportMatches;
    }

    public void setIncludedNamespaces(Set<Namespace> includes) {
        this.includedNamespaces = includes;
        if (includes != null) {
            for (Namespace ns : includes) {
                String nsStr = ns.getNamespace();
                if (nsStr.contains(".")) {
                    this.includedNamespaceStrings.add(nsStr);
                    this.includedDatabases.add(ns.getDatabaseName());
                    Set<String> colls = this.includedCollections.get(ns.getDatabaseName());
                    if (colls == null) {
                        colls = new HashSet<String>();
                        this.includedCollections.put(ns.getDatabaseName(), colls);
                    }
                    colls.add(ns.getCollectionName());
                    continue;
                }
                this.includedDatabases.add(nsStr);
            }
        }
    }
}

