/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.diffutil.DiffUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffUtilApp {
    private static Logger logger = LoggerFactory.getLogger(DiffUtilApp.class);
    private static Options options;
    private static CommandLine line;
    private static final String SOURCE_URI = "source";
    private static final String DEST_URI = "dest";
    private static final String COLL_COUNTS = "compareCounts";
    private static final String COMPARE_DOCUMENTS = "compareDocuments";
    private static final String COMPARE_DOCUMENTS_QUERY = "compareDocumentsQuery";
    private static final String COMPARE_IDS = "compareIds";
    private static final String NO_REPORT_MISSING = "noReportMissing";
    private static final String REPORT_MATCHES = "reportMatches";

    private static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"Source cluster connection uri");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)SOURCE_URI);
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withArgName((String)"Destination cluster connection uri");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)DEST_URI);
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)"Configuration properties file");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withArgName((String)"Include namespace");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"includeNamespace");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"Compare counts only");
        OptionBuilder.withLongOpt((String)COLL_COUNTS);
        options.addOption(OptionBuilder.create((String)COLL_COUNTS));
        OptionBuilder.withArgName((String)"Compare all documents in all collections, using parallel cursors");
        OptionBuilder.withLongOpt((String)COMPARE_DOCUMENTS);
        options.addOption(OptionBuilder.create((String)COMPARE_DOCUMENTS));
        OptionBuilder.withArgName((String)"Compare all documents in all collections, using per document query match");
        OptionBuilder.withLongOpt((String)COMPARE_DOCUMENTS_QUERY);
        options.addOption(OptionBuilder.create((String)COMPARE_DOCUMENTS_QUERY));
        OptionBuilder.withArgName((String)"Compare ids ");
        OptionBuilder.withLongOpt((String)COMPARE_IDS);
        options.addOption(OptionBuilder.create((String)COMPARE_IDS));
        OptionBuilder.withArgName((String)"Do not report missing docs");
        OptionBuilder.withLongOpt((String)NO_REPORT_MISSING);
        options.addOption(OptionBuilder.create((String)NO_REPORT_MISSING));
        OptionBuilder.withArgName((String)"Report missing docs");
        OptionBuilder.withLongOpt((String)REPORT_MATCHES);
        options.addOption(OptionBuilder.create((String)REPORT_MATCHES));
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                DiffUtilApp.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            DiffUtilApp.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            DiffUtilApp.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("logParser", options);
        System.exit(-1);
    }

    private static Properties readProperties() {
        Properties prop = new Properties();
        File propsFile = null;
        if (line.hasOption("c")) {
            propsFile = new File(line.getOptionValue("c"));
        } else {
            propsFile = new File("diff-util.properties");
            if (!propsFile.exists()) {
                propsFile = new File("shard-sync.properties");
            }
            if (!propsFile.exists()) {
                logger.warn("Default config files diff-util.properties or shard-sync.properties, not found, using command line options only");
                return prop;
            }
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream input = new FileInputStream(propsFile);){
                prop.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            logger.error("Error loading properties file: " + propsFile, (Throwable)ioe);
        }
        return prop;
    }

    public static void main(String[] args) throws Exception {
        CommandLine line = DiffUtilApp.initializeAndParseCommandLineOptions(args);
        Properties configFileProps = DiffUtilApp.readProperties();
        DiffUtil sync = new DiffUtil();
        sync.setSourceClusterUri(line.getOptionValue("s", configFileProps.getProperty(SOURCE_URI)));
        sync.setDestClusterUri(line.getOptionValue("d", configFileProps.getProperty(DEST_URI)));
        if (line.hasOption(REPORT_MATCHES)) {
            sync.setReportMatches(true);
        }
        if (line.hasOption(NO_REPORT_MISSING)) {
            sync.setReportMissing(false);
        }
        String[] includes = line.getOptionValues("f");
        sync.setIncludes(includes);
        sync.init();
        if (line.hasOption(COLL_COUNTS)) {
            sync.compareShardCounts();
        }
        if (line.hasOption(COMPARE_DOCUMENTS)) {
            sync.compareDocuments(true);
        }
        if (line.hasOption(COMPARE_DOCUMENTS_QUERY)) {
            sync.compareDocuments(false);
        }
        if (line.hasOption(COMPARE_IDS)) {
            sync.compareIds();
        }
    }
}

