/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.util.Timer;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor
extends Thread {
    public static final int displayMillis = 15000;
    public static final int sleepMillis = 500;
    protected static final Logger logger = LoggerFactory.getLogger(Monitor.class);
    private volatile Timer timer;
    private static long lastDisplayMillis = 0L;
    private boolean running = true;
    private ThreadPoolExecutor pool;
    private int totalSkipped = 0;
    private Thread parent;
    private int lastSkipped = 0;
    private long lastCount = 0L;

    public Monitor(Thread _p) {
        this.parent = _p;
        lastDisplayMillis = System.currentTimeMillis();
    }

    @Override
    public void run() {
        block5: {
            logger.debug("starting");
            this.timer = new Timer();
            try {
                try {
                    this.monitor();
                    this.timer.stop();
                    logger.info("replayed " + this.timer.getEventCount() + " records ok (" + this.timer.getProgressMessage() + "), with " + this.timer.getErrorCount() + " error(s)");
                }
                catch (Throwable t) {
                    logger.error("fatal error", t);
                    this.cleanup();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.cleanup();
                throw throwable;
            }
            this.cleanup();
        }
        logger.trace("exiting");
    }

    private void cleanup() {
        this.pool.shutdownNow();
        logger.trace("waiting for executor to terminate");
        try {
            this.pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.parent.interrupt();
        if (this.isInterrupted()) {
            logger.info("resetting interrupt status");
            Monitor.interrupted();
        }
    }

    private void monitor() throws Exception {
        int count = 0;
        logger.trace("looping every 500");
        while (this.running && !this.isInterrupted()) {
            Thread.yield();
            long currentMillis = System.currentTimeMillis();
            long elapsed = currentMillis - lastDisplayMillis;
            if (currentMillis - lastDisplayMillis > 15000L) {
                lastDisplayMillis = currentMillis;
                this.lastSkipped = this.totalSkipped;
                this.lastCount = this.timer.getEventCount().get();
                logger.info("replayed record " + this.timer.getEventCount() + " (" + this.timer.getProgressMessage() + "), with " + this.timer.getErrorCount() + " error(s) " + this.pool.getActiveCount() + " active threads, " + this.pool.getQueue().size() + " queued tasks");
                logger.info("thread count: core=" + this.pool.getCorePoolSize() + ", active=" + this.pool.getActiveCount());
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++count;
        }
        if (this.isInterrupted()) {
            Monitor.interrupted();
        }
    }

    public void halt() {
        if (!this.running) {
            return;
        }
        logger.info("halting");
        this.running = false;
        this.pool.shutdownNow();
        this.interrupt();
    }

    public void halt(Throwable t) {
        logger.warn("fatal - halting monitor");
        logger.error(t.getMessage());
        this.halt();
    }

    public void incrementEventCount() {
        this.timer.incrementEventCount();
    }

    public void incrementErrorCount() {
        this.timer.incrementErrorCount();
    }

    public long getEventCount() {
        return this.timer.getEventCount().get();
    }

    public void incrementSkipped(String message) {
        ++this.totalSkipped;
    }

    public ThreadPoolExecutor getPool() {
        return this.pool;
    }

    public void setPool(ThreadPoolExecutor pool) {
        this.pool = pool;
    }
}

