/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.diffutil;

import com.mongodb.CursorType;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.diffutil.DiffOptions;
import com.mongodb.model.ShardTimestamp;
import com.mongodb.shardsync.ShardClient;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OplogTailWorker
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(OplogTailWorker.class);
    private String shardId;
    private ShardTimestamp shardTimestamp;
    private ShardClient sourceShardClient;
    private ShardClient destShardClient;
    private DiffOptions options;

    public OplogTailWorker(ShardTimestamp shardTimestamp, ShardClient sourceShardClient, ShardClient destShardClient, DiffOptions options) {
        this.shardId = shardTimestamp.getShardName();
        this.shardTimestamp = shardTimestamp;
        this.sourceShardClient = sourceShardClient;
        this.destShardClient = destShardClient;
        this.options = options;
    }

    @Override
    public void run() {
        MongoDatabase local = this.sourceShardClient.getShardMongoClient(this.shardId).getDatabase("local");
        MongoCollection oplog = local.getCollection("oplog.rs", RawBsonDocument.class);
        MongoCursor cursor = null;
        Bson query = Filters.and((Bson[])new Bson[]{Filters.gte((String)"ts", (Object)this.shardTimestamp.getTimestamp()), Filters.ne((String)"op", (Object)"n")});
        long start = System.currentTimeMillis();
        long count = 0L;
        try {
            for (RawBsonDocument doc : oplog.find(query).sort((Bson)new Document("$natural", (Object)1)).noCursorTimeout(true).cursorType(CursorType.TailableAwait)) {
                String string = doc.getString((Object)"ns").getValue();
            }
        }
        finally {
            cursor.close();
        }
        long end = System.currentTimeMillis();
        Double dur = (double)(end - start) / 1000.0;
    }
}

